/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.pnp.proxy;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import enea.ose.system.SignalRegistry;
import enea.ose.system.ThisProcess;
import java.util.Timer;
import java.util.TimerTask;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMaster;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.proxy.AbstractSignalConverter;
import se.ericsson.crbs.omf.common.proxy.IllegalSignalException;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryFactory;
import se.ericsson.crbs.omf.mao.commonmo.transactions.transactionlistener.TransactionTypeList;
import se.ericsson.crbs.omf.mao.commonmo.upgrade.TriggerCentralWrapper;
import se.ericsson.crbs.omf.mao.pnp.cvhelper.CvCreator;
import se.ericsson.crbs.omf.mao.pnp.proxy.MaoPnpProxy;
import se.ericsson.crbs.omf.mao.pnp.proxy.OmfMaoPnpCfm;
import se.ericsson.crbs.omf.mao.pnp.proxy.OmfMaoPnpRej;
import se.ericsson.crbs.omf.mao.pnp.proxy.OmfMaoPnpReq;
import se.ericsson.crbs.omf.mao.pnp.proxy.PnpContext;
import se.ericsson.crbs.omf.mao.pnp.request.PnpRequest;
import se.ericsson.crbs.omf.mao.pnp.request.PnpSubRequest;
import se.ericsson.crbs.omf.mao.pnp.xml.PnpXmlPack;
import se.ericsson.crbs.omf.mao.pnp.xml.PnpXmlPackFactory;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class MaoPnpProxyImpl
extends AbstractSignalConverter
implements MaoPnpProxy,
Runnable,
UpgradeParticipator {
    protected static final Object MUTEX_OBJECT = new Object();
    private static final int TX_TIMEOUT = 120;
    private static AbstractLogger logger = LoggingService.getLogger((String)MaoPnpProxyImpl.class.getName());
    protected static final Class[] INPUT_SIGNALS = new Class[]{OmfMaoPnpReq.class};
    private static final Class THIS_CLASS = MaoPnpProxyImpl.class;
    protected static final String PNP_SERVICE_NAME = "RBS_PNP_SERVICE_NAME";
    private final PnpContext pnpContext;
    private final Timer timer;
    private TimerTask taskPerformer = null;
    private static final String name = "RBS pnpService";
    private static final int TIME_TO_WAIT = 60000;
    protected static final String TIME_WAITING_PROPERTY = "mao.pnp.time.to.wait";
    private final long timeToWait;
    private final PnpXmlPack pnpXmlPack;
    private static final int max_queued_signals = 100;

    public MaoPnpProxyImpl(PnpContext inputPnpContext) {
        super(PNP_SERVICE_NAME, INPUT_SIGNALS, 100);
        this.pnpContext = inputPnpContext;
        this.pnpXmlPack = PnpXmlPackFactory.getPnpXmlPack();
        this.registerForUpgradeTriggers();
        SignalRegistry sigReg = new SignalRegistry();
        sigReg.add(OmfMaoPnpReq.class);
        long localTimeToWait = 60000L;
        String timeToWaitStr = System.getProperty(TIME_WAITING_PROPERTY, "");
        if (!timeToWaitStr.equalsIgnoreCase("")) {
            try {
                localTimeToWait = Long.parseLong(timeToWaitStr);
            }
            catch (NumberFormatException nfe) {
                localTimeToWait = 60000L;
            }
        }
        this.timeToWait = localTimeToWait;
        this.timer = new Timer();
    }

    private boolean isUpgradeOngoing() {
        MoRepositoryWrapper moRepositoryWrapper = this.pnpContext.getMoRepositoryWrapper();
        MoIterator upIterator = moRepositoryWrapper.lookupType("UpgradePackage");
        boolean upgradeOngoing = false;
        while (upIterator.hasMoreElements() && !upgradeOngoing) {
            UpgradePackageMo upgradePackageMo = (UpgradePackageMo)upIterator.nextMo();
            try {
                int state = upgradePackageMo.getState(null);
                if (state != 2 && state != 3) continue;
                upgradeOngoing = true;
            }
            catch (MoAccessException e) {
                logger.traceAbnormal(THIS_CLASS, "Could not read upgrade MO assuming upgrade on-going. Will eventually start service after 10 min.");
                upgradeOngoing = true;
            }
        }
        logger.traceDebug(THIS_CLASS, "Upgrade on-going: " + upgradeOngoing);
        return upgradeOngoing;
    }

    public void sendOmfMaoPnpCfm(int addresseePid, int txId, int sessionId, int createCv, String data) {
        logger.traceEnter(THIS_CLASS, "sendOmfMaoPnpCfm()");
        CvCreator.createCv(this.pnpContext, createCv);
        this.sendSignal(addresseePid, (Signal)new OmfMaoPnpCfm(txId, sessionId, data));
        logger.traceReturn(THIS_CLASS, "sendOmfMaoPnpCfm()");
    }

    public void startService() {
        logger.traceEnter(THIS_CLASS, "startService()");
        String msg = null;
        if (null != this.taskPerformer) {
            this.taskPerformer.cancel();
            this.taskPerformer = null;
        }
        if (this.isServiceRunning()) {
            msg = "PnP service already running";
        } else if (this.isUpgradeOngoing()) {
            this.startDelayedPnpServiceTimer();
            msg = "PnP service not started, waiting for upgrade to finish";
        } else {
            super.startService();
            msg = "PnP Service started";
        }
        logger.traceDebug(THIS_CLASS, msg);
        logger.traceReturn(THIS_CLASS, "startService() - " + msg);
    }

    private void startDelayedPnpServiceTimer() {
        logger.traceEnter(THIS_CLASS, "startDelayedPnpServiceTimer()");
        this.taskPerformer = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                logger.traceDebug(THIS_CLASS, "Timer for delayed start of PnP service triggered.");
                MaoPnpProxyImpl.this.taskPerformer = null;
                MaoPnpProxyImpl.this.startService();
                Object object = MUTEX_OBJECT;
                synchronized (object) {
                    MUTEX_OBJECT.notifyAll();
                }
            }
        };
        this.timer.schedule(this.taskPerformer, this.timeToWait);
        logger.traceDebug(THIS_CLASS, "Timer started to trigger after: " + this.timeToWait / 1000L + " seconds");
        logger.traceReturn(THIS_CLASS, "startDelayedPnpServiceTimer()");
    }

    private void sendSignal(int addresseePid, Signal signal) {
        logger.traceEnter(THIS_CLASS, "sendSignal(" + addresseePid + ", " + signal + ")");
        OseProcess addressee = ThisProcess.getProcess((int)addresseePid);
        if (addressee == null) {
            logger.traceError(this.getClass(), "No addressee specified. Failed to send signal [" + signal.getClass().getName() + "]");
        } else {
            logger.traceGeneral(this.getClass(), "Sending signal " + signal.getClass().getName());
            SignalHelper.send((OseProcess)addressee, (Signal)signal);
        }
        logger.traceReturn(THIS_CLASS, "sendSignal(" + addresseePid + ", " + signal + ")");
    }

    private void registerForUpgradeTriggers() {
        logger.traceDebug(THIS_CLASS, "Registering for upgrade triggers");
        TriggerCentralWrapper.addUpgradeParticipator((UpgradeParticipator)this);
    }

    public String participatorName() {
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerIndicated(UpgradeMaster upgradeMaster, String trigger) {
        logger.traceEnter(THIS_CLASS, "triggerIndicated(" + trigger + ")");
        logger.traceDebug(THIS_CLASS, "Got trigger: " + trigger);
        try {
            if ("CONFIRMED".equalsIgnoreCase(trigger)) {
                logger.traceDebug(THIS_CLASS, "Upgrade finished, starting PnP service");
                this.startService();
            } else if (this.isUpgradeOngoing()) {
                if (this.isServiceRunning()) {
                    logger.traceDebug(THIS_CLASS, "Trigger shows ongoing upgrade, stopping PnP service");
                    this.stopService();
                } else {
                    logger.traceDebug(THIS_CLASS, "Trigger shows ongoing upgrade. PnP service not running");
                }
            } else {
                logger.traceDebug(THIS_CLASS, "Trigger shows ongoing upgrade but no UpgradePackageMo is executing.");
            }
        }
        finally {
            logger.traceDebug(THIS_CLASS, "Confirming trigger " + trigger);
            upgradeMaster.triggerConfirmed((UpgradeParticipator)this, trigger, true);
        }
        logger.traceReturn(THIS_CLASS, "triggerIndicated(" + trigger + ")");
    }

    public void inputSignalReceived(InSignal inSignal) throws IllegalSignalException {
        logger.traceEnter(THIS_CLASS, "inputSignalReceived(): PnP Proxy Signal received: " + inSignal);
        OmfMaoPnpReq maoPnpReq = (OmfMaoPnpReq)inSignal;
        logger.info(THIS_CLASS, "PnP Proxy Signal received inputSignalReceived sessionId: " + maoPnpReq.getSessionId() + ", createCv: " + maoPnpReq.getCreateCv() + ", txId: " + maoPnpReq.getTxId() + ", data:" + maoPnpReq.getData());
        try {
            InSignal nextInSignal = this.peekSignalQueue();
            boolean signalsAreIdentical = false;
            if (nextInSignal != null && nextInSignal instanceof OmfMaoPnpReq) {
                OmfMaoPnpReq nextMaoPnpReq = (OmfMaoPnpReq)nextInSignal;
                signalsAreIdentical = nextMaoPnpReq.getData().equalsIgnoreCase(maoPnpReq.getData());
            }
            if (signalsAreIdentical) {
                logger.traceAbnormal(THIS_CLASS, "Skipping redundant request with data:" + maoPnpReq.getData());
            } else {
                PnpRequest pnpRequest = new PnpRequest(this.getSender(inSignal).getPID(), maoPnpReq.getTxId(), maoPnpReq.getSessionId(), maoPnpReq.getCreateCv(), maoPnpReq.getData(), this.pnpContext);
                this.handleRequest(pnpRequest);
            }
        }
        catch (ProcessingFailureException e) {
            logger.traceAbnormal(THIS_CLASS, "inputSignalReceived ProcessingFailureException:" + e.getVariablesAsString());
        }
        logger.traceReturn(THIS_CLASS, "inputSignalReceived()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void handleRequest(PnpRequest pnpRequest) {
        Coordinator coordinator;
        block16: {
            logger.traceEnter(THIS_CLASS, "handleRequest ");
            Control control = null;
            coordinator = null;
            try {
                PnpSubRequest[] pnpSubRequests = pnpRequest.getSubRequests();
                if (pnpSubRequests.length == 0) {
                    logger.traceError(THIS_CLASS, "No valid actions included in PnP request!");
                    break block16;
                }
                control = this.getControl(pnpRequest);
                if (control == null) {
                    this.handleFailingRequest(pnpRequest);
                    break block16;
                }
                coordinator = control.getCoordinator();
                TransactionTypeList.getInstance().registerNonBlocking(coordinator);
                try {
                    PnpSubRequest[] pnpSubRequestArray = pnpSubRequests;
                    // MONITORENTER : pnpSubRequests
                    for (int i = 0; i < pnpSubRequests.length; ++i) {
                        pnpSubRequests[i].execute(coordinator);
                    }
                    // MONITOREXIT : pnpSubRequestArray
                    this.handleSuccessfulRequest(pnpRequest, control);
                }
                catch (ResourceLockedException e) {
                    try {
                        logger.traceAbnormal(THIS_CLASS, "ResourceLockedExteption catched. Send REJ with relevant datafield");
                        this.handleFailingRequest((Exception)((Object)e), pnpRequest, control, "ResourceLocked");
                    }
                    catch (Exception e1) {
                        logger.traceAbnormal(THIS_CLASS, "Exception catched during sending non-empty REJ. Fallback to empty REJ with no datafield");
                        this.handleFailingRequest(e1, pnpRequest, control);
                    }
                }
                catch (Exception e) {
                    this.handleFailingRequest(e, pnpRequest, control);
                }
            }
            catch (TransactionRolledBackException e) {
                logger.traceAbnormal(THIS_CLASS, "Failure when handling transaction: " + e.getMessage());
                {
                    catch (Throwable throwable) {
                        TransactionTypeList.getInstance().unregisterNonBlocking(coordinator);
                        throw throwable;
                    }
                }
                TransactionTypeList.getInstance().unregisterNonBlocking(coordinator);
                catch (InactiveTransactionException ite) {
                    logger.traceAbnormal(THIS_CLASS, "Failure when handling transaction: " + ite.getMessage());
                    TransactionTypeList.getInstance().unregisterNonBlocking(coordinator);
                }
            }
        }
        TransactionTypeList.getInstance().unregisterNonBlocking(coordinator);
        logger.traceReturn(THIS_CLASS, "handleRequest()");
    }

    private void handleSuccessfulRequest(PnpRequest pnpRequest, Control control) throws IllegalParameterValueException, SoftwareErrorException, TransactionRolledBackException, InactiveTransactionException {
        String result = "";
        Coordinator coordinator = null;
        int txId = pnpRequest.getTxId();
        try {
            result = this.pnpXmlPack.packConfirm(pnpRequest, "OK");
            logger.traceDebug(THIS_CLASS, "Handled successful request: " + pnpRequest);
        }
        catch (SoftwareErrorException e) {
            logger.traceAbnormal(THIS_CLASS, "traceAbnormal: Failure packing the result XML-string for request: " + pnpRequest.toString());
            throw e;
        }
        if (pnpRequest.getTxId() == 0) {
            coordinator = control.getCoordinator();
            txId = coordinator.getTransactionID();
            try {
                control.getTerminator().commit();
            }
            catch (TransactionRolledBackException e) {
                logger.traceAbnormal(THIS_CLASS, "traceAbnormal: Failure to commit the request: " + pnpRequest.toString() + " due to Transaction Rolled Back");
                throw e;
            }
            catch (InactiveTransactionException e) {
                logger.traceAbnormal(THIS_CLASS, "traceAbnormal: Failure to commit the request: " + pnpRequest.toString() + " due to Inactive Transaction");
                throw e;
            }
        }
        this.sendOmfMaoPnpCfm(pnpRequest.getSenderPid(), txId, pnpRequest.getSessionId(), pnpRequest.getCreateCv(), result);
    }

    protected void handleFailingRequest(Exception exception, PnpRequest pnpRequest, Control control, String rejectCause) throws InactiveTransactionException, IllegalParameterValueException, SoftwareErrorException {
        logger.traceEnter(THIS_CLASS, "handleFailingRequest() >> Exception:" + exception.getClass().getName() + ", rejectCause = " + rejectCause);
        String result = "";
        logger.traceAbnormal(THIS_CLASS, "traceAbnormal: Failure when handling PnP Request: , exception: " + exception.getClass().getName() + ", message: " + exception.getMessage() + ", pnpRequest: " + pnpRequest.toString());
        try {
            result = this.pnpXmlPack.packReject(pnpRequest, rejectCause);
            logger.traceDebug(THIS_CLASS, "Handled failed request: " + pnpRequest + ", PnpRej=" + result);
        }
        catch (SoftwareErrorException e) {
            logger.traceAbnormal(THIS_CLASS, "traceAbnormal: Failure packing the result XML-string for request: " + pnpRequest.toString());
            throw e;
        }
        if (pnpRequest.getTxId() == 0) {
            try {
                this.sendOmfMaoPnpRej(pnpRequest.getSenderPid(), pnpRequest.getTxId(), pnpRequest.getSessionId(), result);
                control.getTerminator().rollback();
            }
            catch (InactiveTransactionException e) {
                logger.traceAbnormal(THIS_CLASS, "Failure to rollback the request: " + pnpRequest.toString() + " due to Inactive Transaction");
                throw e;
            }
        }
        try {
            this.sendOmfMaoPnpRej(pnpRequest.getSenderPid(), pnpRequest.getTxId(), pnpRequest.getSessionId(), result);
            logger.traceDebug(THIS_CLASS, "Will run control.getCoordinator().rollbackOnly()");
            control.getCoordinator().rollbackOnly();
        }
        catch (InactiveTransactionException e) {
            logger.traceAbnormal(THIS_CLASS, "Failure to rollbackOnly the request: " + pnpRequest.toString() + " due to Inactive Transaction");
            throw e;
        }
        logger.traceReturn(THIS_CLASS, "handleFailingRequest()");
    }

    protected void handleFailingRequest(Exception exception, PnpRequest pnpRequest, Control control) throws InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "handleFailingRequest() >> Exception:" + exception.getClass().getName());
        logger.traceAbnormal(THIS_CLASS, "traceAbnormal: Failure when handling PnP Request:  exception: " + exception.getClass().getName() + " message: " + exception.getMessage() + pnpRequest.toString());
        if (pnpRequest.getTxId() == 0) {
            try {
                this.sendOmfMaoPnpRej(pnpRequest.getSenderPid(), pnpRequest.getTxId(), pnpRequest.getSessionId(), "");
                control.getTerminator().rollback();
            }
            catch (InactiveTransactionException e) {
                logger.traceAbnormal(THIS_CLASS, "Failure to rollback the request: " + pnpRequest.toString() + " due to Inactive Transaction");
                throw e;
            }
        }
        try {
            this.sendOmfMaoPnpRej(pnpRequest.getSenderPid(), pnpRequest.getTxId(), pnpRequest.getSessionId(), "");
            logger.traceDebug(THIS_CLASS, "Will run control.getCoordinator().rollbackOnly()");
            control.getCoordinator().rollbackOnly();
        }
        catch (InactiveTransactionException e) {
            logger.traceAbnormal(THIS_CLASS, "Failure to rollbackOnly the request: " + pnpRequest.toString() + " due to Inactive Transaction");
            throw e;
        }
        logger.traceReturn(THIS_CLASS, "handleFailingRequest()");
    }

    protected void handleFailingRequest(PnpRequest pnpRequest) {
        logger.traceEnter(THIS_CLASS, "handleFailingRequest()");
        logger.traceError(THIS_CLASS, "Null Control: Failure when handling PnP Request: " + pnpRequest.toString());
        this.sendOmfMaoPnpRej(pnpRequest.getSenderPid(), pnpRequest.getTxId(), pnpRequest.getSessionId(), "");
        logger.traceReturn(THIS_CLASS, "handleFailingRequest()");
    }

    private void sendOmfMaoPnpRej(int addresseePid, int txId, int sessionId, String data) {
        logger.traceEnter(THIS_CLASS, "sendOmfMaoPnpRej()");
        this.sendSignal(addresseePid, (Signal)new OmfMaoPnpRej(txId, sessionId, data));
        logger.traceReturn(THIS_CLASS, "sendOmfMaoPnpRej(): Rej sent" + ("".equals(data) ? "!" : ", data=" + data));
    }

    private Control getControl(PnpRequest pnpRequest) throws TransactionRolledBackException {
        logger.traceEnter(THIS_CLASS, "getControl(): txId = " + Integer.toString(pnpRequest.getTxId()));
        TransactionFactory transFact = TransactionServicesFactoryFactory.getTransactionServicesFactory().getCppTransactionFactory();
        Control control = null;
        control = pnpRequest.getTxId() == 0 ? transFact.create(120) : transFact.get(pnpRequest.getTxId());
        logger.traceReturn(THIS_CLASS, "getControl()");
        return control;
    }
}

