/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.pnp.request;

import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.Definitions;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.genericmo.DeleteableManagedObject;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.systemcreatedmos.SystemCreatedMaoFactory;
import se.ericsson.crbs.omf.mao.pnp.proxy.PnpContext;
import se.ericsson.crbs.omf.mao.pnp.request.AbstractPnpSubRequest;

public class PnpDeleteRequest
extends AbstractPnpSubRequest {
    public PnpDeleteRequest(PnpContext inputPnpContext) {
        super(PnpDeleteRequest.class, inputPnpContext);
    }

    public String getRequestType() {
        return "delete";
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(this.loggingClass, "execute " + this.getRequestType() + " - " + this.getLdn());
        AttrListImpl attrListIn = this.getAttributeList();
        List listAttrNames = attrListIn.getAttrNames();
        List listAttrValues = attrListIn.getAttrValues();
        AttrListImpl attrListOut = new AttrListImpl(this.pnpContext.getMoRepositoryWrapper());
        Iterator iterator = listAttrNames.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            String next = (String)iterator.next();
            if (Definitions.isTransparentData((String)next)) {
                attrListOut.addAttribute(next, listAttrValues.get(index));
            }
            ++index;
        }
        if (attrListOut.size() < 1) {
            ManagedObject moToDelete = this.getMo(this.getLdn());
            MoFactory moFactory = this.pnpContext.getMoFactoryMgrWrapper().lookup(moToDelete.getType());
            try {
                if (moFactory != null && moToDelete instanceof GenericMao && moFactory instanceof SystemCreatedMaoFactory) {
                    GenericMao del = (GenericMao)moToDelete;
                    logger.traceDebug(this.getClass(), " Pnp will try to remove it as a system created mo instead!");
                    del.deleteInternal(coordinator);
                }
                moToDelete.delete(coordinator);
            }
            catch (ProcessingFailureException e) {
                logger.traceDebug(this.getClass(), "Delete ProcessingFailureException caught ldn " + moToDelete.getLocalDistinguishedName());
                throw new ProcessingFailureException("Pnp failed to delete " + moToDelete.getLocalDistinguishedName() + e.getMessage());
            }
        } else {
            DeleteableManagedObject moDelete = null;
            try {
                moDelete = (DeleteableManagedObject)this.getMo(this.getLdn());
            }
            catch (ClassCastException e) {
                logger.traceError(this.loggingClass, "Could not cast the MoToDelete to GenericMao. Original exception: " + e.getMessage());
            }
            moDelete.delete((AttrList)attrListOut, coordinator);
        }
        logger.traceReturn(this.loggingClass, "execute");
    }
}

