/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.pnp.request;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.pnp.proxy.PnpContext;
import se.ericsson.crbs.omf.mao.pnp.request.PnpSubRequest;
import se.ericsson.crbs.omf.mao.pnp.xml.PnpXmlHandler;

public class PnpRequest {
    private static final AbstractLogger logger = LoggingService.getLogger();
    private static final Class THIS_CLASS = PnpRequest.class;
    private final int senderPid;
    private final String data;
    private final int txId;
    private final int sessionId;
    private final int createCv;
    protected final List subRequestsList = new ArrayList();
    private String version;
    private final PnpContext pnpContext;

    public PnpRequest(int inputSenderPid, int inputTxId, int inputSessionId, int inputCreateCv, String inputData, PnpContext inputPnpContext) throws ProcessingFailureException {
        this.senderPid = inputSenderPid;
        this.data = inputData;
        this.pnpContext = inputPnpContext;
        this.txId = inputTxId;
        this.sessionId = inputSessionId;
        this.createCv = inputCreateCv;
        this.extractRequest(inputData);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String inputVersion) {
        this.version = inputVersion;
    }

    public int getSenderPid() {
        return this.senderPid;
    }

    public PnpSubRequest[] getSubRequests() {
        PnpSubRequest[] subRequests = new PnpSubRequest[this.subRequestsList.size()];
        this.subRequestsList.toArray(subRequests);
        return subRequests;
    }

    public void addSubRequest(PnpSubRequest subRequest) {
        this.subRequestsList.add(subRequest);
    }

    private final void extractRequest(String requestData) throws ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "extractRequest");
        CharArrayReader reader = new CharArrayReader(requestData.toCharArray());
        InputSource input = new InputSource(reader);
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxParserFactory.newSAXParser();
            XMLReader parser = saxParser.getXMLReader();
            PnpXmlHandler handler = new PnpXmlHandler(this);
            parser.setContentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(input);
        }
        catch (ParserConfigurationException e) {
            logger.traceAbnormal(THIS_CLASS, "extractRequest ParserConfigurationException:" + e.getMessage());
            throw new ProcessingFailureException("extractRequest ParserConfigurationException: Original Exception message: " + e.getMessage());
        }
        catch (SAXException e) {
            logger.traceAbnormal(THIS_CLASS, "extractRequest SAXException:" + e.getMessage());
            throw new ProcessingFailureException("extractRequest SAXException. Original Exception message: " + e.getMessage());
        }
        catch (IOException e) {
            logger.traceAbnormal(THIS_CLASS, "extractRequest IOException:" + e.getMessage());
            throw new ProcessingFailureException("extractRequest IOException. Original Exception message: " + e.getMessage());
        }
        catch (Exception e) {
            logger.traceAbnormal(THIS_CLASS, "extractRequest Exception:" + e.getMessage());
            throw new ProcessingFailureException("Could not extract attribute for MO. Original Exception message: " + e.getMessage());
        }
        logger.traceReturn(THIS_CLASS, "extractRequest ");
    }

    public String toString() {
        String result = "";
        result = result + "senderPid:\n" + this.senderPid + "\n";
        result = result + "data:\n" + this.data + "\n";
        result = result + "txId:\n" + this.txId + "\n";
        result = result + "sessionId:\n" + this.sessionId + "\n";
        result = result + "createCv:\n" + this.createCv + "\n";
        Iterator iter = this.subRequestsList.iterator();
        while (iter.hasNext()) {
            PnpSubRequest pnpSubRequest = (PnpSubRequest)iter.next();
            result = result + "action: " + pnpSubRequest.toString();
        }
        return result;
    }

    public PnpContext getPnpContext() {
        return this.pnpContext;
    }

    public int getTxId() {
        return this.txId;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public int getCreateCv() {
        return this.createCv;
    }
}

