/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import se.ericsson.cello.emt.utils.guihelper.IconHelper;
import se.ericsson.cello.nex.ConfigurationI;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.StateMoParams;
import se.ericsson.cello.nex.toolservices.Tool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterHandler
implements ConfigurationI {
    public static final String CHECK_CHILDREN = "CHECK_CHILDREN";
    public static final String TOOL_KEYS = "TOOL_KEYS";
    public static final String ALARM_TOOL_KEYS = "ALARM_TOOL_KEYS";
    public static final String HYPER_TOOL_KEYS = "HYPER_TOOL_KEYS";
    public static final String STATE_KEYS = "STATE_KEYS";
    public static final String NAME_SUFFIX = "_NAME";
    public static final String FILE_SUFFIX = "_CONFIG";
    public static final String MO_CLASS_SUFFIX = "_MO_CLASS";
    public static final String DISPLAY_CONDITION_SUFFIX = "_DISPLAY_CONDITION";
    public static final String ICON_SUFFIX = "_ICON";
    public static final String ICON_JAR_FILE_SUFFIX = "_ICON_JAR_FILE";
    public static final String TOOLTIP_SUFFIX = "_TOOLTIP";
    public static final String KEY_DELIMITER = ";";
    public static final String SUPERSEDING_PARAMETER_LIST = "SUPERSEDING_PARAMETER_LIST";
    public static final String NEX_TITLE_KEY = "CUSTOM_APPL_NAME";
    public static final String NODE_SERVICES_KEY = "NODESERVICES";
    public static final String ADD_MO_KEY = "MOADD";
    public static final String SEARCH_MO_KEY = "MOSEARCH";
    public static final String MO_PROPERTIES_KEY = "MOPROPERTIES";
    public static final String MO_ADD_KEY = "MOADD";
    public static final String HELP_KEY = "HELPSERVICE";
    public static final String EMTRACELOG_KEY = "EMTRACELOG";
    public static final String USER_PREFERENCES_KEY = "PREFERENCESERVICE";
    public static final String CPP_VERSION_KEY = "CPP_VERSION";
    public static final String MO_PROPERTIES_DEFAULT_TITLE = "MO Properties";
    public static final String ADD_MO_DEFAULT_TITLE = "Add MO";
    public static final String SEARCH_MO_DEFAULT_TITLE = "Search MO";
    public static final String MO_TABLE_DEFAULT_TITLE = "MO Table";
    public static final String XSD_VERSION_KEY = "XSD_VERSION";
    public static final String MANAGER_TITLE_KEY = "MANAGER_TITLE";
    public static final String DEFAULT_MANAGER_TITLE = "CPP Element Manager";
    public static final String EMTRACELOG_DEFAULT_TITLE = "EM Trace Log";
    public static final String HELP_DEFAULT_TITLE = "EM Help Service";
    public static final String USER_PREF_DEFAULT_TITLE = "EM User Preferences";
    public static final String STARTVIEW_KEY = "START_VIEW";
    public static final String VIEW_KEY = "VIEW";
    public static final String HOST_KEY = "HOST";
    public static final String TOOL_ICON_KEY = "TOOL_ICON";
    public static final String DEFAULT_TITLE = "NEX";
    public static final String CPP_VIEWS_VISIBLE_KEY = "CPP_VIEWS_VISIBLE";
    public static final String VIEWLIST_FILE = "/cello/emas/viewlist.txt";
    public static final String VIEWLIST_XML_FILE = "/cello/emas/viewlist.xml";
    protected static final String IMPORTED_VIEW_FILENAME = "ImportedViews.dat";
    protected static final String HOST_ADDRESS = "address";
    protected static final String HOST_HTTP_PORT = "httpPort";
    private Map<String, Tool> tools;
    private Map<String, Tool> alarmTools;
    private Map<String, Tool> hyperTools;
    private String managerName = null;
    private Tool nodeServicesTool = null;
    private Tool emTraceLogTool = null;
    private Tool searchTool = null;
    private Tool moPropTool = null;
    private Tool addTool = null;
    private Tool helpTool = null;
    private Tool userPrefTool = null;
    private Image iconImage = null;
    private String iconToPassOn = null;
    private Properties myProps = null;
    private String myHostname = null;
    private String myHostAddress = null;
    private String myHostPort = null;
    private String myProtocol = null;
    private boolean checkChildren = true;
    private boolean storeImportedViewPaths = true;
    private boolean storeUserPreferences = true;
    private URL myViewListURL;
    private URL myViewRepositoryURL;
    private File myImportedViewStorage = null;
    private StateMoParams[] stateMoParams;

    public ParameterHandler(Properties props) {
        this(props, null, null);
    }

    public ParameterHandler(Properties props, URL viewRepositoryURL, URL viewListURL) {
        NexLog.logger().log(Level.FINE, "Properties : " + props.toString());
        this.myHostname = props.getProperty(HOST_KEY);
        this.myHostAddress = props.getProperty(HOST_ADDRESS);
        this.myHostPort = props.getProperty(HOST_HTTP_PORT);
        this.myProtocol = props.getProperty("protocol");
        this.myProps = props;
        this.tools = new LinkedHashMap<String, Tool>();
        this.alarmTools = new TreeMap<String, Tool>();
        this.hyperTools = new TreeMap<String, Tool>();
        this.stateMoParams = new StateMoParams[0];
        this.parseTools(new Properties(props));
        this.myViewRepositoryURL = viewRepositoryURL != null ? viewRepositoryURL : this.generateUrlToPathOnNode("");
        this.myViewListURL = viewListURL != null ? viewListURL : this.generateUrlToPathOnNode(VIEWLIST_XML_FILE);
        this.checkChildren = props.getProperty(CHECK_CHILDREN, "false").equalsIgnoreCase("true");
        String sep = System.getProperty("file.separator");
        this.myImportedViewStorage = new File(System.getProperty("user.home") + sep + "Ericsson" + sep + IMPORTED_VIEW_FILENAME);
    }

    private void parseTools(Properties props) {
        this.nodeServicesTool = new Tool();
        this.nodeServicesTool.setConfigFile(props.getProperty("NODESERVICES_CONFIG"));
        this.emTraceLogTool = new Tool();
        this.emTraceLogTool.setConfigFile(props.getProperty("EMTRACELOG_CONFIG"));
        this.emTraceLogTool.setName(props.getProperty("EMTRACELOG_NAME", EMTRACELOG_DEFAULT_TITLE));
        if (null != props.getProperty("HELPSERVICE_CONFIG")) {
            this.helpTool = new Tool();
            this.helpTool.setConfigFile(props.getProperty("HELPSERVICE_CONFIG"));
            this.helpTool.setName(props.getProperty("HELPSERVICE_NAME", HELP_DEFAULT_TITLE));
        }
        if (null != props.getProperty("MOSEARCH_CONFIG")) {
            this.searchTool = new Tool();
            this.searchTool.setConfigFile(props.getProperty("MOSEARCH_CONFIG"));
            this.searchTool.setName(props.getProperty("MOSEARCH_NAME", SEARCH_MO_DEFAULT_TITLE));
        }
        if (null != props.getProperty("MOPROPERTIES_CONFIG")) {
            this.moPropTool = new Tool();
            this.moPropTool.setConfigFile(props.getProperty("MOPROPERTIES_CONFIG"));
            this.moPropTool.setName(props.getProperty("MOPROPERTIES_NAME", MO_PROPERTIES_DEFAULT_TITLE));
        }
        if (null != props.getProperty("MOADD_CONFIG")) {
            this.addTool = new Tool();
            this.addTool.setConfigFile(props.getProperty("MOADD_CONFIG"));
            this.addTool.setName(props.getProperty("MOADD_NAME", ADD_MO_DEFAULT_TITLE));
        }
        if (null != props.getProperty("PREFERENCESERVICE_CONFIG")) {
            this.userPrefTool = new Tool();
            this.userPrefTool.setConfigFile(props.getProperty("PREFERENCESERVICE_CONFIG"));
            this.userPrefTool.setName(props.getProperty("PREFERENCESERVICE_NAME", USER_PREF_DEFAULT_TITLE));
        }
        NexLog.logger().log(Level.FINE, " reads the property title");
        this.managerName = props.getProperty(MANAGER_TITLE_KEY, DEFAULT_MANAGER_TITLE);
        NexLog.logger().log(Level.FINE, " reads the property icon");
        this.iconToPassOn = props.getProperty(TOOL_ICON_KEY);
        IconHelper helper = new IconHelper();
        this.iconImage = helper.getIconImage(this.iconToPassOn);
        NexLog.logger().log(Level.INFO, " parse the tools");
        this.parse(props, TOOL_KEYS, this.tools);
        this.parse(props, ALARM_TOOL_KEYS, this.alarmTools);
        this.parse(props, HYPER_TOOL_KEYS, this.hyperTools);
        if (null != props.getProperty(STATE_KEYS)) {
            this.parseStateMoParams(props);
        }
    }

    private void parse(Properties props, String toolType, Map<String, Tool> map) {
        String toolKeys = props.getProperty(toolType);
        if (toolKeys != null && !"".equals(toolKeys)) {
            String[] keys = toolKeys.split(KEY_DELIMITER);
            for (int i = 0; i < keys.length; ++i) {
                String cfgFile = props.getProperty(keys[i] + FILE_SUFFIX);
                String name = props.getProperty(keys[i] + NAME_SUFFIX);
                if (null != cfgFile && null != name && cfgFile.length() > 0 && name.length() > 0) {
                    Tool tool = new Tool();
                    tool.setConfigFile(cfgFile);
                    tool.setName(name);
                    map.put(tool.getName(), tool);
                    continue;
                }
                NexLog.logger().warning("While parsing the input from the configuration file, information on tool name or tool configuration file missing. \nTool name: " + name + "\nTool config file: " + cfgFile);
            }
        }
    }

    private void parseStateMoParams(Properties properties) {
        String stateKeys = properties.getProperty(STATE_KEYS);
        if (stateKeys != null && !"".equals(stateKeys)) {
            String[] keys = stateKeys.split(KEY_DELIMITER);
            this.stateMoParams = new StateMoParams[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                StateMoParams tmpStateMoParams = new StateMoParams();
                String moClass = properties.getProperty(keys[i] + MO_CLASS_SUFFIX);
                String toolTip = properties.getProperty(keys[i] + TOOLTIP_SUFFIX);
                String displayCondition = properties.getProperty(keys[i] + DISPLAY_CONDITION_SUFFIX);
                String icon = properties.getProperty(keys[i] + ICON_SUFFIX);
                String iconJarFile = properties.getProperty(keys[i] + ICON_JAR_FILE_SUFFIX);
                tmpStateMoParams.setMoClass(moClass);
                tmpStateMoParams.setToolTip(toolTip);
                tmpStateMoParams.setDisplayCondition(displayCondition);
                tmpStateMoParams.setIcon(icon);
                tmpStateMoParams.setIconJarFile(iconJarFile);
                this.stateMoParams[i] = tmpStateMoParams;
            }
        }
    }

    @Override
    public Tool getTool(String name) {
        return this.tools.get(name);
    }

    @Override
    public Tool getAlarmTool(String name) {
        return this.alarmTools.get(name);
    }

    @Override
    public Tool getHyperTool(String name) {
        return this.hyperTools.get(name);
    }

    @Override
    public Tool getNodeServicesTool() {
        return this.nodeServicesTool;
    }

    @Override
    public Tool getEmTraceLogTool() {
        return this.emTraceLogTool;
    }

    @Override
    public Tool getHelpTool() {
        return this.helpTool;
    }

    @Override
    public Tool getMoPropTool() {
        return this.moPropTool;
    }

    @Override
    public Tool getAddTool() {
        return this.addTool;
    }

    @Override
    public Tool getSearchTool() {
        return this.searchTool;
    }

    @Override
    public Tool getUserPreferencesTool() {
        return this.userPrefTool;
    }

    @Override
    public Collection<Tool> getAlarmTools() {
        return this.alarmTools.values();
    }

    @Override
    public Collection<Tool> getHyperTools() {
        return this.hyperTools.values();
    }

    @Override
    public Collection<Tool> getTools() {
        return this.tools.values();
    }

    @Override
    public Image getIconImage() {
        return this.iconImage;
    }

    @Override
    public String getXsdFileName() {
        NexLog.logger().log(Level.FINE, " reads the XSD Schema filename");
        return this.myProps.getProperty(XSD_VERSION_KEY, "-");
    }

    @Override
    public String getTitle() {
        return this.myProps.getProperty(MANAGER_TITLE_KEY, DEFAULT_MANAGER_TITLE);
    }

    @Override
    public String getManagerName() {
        return this.managerName;
    }

    @Override
    public String getIconToPassOn() {
        return this.iconToPassOn;
    }

    @Override
    public Properties getProperties() {
        return this.myProps;
    }

    @Override
    public boolean getCppViewsVisibility() {
        String vis = this.myProps.getProperty(CPP_VIEWS_VISIBLE_KEY, "false");
        return vis.equalsIgnoreCase("true") || vis.equalsIgnoreCase("yes");
    }

    @Override
    public Properties getSupersedingProperties() {
        Properties tempProp = new Properties();
        String strSupersedingList = this.myProps.getProperty(SUPERSEDING_PARAMETER_LIST);
        if (strSupersedingList != null) {
            tempProp.put(SUPERSEDING_PARAMETER_LIST, strSupersedingList);
            String[] supersedingListArray = strSupersedingList.split(KEY_DELIMITER);
            for (int i = 0; i < supersedingListArray.length; ++i) {
                String supersedingName = supersedingListArray[i];
                String supersedingValue = this.myProps.getProperty(supersedingName);
                if (null == supersedingValue) continue;
                tempProp.put(supersedingName, supersedingValue);
            }
        }
        return tempProp;
    }

    @Override
    public URL getViewListURL() {
        return this.myViewListURL;
    }

    @Override
    public URL getViewRepositoryRoot() {
        return this.myViewRepositoryURL;
    }

    @Override
    public Collection<String> readImportedViewPaths() {
        ArrayList<String> importedViewPaths = new ArrayList<String>();
        if (this.shouldStoreImportedViewPaths() && this.myImportedViewStorage.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(this.myImportedViewStorage);
                BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
                String row = in.readLine();
                while (row != null && row.trim().length() > 0) {
                    importedViewPaths.add(row.trim());
                    row = in.readLine();
                }
                in.close();
            }
            catch (FileNotFoundException ex) {
                NexLog.logger().warning("No stored imported view links found. File name: " + this.myImportedViewStorage);
            }
            catch (IOException e) {
                NexLog.logger().warning("Could not read user imported views from " + this.myImportedViewStorage + NexLog.stackToString(e));
            }
            catch (Exception e) {
                NexLog.logger().warning("Some problem occured while reading user imported views from " + this.myImportedViewStorage + "\n" + NexLog.stackToString(e));
            }
        }
        return importedViewPaths;
    }

    @Override
    public void storeImportedViewPaths(Collection<String> newImportedViewPaths) throws IOException {
        if (this.shouldStoreImportedViewPaths() && (0 != newImportedViewPaths.size() || this.myImportedViewStorage.exists())) {
            String newline = System.getProperties().getProperty("line.separator");
            FileWriter writer = new FileWriter(this.myImportedViewStorage);
            for (String path : newImportedViewPaths) {
                writer.write(path);
                writer.write(newline);
            }
            writer.close();
        }
    }

    @Override
    public boolean shouldStoreImportedViewPaths() {
        return this.storeImportedViewPaths;
    }

    @Override
    public boolean shouldStorePreferences() {
        return this.storeUserPreferences;
    }

    @Override
    public URL generateUrlToPathOnNode(String pathOnNode) {
        URL genURL = null;
        boolean urlGenerated = false;
        if (this.myHostAddress != null && this.myHostPort != null) {
            try {
                int port = Integer.parseInt(this.myHostPort);
                genURL = new URL(this.myProtocol, this.myHostAddress, port, pathOnNode);
                NexLog.logger().info("Generate URL: " + genURL.toString());
                urlGenerated = true;
            }
            catch (Exception e) {
                NexLog.logger().warning("Could not generate URL to " + pathOnNode + " on host " + this.myHostAddress + " and port " + this.myHostPort);
                NexLog.logger().fine(NexLog.stackToString(e));
            }
        }
        if (!urlGenerated && this.myHostname != null) {
            try {
                genURL = new URL(this.myProtocol + "://" + this.myHostname + pathOnNode);
                int defaultPort = genURL.getDefaultPort();
                int port = genURL.getPort();
                String host = genURL.getHost();
                if (-1 == port) {
                    genURL = new URL(this.myProtocol, host, defaultPort, pathOnNode);
                }
                urlGenerated = true;
                NexLog.logger().info("Generate URL: " + genURL.toString());
            }
            catch (MalformedURLException e) {
                NexLog.logger().warning("Could not generate URL to " + pathOnNode + " on host " + this.myHostname);
                NexLog.logger().fine(NexLog.stackToString(e));
            }
        }
        if (!urlGenerated) {
            NexLog.logger().warning("Could not generate URL to " + pathOnNode + " on host: " + this.myHostname);
        }
        return genURL;
    }

    @Override
    public boolean shouldCheckChildren() {
        return this.checkChildren;
    }

    @Override
    public StateMoParams[] getStateMoParams() {
        return this.stateMoParams;
    }
}

