/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class AttributeCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -3567597014969824765L;
    private Color bg_sel;
    private Color bg_non_sel;
    private Color bg_NotApplicable;
    private Color fg_sel;
    private Color fg_non_sel;

    public AttributeCellRenderer(Color fg, Color sel_fg, Color bg, Color sel_bg, Color na_bg) {
        this.bg_sel = sel_bg;
        this.bg_non_sel = bg;
        this.bg_NotApplicable = na_bg;
        this.fg_sel = sel_fg;
        this.fg_non_sel = fg;
    }

    public Component getTableCellRendererComponent(JTable table, Object newValue, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean na = false;
        boolean matchesChPaAttr = false;
        if (newValue instanceof String) {
            if (newValue.equals("Not Applicable")) {
                newValue = "";
                na = true;
            } else if (((String)newValue).matches("\\[[a-zA-Z]+\\] .*")) {
                newValue = ((String)newValue).substring(((String)newValue).indexOf(" ") + 1);
                matchesChPaAttr = true;
            }
            FontMetrics metrics = this.getFontMetrics(table.getFont());
            int stringWidth = metrics.stringWidth((String)newValue);
            int columnWidth = table.getColumnModel().getColumn(column).getWidth();
            if (newValue != null && columnWidth - 4 < stringWidth) {
                StringBuilder strBuilder = new StringBuilder((String)newValue);
                int i = strBuilder.length() - 1;
                while (columnWidth - 4 >= metrics.stringWidth(strBuilder.substring(i)) && --i >= 0) {
                }
                newValue = null;
                newValue = strBuilder.length() >= i + 4 ? "..." + strBuilder.substring(i + 4) + " " : "... ";
                strBuilder = null;
            }
        }
        this.setHorizontalAlignment(0);
        super.getTableCellRendererComponent(table, newValue, isSelected, false, row, column);
        if (matchesChPaAttr) {
            Font f = this.getFont();
            float siz = f.getSize2D();
            this.setFont(f.deriveFont(2, siz - 2.0f));
        }
        if (isSelected) {
            this.setOpaque(true);
            this.setBackground(this.bg_sel);
            this.setForeground(this.fg_sel);
        } else {
            this.setOpaque(true);
            if (na) {
                this.setBackground(this.bg_NotApplicable);
                this.setForeground(this.fg_non_sel);
            } else {
                this.setBackground(this.bg_non_sel);
                this.setForeground(this.fg_non_sel);
            }
        }
        return this;
    }
}

