/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.utils.guihelper.SwingWorker;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;
import se.ericsson.cello.nex.DestroyableEmbeddable;
import se.ericsson.cello.nex.Embeddable;
import se.ericsson.cello.nex.MessengerI;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.gui.NodeStateIcon;
import se.ericsson.cello.nex.gui.OwnerFrameI;
import se.ericsson.cello.nex.gui.treetable.JTreeTable;
import se.ericsson.cello.nex.gui.treetable.TreeTableModelAdapter;
import se.ericsson.cello.nex.gui.view.AttributeCellRenderer;
import se.ericsson.cello.nex.gui.view.DefaultNexTreeNodeFactory;
import se.ericsson.cello.nex.gui.view.ExpanderGUI;
import se.ericsson.cello.nex.gui.view.FolderNode;
import se.ericsson.cello.nex.gui.view.GuiViewPreferences;
import se.ericsson.cello.nex.gui.view.MoAddListener;
import se.ericsson.cello.nex.gui.view.MoDeleteListener;
import se.ericsson.cello.nex.gui.view.MoNode;
import se.ericsson.cello.nex.gui.view.MoTreeTableModel;
import se.ericsson.cello.nex.gui.view.NexTreeNode;
import se.ericsson.cello.nex.gui.view.NexTreeNodeSelectionI;
import se.ericsson.cello.nex.gui.view.NodePopupManager;
import se.ericsson.cello.nex.gui.view.TableKeyListener;
import se.ericsson.cello.nex.gui.view.TableMouseListener;
import se.ericsson.cello.nex.gui.view.TreeKeyListener;
import se.ericsson.cello.nex.gui.view.ViewElementCellRenderer;
import se.ericsson.cello.nex.gui.view.WillExpandListener;
import se.ericsson.cello.nex.gui.view.workers.ModelCallback;
import se.ericsson.cello.nex.gui.view.workers.ModelWorker;
import se.ericsson.cello.nex.toolservices.NexEvent;
import se.ericsson.cello.nex.toolservices.StartFailureException;
import se.ericsson.cello.nex.toolservices.ToolServicesI;
import se.ericsson.cello.nex.viewservices.ViewI;
import se.ericsson.cello.nex.viewservices.ViewServicesI;
import se.ericsson.cello.nex.viewservices.model.ViewElementI;
import se.ericsson.cello.nex.viewservices.model.ViewModelI;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.emnotification.EmEventInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationServiceInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiView
implements ViewI,
ExpanderGUI,
NexTreeNodeSelectionI,
OwnerFrameI,
ActionListener,
AdjustmentListener,
PropertyChangeListener {
    private static final Dimension SCROLLPANE_PREFERRED_SIZE = new Dimension(400, 400);
    protected static final String DEFAULT_DESCRIPTION = "No description available";
    private static final String REFRESH_TREE_TOOLTIP = "Build the tree again from node information. Will also refresh table attributes.";
    private static final String REFRESH_TREE = "Refresh Tree";
    private static final String REFRESH_TABLE = "Refresh Values";
    private static final String REFRESH_TABLE_TOOLTIP = "Update attribute values in the current table";
    private static final String STOP = "Stop";
    protected boolean expandingAll;
    private static final String TABLE_TITLE = "Table";
    private static final String VIEWS_TITLE = "Views";
    private static final String DESCRIPTION_TITLE = "Description";
    private static final String LDN_COLUMN_NAME = "LDN";
    private final int STATE_ICON_ARRAY_MAX_LENGTH = 5;
    private String viewName;
    private MoTreeTableModel model;
    private JTreeTable leftTable = null;
    private JTable rightTable = null;
    private TreeTableModelAdapter modelAdapter;
    private JList supportedViewsList;
    private JTextArea viewDescriptionTA;
    private JTextArea treeNodeDescriptionTA;
    private JButton selectViewBtn;
    private JButton refreshTreeBtn;
    private JButton refreshTableBtn;
    private JButton abortExpandBtn;
    private JButton abortUpdateTableBtn;
    private JLabel[] stateIconArray;
    private JSplitPane treeAndEmbeddablesSplitPane;
    private JScrollPane leftTableScrollPane;
    private JScrollPane rightTableScrollPane;
    private JScrollPane treeNodeDescrScroll;
    private JScrollBar leftTableScrollBar;
    private JScrollBar rightTableScrollBar;
    private JTabbedPane embeddablesPanel;
    private JPanel leftBelowTreePanel;
    private JPanel rightBelowEmbeddables;
    private JPanel viewsP;
    private JPanel tableTab;
    private JPanel blankAreaAboveTree;
    private JPanel stateIconPanel;
    private JProgressBar tableProgressBar;
    private JProgressBar treeProgressBar;
    private ProcessListener tableProcessListener;
    private ProcessListener treeProcessListener;
    private JPopupMenu popupMenu;
    private Map<String, DestroyableEmbeddable> embeddeds;
    private OwnerFrameI owner = null;
    private MessengerI messenger;
    private ToolServicesI toolService;
    private ViewServicesI viewService;
    private static final int ALL_LEVELS = 1000;
    private static final int DEFAULT_DELAY = 500;
    private static final String ACTION_SELECT_BTN = "ACTION_SELECT_BTN";
    private static final String ACTION_REFRESH_TREE = "ACTION_REFRESH_TREE";
    private static final String ACTION_ABORT_EXPAND = "ACTION_ABORT_EXPAND";
    private static final String ACTION_REFRESH_TABLE = "ACTION_REFRESH_TABLE";
    private static final String ACTION_ABORT_UPDATE_TABLE = "ACTION_ABORT_UPDATE_TABLE";
    private ViewModelI viewModel = null;
    private String myMoPropsEmbeddableTabName = null;
    private int myCurrentTab = -1;
    private Collection<String> columnNamesAddedByUser = new LinkedList<String>();
    private NodePopupManager popupMgr;
    private TreeKeyListener treeKeyListener;
    private TableKeyListener tableKeyListener;
    private Timer updateTimer;
    private boolean initiated = false;
    private boolean connected = true;
    private boolean refreshOngoing;
    private GuiViewPreferences viewPreferences;
    private MouseListener columnHeaderListener;
    private TableMouseListener tableMouseListener;
    private MoDeleteListener myMoDeleteListener = null;
    private MoAddListener myMoAddListener = null;
    private Collection<String> standardNodeAttributes = new ArrayList<String>();
    private int[] lastSelectedRows = new int[0];
    private int lastNumRows;
    private boolean lastWasNew;
    protected boolean updatingTableColumns;

    public GuiView(String aName) {
        this.viewName = aName;
    }

    @Override
    public void init(ViewElementI topViewElement, ViewModelI aViewModel, Collection<String> embeddedAppNames, MessengerI messageDistributer, ToolServicesI toolserv, ViewServicesI viewserv) {
        this.toolService = toolserv;
        this.viewService = viewserv;
        this.viewModel = aViewModel;
        this.messenger = messageDistributer;
        final MoNode topNode = new MoNode(topViewElement, topViewElement.allowsChildren(), this);
        this.model = new MoTreeTableModel(topNode, this.getInitialColumns(), new DefaultNexTreeNodeFactory(this));
        this.viewPreferences = new GuiViewPreferences(this.viewName, this.toolService.getUserPreferences());
        this.setColumnNamesAddedByUser(this.viewPreferences.getUserAddedColumnPreference());
        this.initEmbeddeds(embeddedAppNames);
        this.initPanels();
        this.myMoDeleteListener = new MoDeleteListener(this.model, this.modelAdapter, this);
        if (this.isContainmentView()) {
            this.toolService.addEmNotificationListener(this.myMoDeleteListener);
            this.myMoAddListener = new MoAddListener(this);
            this.toolService.addEmNotificationListener(this.myMoAddListener);
        }
        this.treeProcessListener = new ProcessListener(this.treeProgressBar);
        this.tableProcessListener = new ProcessListener(this.tableProgressBar);
        this.monitorTreeProcess("Expanding top level...", this.model.asynchronousExpandNode(topNode, new ModelCallback<Void>(){

            @Override
            public void run(Void result, boolean cancelled) {
                if (cancelled) {
                    GuiView.this.setStatusMessage("The expansion of the top level was aborted.");
                } else {
                    GuiView.this.setStatusMessage("The expansion of the top level was completed.");
                }
                GuiView.this.expandNode(topNode);
            }
        }));
        this.initiated = true;
    }

    private void initEmbeddeds(Collection<String> embeddedAppNames) {
        this.embeddeds = new HashMap<String, DestroyableEmbeddable>();
        DestroyableEmbeddable moprops = this.toolService.getEmbeddedApplication("se.ericsson.cello.emt.moproperties.MoPropertiesEmbeddable");
        if (null != moprops) {
            this.myMoPropsEmbeddableTabName = moprops.getName();
            this.embeddeds.put(this.myMoPropsEmbeddableTabName, moprops);
        }
        for (String embeddedClassName : embeddedAppNames) {
            DestroyableEmbeddable emb = this.toolService.getEmbeddedApplication(embeddedClassName);
            if (null == emb) continue;
            this.embeddeds.put(emb.getName(), emb);
        }
    }

    private void initPanels() {
        NexLog.logger().info("GuiView initPanels");
        this.embeddablesPanel = new JTabbedPane(1);
        this.embeddablesPanel.setName("NexTabGroup");
        this.embeddablesPanel.addChangeListener(new TabPaneChangeListener());
        this.leftBelowTreePanel = new JPanel(new FlowLayout(0));
        this.leftBelowTreePanel.setName("leftBP");
        this.initiateTables();
        this.initiateViewsPane();
        this.initiateLeftScrollPane();
        this.initiateTreeProgressBar();
        this.initiateTableProgressBar();
        this.initiateButtons();
        this.initiateDescriptionPanel();
        this.initiateAreaAboveTreeTable();
        JPanel southP = new JPanel(new BorderLayout());
        JPanel southP2 = new JPanel(new BorderLayout());
        southP.add((Component)this.leftBelowTreePanel, "West");
        southP2.add((Component)this.rightBelowEmbeddables, "East");
        this.tableTab = new JPanel(new BorderLayout());
        this.tableTab.setName(TABLE_TITLE);
        this.tableTab.add((Component)southP2, "South");
        this.tableTab.add((Component)this.rightTableScrollPane, "Center");
        JPanel leftSidePanel = new JPanel(new BorderLayout());
        leftSidePanel.add((Component)this.blankAreaAboveTree, "North");
        leftSidePanel.add((Component)this.leftTableScrollPane, "Center");
        leftSidePanel.add((Component)southP, "South");
        this.treeAndEmbeddablesSplitPane = new JSplitPane(1, leftSidePanel, this.embeddablesPanel);
        this.treeAndEmbeddablesSplitPane.setResizeWeight(0.5);
        this.treeAndEmbeddablesSplitPane.setOneTouchExpandable(false);
        NexLog.logger().info("GuiView initPanels at end");
    }

    private void initiateAreaAboveTreeTable() {
        this.stateIconPanel = new JPanel(new FlowLayout(0, 4, 2));
        this.stateIconArray = new JLabel[5];
        for (int i = 0; i < 5; ++i) {
            this.stateIconArray[i] = new JLabel();
            this.stateIconPanel.add(this.stateIconArray[i]);
        }
        Dimension dim = this.getDefaultDimensions();
        this.blankAreaAboveTree = new JPanel(new FlowLayout(0, 3, 1));
        this.blankAreaAboveTree.setMaximumSize(dim);
        this.blankAreaAboveTree.setPreferredSize(dim);
        this.blankAreaAboveTree.add(new JLabel(""));
        this.blankAreaAboveTree.add(this.stateIconPanel);
    }

    private void initiateButtons() {
        this.createRefreshTreeButton();
        this.createAbortExpandButton();
        this.createRefreshTableButton();
        this.createAbortUpdateTableButton();
    }

    private void initiateTables() {
        this.createTableOnLeftSide();
        this.createTableOnRightSide();
        this.leftTable.setRowHeight(this.rightTable.getRowHeight());
    }

    private void initiateTableProgressBar() {
        this.rightBelowEmbeddables = new JPanel(new FlowLayout(2));
        this.tableProgressBar = new JProgressBar();
        this.tableProgressBar.setValue(0);
        this.tableProgressBar.setMaximum(100);
        this.tableProgressBar.setVisible(false);
        this.rightBelowEmbeddables.add(this.tableProgressBar);
    }

    private void initiateTreeProgressBar() {
        this.treeProgressBar = new JProgressBar();
        this.treeProgressBar.setName("treeProgressBar");
        this.treeProgressBar.setValue(0);
        this.treeProgressBar.setMaximum(100);
        this.treeProgressBar.setVisible(false);
        this.leftBelowTreePanel.add(this.treeProgressBar);
    }

    private void initiateDescriptionPanel() {
        this.treeNodeDescriptionTA = new JTextArea();
        this.treeNodeDescriptionTA.setEditable(false);
        this.treeNodeDescriptionTA.setLineWrap(true);
        this.treeNodeDescriptionTA.setWrapStyleWord(true);
        this.treeNodeDescriptionTA.setOpaque(false);
        this.treeNodeDescriptionTA.setName(DESCRIPTION_TITLE);
        this.treeNodeDescrScroll = new JScrollPane(this.treeNodeDescriptionTA);
    }

    private void initiateLeftScrollPane() {
        this.leftTableScrollPane = new JScrollPane();
        this.leftTableScrollPane.setHorizontalScrollBarPolicy(30);
        this.leftTableScrollPane.setVerticalScrollBarPolicy(20);
        this.leftTableScrollBar = this.leftTableScrollPane.getVerticalScrollBar();
        this.leftTableScrollBar.setUnitIncrement(50);
        this.leftTableScrollBar.addAdjustmentListener(this);
        JScrollBar hAdjust = this.leftTableScrollPane.getHorizontalScrollBar();
        hAdjust.setUnitIncrement(50);
        this.leftTableScrollPane.setViewportView(this.leftTable);
        this.leftTableScrollPane.setOpaque(false);
    }

    private Dimension getDefaultDimensions() {
        JTabbedPane dummytabpane = new JTabbedPane(1);
        dummytabpane.add("Blaha", new JLabel(""));
        Double heightDTP = dummytabpane.getPreferredSize().getHeight();
        return new Dimension(300, heightDTP.intValue() - 3);
    }

    private ArrayList<String> getInitialColumns() {
        Collection<String> viewAttributes = this.viewModel.getAttributeNames();
        ArrayList<String> columnNames = new ArrayList<String>(2 + this.getColumnNamesAddedByUser().size() + viewAttributes.size());
        columnNames.add("MO Tree");
        columnNames.add(LDN_COLUMN_NAME);
        columnNames.addAll(viewAttributes);
        columnNames.addAll(this.getColumnNamesAddedByUser());
        return columnNames;
    }

    @Override
    public boolean isInitiated() {
        return this.initiated;
    }

    public JComponent getViewPanel() {
        int tabIndex;
        int lastSelTab = this.myCurrentTab;
        this.embeddablesPanel.removeAll();
        this.embeddablesPanel.add(TABLE_TITLE, this.tableTab);
        int tabplace = 0;
        this.embeddablesPanel.setMnemonicAt(tabplace, 66);
        ++tabplace;
        Set<String> embNames = this.embeddeds.keySet();
        if (null != this.myMoPropsEmbeddableTabName) {
            this.embeddablesPanel.add(this.myMoPropsEmbeddableTabName, this.embeddeds.get(this.myMoPropsEmbeddableTabName).getComponent());
            this.embeddablesPanel.setMnemonicAt(tabplace, 73);
            ++tabplace;
        }
        this.embeddablesPanel.add(DESCRIPTION_TITLE, this.treeNodeDescrScroll);
        this.embeddablesPanel.setMnemonicAt(tabplace, 78);
        this.embeddablesPanel.add(VIEWS_TITLE, this.viewsP);
        this.embeddablesPanel.setMnemonicAt(++tabplace, 87);
        ++tabplace;
        for (String embName : embNames) {
            if (this.myMoPropsEmbeddableTabName == embName) continue;
            this.embeddablesPanel.add(embName, this.embeddeds.get(embName).getComponent());
        }
        if (lastSelTab > -1) {
            if (lastSelTab < this.embeddablesPanel.getTabCount()) {
                this.embeddablesPanel.setSelectedIndex(lastSelTab);
            }
        } else if (this.isContainmentView() && (tabIndex = this.embeddablesPanel.indexOfTab(this.myMoPropsEmbeddableTabName)) > -1) {
            this.embeddablesPanel.setSelectedIndex(tabIndex);
        }
        return this.treeAndEmbeddablesSplitPane;
    }

    @Override
    public void selectRootMo(boolean scrollToRoot) {
        int[] rows = new int[]{0};
        this.selectRowsOnEDT(rows, scrollToRoot);
    }

    @Override
    public void selectLDNs(final Collection<String> ldns) {
        NexLog.logger().info("ldns:" + ldns);
        if (!this.isContainmentView()) {
            return;
        }
        this.monitorTreeProcess("Expanding to selected MOs", this.model.asynchronousPartiallyExpandToLDNs(ldns, new ModelCallback<Collection<NexTreeNode>>(){

            @Override
            public void run(Collection<NexTreeNode> nodesToShowAndSelect, boolean cancelled) {
                if (ldns.size() != nodesToShowAndSelect.size()) {
                    if (ldns.size() == 1) {
                        GuiView.this.setStatusMessage("The MO " + (String)ldns.iterator().next() + " was not found.");
                    } else {
                        GuiView.this.setStatusMessage("" + (ldns.size() - nodesToShowAndSelect.size()) + " of the requested " + ldns.size() + " MOs not found.");
                    }
                } else {
                    GuiView.this.setStatusMessage("Selected MOs visible.");
                }
                NexLog.logger().info("GuiView.selectLDN, found " + nodesToShowAndSelect.size() + " nodes to select.");
                int count = nodesToShowAndSelect.size() > 0 ? nodesToShowAndSelect.size() : 1;
                int[] rows = new int[count];
                if (0 == nodesToShowAndSelect.size()) {
                    if (-1 == GuiView.this.leftTable.getSelectedRow()) {
                        rows[0] = 0;
                    }
                } else {
                    GuiView.this.leftTable.clearSelection();
                    int place = 0;
                    for (NexTreeNode node : nodesToShowAndSelect) {
                        NexTreeNode expandTarget = (NexTreeNode)node.getParent();
                        if (expandTarget != null) {
                            GuiView.this.leftTable.getTree().expandPath(new TreePath(expandTarget.getPath()));
                        }
                        TreePath path = new TreePath(node.getPath());
                        GuiView.this.leftTable.getTree().scrollPathToVisible(path);
                        rows[place++] = GuiView.this.leftTable.getTree().getRowForPath(path);
                    }
                }
                GuiView.this.selectRowsOnEDT(rows, true);
            }
        }));
    }

    protected void monitorTreeProcess(String message, ModelWorker<?, ?> worker) {
        this.treeProcessListener.addWorker(worker, message);
        worker.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Object value = evt.getNewValue();
                if (evt.getPropertyName().equals("state")) {
                    if (value.equals(SwingWorker.StateValue.STARTED)) {
                        GuiView.this.enableTreeButtons(false);
                    } else if (value.equals(SwingWorker.StateValue.DONE)) {
                        GuiView.this.enableTreeButtons(true);
                    }
                }
            }
        });
    }

    private void monitorTableProcess(String message, ModelWorker<?, ?> worker) {
        this.tableProcessListener.addWorker(worker, message);
        worker.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Object value = evt.getNewValue();
                if (evt.getPropertyName().equals("state")) {
                    if (value.equals(SwingWorker.StateValue.STARTED)) {
                        GuiView.this.enableTableButtons(false);
                    } else if (value.equals(SwingWorker.StateValue.DONE)) {
                        GuiView.this.enableTableButtons(true);
                    }
                }
            }
        });
    }

    private void cancelTreeProcess() {
        this.treeProcessListener.cancelCurrent();
    }

    private void cancelTableProcess() {
        this.tableProcessListener.cancelCurrent();
    }

    @Override
    public String getSelectedLDNs() {
        StringBuffer buf = new StringBuffer();
        boolean firstLDN = true;
        for (NexTreeNode node : this.getSelectedNodes()) {
            if (node.isFolder()) continue;
            if (!firstLDN) {
                buf.append(";");
            }
            buf.append(node.getLongName());
            firstLDN = false;
        }
        return buf.toString();
    }

    @Override
    public Collection<String> getSelectedLDNsInCollection() {
        Collection<NexTreeNode> nexNodes = this.getSelectedNodes();
        ArrayList<String> ldns = new ArrayList<String>(nexNodes.size());
        for (NexTreeNode node : nexNodes) {
            if (node.isFolder()) continue;
            ldns.add(node.getLongName());
        }
        return ldns;
    }

    @Override
    public String getSelectedLDN() {
        NexTreeNode nexNode = this.getSelectedNode();
        if (null == nexNode) {
            return "";
        }
        if (!nexNode.isFolder()) {
            return nexNode.getLongName();
        }
        return "";
    }

    @Override
    public void expandToLevel(final int level) {
        if (level < 3) {
            return;
        }
        NexLog.logger().info("expandTolevel will expand the model nodes");
        this.monitorTreeProcess("Expanding the view " + this.viewName + "...", this.model.asynchronousExpandToLevel((NexTreeNode)this.model.getRoot(), level - 1, new ModelCallback<Collection<TreePath>>(){

            @Override
            public void run(Collection<TreePath> paths, boolean cancelled) {
                for (TreePath path : paths) {
                    GuiView.this.leftTable.getTree().expandPath(path);
                }
                if (cancelled) {
                    GuiView.this.setStatusMessage("The expansion of the tree was aborted.");
                } else if (1000 == level) {
                    GuiView.this.setStatusMessage("The tree of " + GuiView.this.viewName + " is fully expanded.");
                } else {
                    GuiView.this.setStatusMessage("The tree of " + GuiView.this.viewName + " is expanded to level " + level + ".");
                }
                NexLog.logger().info("expandTolevel has finished. aborted is:" + cancelled);
                LauncherInterface launcher = GuiView.this.toolService.getLauncher();
                if (launcher instanceof EmNotificationServiceInterface) {
                    NexEvent nexEvent;
                    NexLog.logger().info("StartTimer: Sending a notification from the end of expandToLevel()");
                    EmNotificationServiceInterface emNotificationServiceInterface = (EmNotificationServiceInterface)launcher;
                    String notificationType = "se.ericsson.cello.nex.VIEW_EXPANDED";
                    5 objectSource = this;
                    long sequenceNumber = 0L;
                    NexEvent emEvent = nexEvent = new NexEvent(notificationType, objectSource, sequenceNumber);
                    emNotificationServiceInterface.sendNotification((EmEventInterface)emEvent);
                } else {
                    NexLog.logger().info("Notification service not available.");
                }
                GuiView.this.selectRootMo(false);
            }
        }));
    }

    @Override
    public void expandAll() {
        for (NexTreeNode aNode : this.getSelectedNodes()) {
            this.expandAllBelow(aNode);
        }
    }

    @Override
    public void expandAllBelow(final NexTreeNode node) {
        this.monitorTreeProcess("Expanding all below " + node.getName() + "...", this.model.asynchronousExpandRecursively(node, new ModelCallback<Collection<TreePath>>(){

            @Override
            public void run(Collection<TreePath> paths, boolean cancelled) {
                if (cancelled) {
                    GuiView.this.setStatusMessage("Expansion below " + node.getName() + " aborted.");
                } else {
                    GuiView.this.setStatusMessage("Expansion below " + node.getName() + " complete.");
                }
                for (TreePath path : paths) {
                    GuiView.this.leftTable.getTree().expandPath(path);
                }
                int row = GuiView.this.leftTable.getTree().getRowForPath(new TreePath(node.getPath()));
                int[] rows = new int[]{row};
                GuiView.this.selectRowsOnEDT(rows, true);
            }
        }));
    }

    @Override
    public void setShowLdnColumn(boolean show) {
        NexLog.logger().info("GuiView showLdnColumn");
        this.viewPreferences.updateShowLDNFlag(show);
        this.updateTableColumns();
    }

    private void setPreferredSizeToColumns(JTable table, HashMap<String, Integer> preferredSizeOfColumns) {
        Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            Integer width = preferredSizeOfColumns.get(column.getHeaderValue());
            if (width == null) continue;
            column.setPreferredWidth(width);
        }
    }

    private Map<String, Integer> getColumnNameWidths(JTable table) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (int i = 0; i < table.getColumnCount(); ++i) {
            result.put(table.getColumnName(i), table.getColumnModel().getColumn(i).getWidth());
        }
        return result;
    }

    private List<String> getColumnNamesFromTable(JTable table) {
        ArrayList<String> result = new ArrayList<String>(table.getColumnCount());
        for (int i = 0; i < table.getColumnCount(); ++i) {
            result.add(table.getColumnName(i));
        }
        return result;
    }

    @Override
    public boolean getShowLDN() {
        return this.viewPreferences.getShowLDNFlag();
    }

    @Override
    public void offLine() {
        this.connected = false;
        this.abortExpandBtn.doClick();
        this.abortUpdateTableBtn.doClick();
        this.refreshTableBtn.setEnabled(false);
        this.refreshTreeBtn.setEnabled(false);
    }

    @Override
    public void onLine() {
        this.connected = true;
        this.refreshTableBtn.setEnabled(true);
        this.refreshTreeBtn.setEnabled(true);
    }

    @Override
    public void setToAccessible(boolean display) {
        if (display) {
            this.setPreferredColumnSizes(this.rightTable, this.viewPreferences);
            if (!this.isContainmentView()) {
                this.toolService.addEmNotificationListener(this.myMoDeleteListener);
            }
        } else if (!this.isContainmentView()) {
            this.toolService.removeEmNotificationListener(this.myMoDeleteListener);
        }
    }

    private boolean isContainmentView() {
        return this.viewName.equals("Containment (MOM based)");
    }

    @Override
    public String getExportString() {
        StringBuffer buff = new StringBuffer();
        int noOfColumns = this.modelAdapter.getColumnCount();
        for (int i = 0; i < noOfColumns; ++i) {
            buff.append(this.modelAdapter.getColumnName(i));
            buff.append("\t");
        }
        buff.append("\n");
        int numberOfRows = this.modelAdapter.getRowCount();
        for (int row = 0; row < numberOfRows; ++row) {
            for (int col = 0; col < noOfColumns; ++col) {
                buff.append(this.modelAdapter.getValueAt(row, col));
                buff.append("\t");
            }
            buff.append("\n");
        }
        return buff.toString();
    }

    @Override
    public ViewModelI getViewModel() {
        return this.viewModel;
    }

    private void addColumnToView(String attributeName) {
        if (this.isAttributeInView(attributeName)) {
            NexLog.logger().info("Trying to add column " + attributeName + " to view, which already exists.");
            return;
        }
        if (!this.model.containsColumn(attributeName)) {
            this.model.addColumn(attributeName);
        }
        TableColumn col = new TableColumn(this.model.getColumnIndex(attributeName));
        col.setCellRenderer(new AttributeCellRenderer(this.leftTable.getForeground(), this.leftTable.getSelectionForeground(), this.leftTable.getBackground(), this.leftTable.getSelectionBackground(), new JLabel().getBackground()));
        this.rightTable.addColumn(col);
    }

    private void updateTableColumns() {
        NexLog.logger().info("update columns");
        this.updatingTableColumns = true;
        HashSet<String> attributesToLoad = new HashSet<String>(this.standardNodeAttributes);
        attributesToLoad.addAll(this.columnNamesAddedByUser);
        ModelCallback<Void> finished = new ModelCallback<Void>(){

            @Override
            public void run(Void result, boolean cancelled) {
                int[] rowsToSelect = GuiView.this.leftTable.getSelectedRows();
                if (cancelled) {
                    GuiView.this.setStatusMessage("The table column update was aborted.");
                    return;
                }
                GuiView.this.setStatusMessage("The table column update was completed.");
                GuiView.this.removeAllTableColumns();
                GuiView.this.viewPreferences.setStandardAttributes(GuiView.this.standardNodeAttributes);
                List orderedNames = GuiView.this.getSortedColumns(GuiView.this.standardNodeAttributes);
                if (orderedNames != null) {
                    for (String name : orderedNames) {
                        GuiView.this.addColumnToView(name);
                    }
                } else {
                    for (String name : GuiView.this.standardNodeAttributes) {
                        GuiView.this.addColumnToView(name);
                    }
                }
                Collection<String> stringsAddedByuser = GuiView.this.getColumnNamesAddedByUser();
                for (String name : stringsAddedByuser) {
                    if (GuiView.this.isAttributeInView(name)) continue;
                    GuiView.this.addColumnToView(name);
                }
                if (!GuiView.this.isAttributeInView(GuiView.LDN_COLUMN_NAME) && GuiView.this.viewPreferences.getShowLDNFlag()) {
                    GuiView.this.addColumnToView(GuiView.LDN_COLUMN_NAME);
                    GuiView.this.rightTable.moveColumn(GuiView.this.rightTable.getColumnCount() - 1, 0);
                }
                GuiView.this.setPreferredColumnSizes(GuiView.this.rightTable, GuiView.this.viewPreferences);
                GuiView.this.selectRowsOnEDT(rowsToSelect, false);
            }
        };
        ArrayList<NexTreeNode> nodeArr = new ArrayList<NexTreeNode>(this.leftTable.getRowCount());
        for (int i = 0; i < nodeArr.size(); ++i) {
            nodeArr.set(i, (NexTreeNode)this.modelAdapter.nodeForRow(i));
        }
        this.monitorTableProcess(null, this.model.asynchronousUpdateNodes(nodeArr, attributesToLoad, finished));
    }

    private void removeAllTableColumns() {
        TableColumnModel columnModel = this.rightTable.getColumnModel();
        while (columnModel.getColumnCount() > 0) {
            columnModel.removeColumn(columnModel.getColumn(columnModel.getColumnCount() - 1));
        }
    }

    @Override
    public void deleteSelectedMOs() {
        this.viewService.deleteMos(this.getSelectedLDNs());
    }

    private void expandNode(final NexTreeNode aNode) {
        if (SwingUtilities.isEventDispatchThread()) {
            NexLog.logger().info("GuiView expandNode " + aNode.getLongName());
            TreePath pathToExpand = new TreePath(aNode.getPath());
            this.leftTable.getTree().expandPath(pathToExpand);
            int row = this.leftTable.getTree().getRowForPath(pathToExpand);
            this.selectRowsOnEDT(new int[]{row}, false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GuiView.this.expandNode(aNode);
                }

                public String toString() {
                    return "expandNodeRunnable";
                }
            });
        }
    }

    @Override
    public void expandToNode(final NexTreeNode aNode) {
        if (SwingUtilities.isEventDispatchThread()) {
            NexLog.logger().info("GuiView expandToNode " + aNode.getLongName());
            TreePath path = new TreePath(aNode.getPath());
            TreePath parentPath = path.getParentPath();
            if (null != parentPath) {
                this.leftTable.getTree().expandPath(parentPath);
            }
            int row = this.leftTable.getTree().getRowForPath(path);
            this.selectRowsOnEDT(new int[]{row}, false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GuiView.this.expandToNode(aNode);
                }

                public String toString() {
                    return "expandToNodeRunnable";
                }
            });
        }
    }

    @Override
    public String getName() {
        return this.viewName;
    }

    @Override
    public NexTreeNode getSelectedNode() {
        if (-1 == this.leftTable.getSelectedRow()) {
            return null;
        }
        return (NexTreeNode)this.modelAdapter.nodeForRow(this.leftTable.getSelectedRow());
    }

    @Override
    public Collection<NexTreeNode> getSelectedNodes() {
        if (-1 == this.leftTable.getSelectedRow()) {
            return new Vector<NexTreeNode>();
        }
        int[] rows = this.leftTable.getSelectedRows();
        Vector<NexTreeNode> returnVec = new Vector<NexTreeNode>(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            returnVec.addElement((NexTreeNode)this.modelAdapter.nodeForRow(rows[i]));
        }
        return returnVec;
    }

    public boolean isAttributeInView(String attributeName) {
        for (int i = 0; i < this.rightTable.getColumnCount(); ++i) {
            if (!this.rightTable.getColumnName(i).equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> getColumnNamesAddedByUser() {
        return this.columnNamesAddedByUser;
    }

    @Override
    public void destroy() {
        NexLog.logger().info("Destroying view: " + this.getName());
        if (this.isInitiated()) {
            if (null != this.updateTimer) {
                this.updateTimer.stop();
            }
            this.rightTable.getTableHeader().removeMouseListener(this.columnHeaderListener);
            this.rightTable.removeMouseListener(this.tableMouseListener);
            this.rightTable.removeKeyListener(this.tableKeyListener);
            this.viewPreferences.destroy();
            this.model.destroy();
        }
        if (this.viewName != null) {
            if (this.isContainmentView()) {
                if (this.toolService != null) {
                    this.toolService.removeEmNotificationListener(this.myMoDeleteListener);
                    if (null != this.myMoAddListener) {
                        this.toolService.removeEmNotificationListener(this.myMoAddListener);
                    }
                    this.myMoDeleteListener = null;
                    this.myMoAddListener = null;
                    NexLog.logger().info("MoDeleteListener is removed from containment view");
                    NexLog.logger().info("MoAddListener is removed from containment view");
                }
            } else {
                NexLog.logger().info("Destroy view " + this.viewName);
                Collection<DestroyableEmbeddable> destroyableEmbeddables = this.embeddeds.values();
                for (DestroyableEmbeddable destroyable : destroyableEmbeddables) {
                    destroyable.destroy();
                }
            }
        }
    }

    private List<String> getSortedColumns(Collection<String> defaultAttributes) {
        List<String> sortedNames = this.viewPreferences.getColumnOrderPreference();
        if (sortedNames.isEmpty()) {
            return null;
        }
        this.removeUnusedAttributes(sortedNames, defaultAttributes, this.getColumnNamesAddedByUser(), this.viewPreferences.getShowLDNFlag());
        if (sortedNames.size() == 0) {
            return null;
        }
        return sortedNames;
    }

    private void removeUnusedAttributes(List<String> ordAttr, Collection<String> defAttr, Collection<String> addedAttr, boolean showLDNcol) {
        Iterator<String> iter = ordAttr.iterator();
        while (iter.hasNext()) {
            String attrName = iter.next();
            if (defAttr.contains(attrName) || addedAttr.contains(attrName) || showLDNcol && attrName.equals(LDN_COLUMN_NAME)) continue;
            iter.remove();
        }
    }

    public void updatePrefix() {
        this.leftTable.updateUI();
    }

    public void setOwnerFrameI(OwnerFrameI anOwnerGui) {
        this.owner = anOwnerGui;
    }

    @Override
    public JFrame getFrame() {
        if (null != this.owner) {
            return this.owner.getFrame();
        }
        return null;
    }

    @Override
    public String getHostName() {
        if (null != this.owner) {
            return this.owner.getHostName();
        }
        return "";
    }

    @Override
    public String getToolTitle() {
        if (null != this.owner) {
            return this.owner.getToolTitle();
        }
        return "";
    }

    @Override
    public boolean showTreeNodePrefix() {
        if (null != this.owner) {
            return this.owner.showTreeNodePrefix();
        }
        return false;
    }

    @Override
    public void viewIsListening(boolean available) {
        if (null != this.owner) {
            this.owner.viewIsListening(available);
        }
    }

    @Override
    public void setMessage(String mainMessage, String specificMessage, boolean severe) {
        if (null != this.messenger) {
            this.messenger.setMessage(mainMessage, specificMessage, severe);
        }
    }

    @Override
    public void setMessage(String mainMessage, Exception exeption, boolean severe) {
        if (null != this.messenger) {
            this.messenger.setMessage(mainMessage, exeption, severe);
        }
    }

    @Override
    public void setMessage(String mainMessage, String specific, Exception exeption, boolean severe) {
        if (null != this.messenger) {
            this.messenger.setMessage(mainMessage, specific, exeption, severe);
        }
    }

    @Override
    public void setStatusMessage(String message) {
        if (null != this.messenger) {
            this.messenger.setStatusMessage(message);
        }
    }

    private void showViews() {
        NexLog.logger().info("GuiView showViews");
        NexTreeNode node = this.getSelectedNode();
        if (node != null) {
            Collection<String> views = this.viewService.getViewInfo().getViewsForMoClass(node.getViewElement().getMoClass());
            if (!node.isFolder() && views.size() > 0) {
                this.supportedViewsList.setListData(views.toArray());
                this.supportedViewsList.setEnabled(true);
                this.supportedViewsList.setSelectedIndex(0);
            } else {
                Vector<String> noviews = new Vector<String>();
                noviews.add("No views available");
                this.supportedViewsList.setListData(noviews);
                this.supportedViewsList.setEnabled(false);
            }
            this.toolService.sendEmNotification(new NexEvent(GuiTestEventTypes.VIEWS_PANEL_UPDATED, (Object)this, GuiTestEventTypes.claimSeqNum(), "The views tab has been updated"));
        }
    }

    private void showEmbeddables() {
        NexLog.logger().info("GuiView showEmbeddables");
        this.myCurrentTab = this.embeddablesPanel.getSelectedIndex();
        String tabTitle = this.embeddablesPanel.getTitleAt(this.myCurrentTab);
        Embeddable embed = this.embeddeds.get(tabTitle);
        if (null != embed) {
            ArrayList<String> ldns = new ArrayList<String>();
            for (NexTreeNode node : this.getSelectedNodes()) {
                if (node instanceof FolderNode) continue;
                ldns.add(node.getViewElement().getLdn());
            }
            try {
                embed.setLDNs(ldns.toArray(new String[0]));
            }
            catch (Exception e) {
                NexLog.logger().warning("Exception when setting LDN to Embeddable application in NEX. \n" + NexLog.stackToString(e));
            }
        }
    }

    private void showDescription() {
        NexTreeNode currentSelected = this.getSelectedNode();
        if (null == currentSelected) {
            return;
        }
        NexLog.logger().info("GuiView showDescription of " + currentSelected.getName());
        this.treeNodeDescriptionTA.setText(currentSelected.getDescription());
        this.toolService.sendEmNotification(new NexEvent(GuiTestEventTypes.DESCRIPTION_PANEL_UPDATED, (Object)this, GuiTestEventTypes.claimSeqNum(), "The description tab has been updated"));
    }

    private void createRefreshTreeButton() {
        this.refreshTreeBtn = new JButton(REFRESH_TREE);
        this.refreshTreeBtn.setName(REFRESH_TREE);
        this.refreshTreeBtn.setMnemonic('R');
        this.refreshTreeBtn.setToolTipText(REFRESH_TREE_TOOLTIP);
        this.refreshTreeBtn.setActionCommand(ACTION_REFRESH_TREE);
        this.refreshTreeBtn.addActionListener(this);
        this.leftBelowTreePanel.add(this.refreshTreeBtn);
    }

    private void createAbortExpandButton() {
        this.abortExpandBtn = new JButton(STOP);
        this.abortExpandBtn.setMnemonic('S');
        this.abortExpandBtn.setEnabled(false);
        this.abortExpandBtn.setActionCommand(ACTION_ABORT_EXPAND);
        this.abortExpandBtn.addActionListener(this);
        this.leftBelowTreePanel.add(this.abortExpandBtn);
    }

    private void createRefreshTableButton() {
        this.refreshTableBtn = new JButton(REFRESH_TABLE);
        this.refreshTableBtn.setMnemonic('u');
        this.refreshTableBtn.setActionCommand(ACTION_REFRESH_TABLE);
        this.refreshTableBtn.setToolTipText(REFRESH_TABLE_TOOLTIP);
        this.refreshTableBtn.addActionListener(this);
        this.rightBelowEmbeddables.add(this.refreshTableBtn);
    }

    private void createAbortUpdateTableButton() {
        this.abortUpdateTableBtn = new JButton(STOP);
        this.abortUpdateTableBtn.setMnemonic('S');
        this.abortUpdateTableBtn.setActionCommand(ACTION_ABORT_UPDATE_TABLE);
        this.abortUpdateTableBtn.addActionListener(this);
        this.abortUpdateTableBtn.setEnabled(false);
        this.rightBelowEmbeddables.add(this.abortUpdateTableBtn);
    }

    private void createTableOnLeftSide() {
        NexLog.logger().info("GuiView createTable1");
        try {
            this.leftTable = new JTreeTable(this.model);
            try {
                ((DefaultTableCellRenderer)this.leftTable.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
            }
            catch (Exception e) {
                NexLog.logger().info("Exception when trying to set center alaignment to MO table: " + e.getMessage());
            }
            this.leftTable.setName("table1");
            NexLog.logger().info("GuiView createTable1 after new JTreeTable");
            this.modelAdapter = (TreeTableModelAdapter)this.leftTable.getModel();
            NexLog.logger().info("GuiView createTable1 after modelAdapter");
            this.leftTable.getColumnModel().setColumnSelectionAllowed(false);
            this.leftTable.setSelectionMode(2);
            this.leftTable.getTree().getSelectionModel().setSelectionMode(4);
            this.leftTable.getTableHeader().setReorderingAllowed(false);
            this.leftTable.getTree().setName("MoTree");
            NexLog.logger().info("GuiView createTable1 before new ViewElementCellRenderer");
            this.leftTable.getTree().setName("moTree");
            this.leftTable.getTree().setCellRenderer(new ViewElementCellRenderer(this.leftTable.getSelectionForeground(), this.leftTable.getForeground(), this.leftTable.getFont()));
            NexLog.logger().info("GuiView createTable1 before new TreeKeyListener");
            this.treeKeyListener = new TreeKeyListener(this, this.model, this.leftTable, this.modelAdapter, this);
            this.leftTable.addKeyListener(this.treeKeyListener);
            NexLog.logger().info("GuiView createTable1 before new WillExpandListener");
            this.leftTable.getTree().addTreeWillExpandListener(new WillExpandListener(this, this.leftTable.getTree(), this.model));
            NexLog.logger().info("GuiView createTable1 before new NodePopupManager");
            this.initiatePopupManager();
            Collection<String> hyperNames = this.toolService.getAvailableHyperTools();
            if (this.isContainmentView() && hyperNames.contains("Containment View")) {
                hyperNames.remove("Containment View");
            }
            this.popupMgr.addGotoMenu(this.popupMenu, hyperNames);
            this.popupMgr.addMoDeleteMenu(this.popupMenu);
            this.leftTable.addMouseListener(new LeftTableMouseListener());
            this.leftTable.addMouseListener(this.popupMgr.getPopupListener(this.popupMenu));
            this.leftTable.addMouseMotionListener(new TableMouseMotionAdapter());
            this.updateTimer = new Timer(500, this);
            this.updateTimer.start();
            this.leftTable.setAutoCreateColumnsFromModel(false);
            int noOfCol = this.leftTable.getColumnCount();
            for (int i = noOfCol - 1; i > 0; --i) {
                this.leftTable.removeColumn(this.leftTable.getColumnModel().getColumn(i));
            }
        }
        catch (Exception e) {
            NexLog.logger().warning("Exception when creating table for the view " + this.getName() + "\n" + e);
        }
        NexLog.logger().info("GuiView createTable1 at end");
    }

    private void initiatePopupManager() {
        this.popupMgr = new NodePopupManager(this.toolService, this.messenger, this.model, this.modelAdapter, this, this.leftTable, this.viewService);
        this.popupMenu = new JPopupMenu();
        this.popupMgr.addMoPropertiesMenu(this.popupMenu);
        this.popupMgr.addCopyLdnMenu(this.popupMenu);
        this.popupMgr.addRefreshMenu(this.popupMenu);
        this.popupMgr.addExpandMenu(this.popupMenu);
    }

    private void createTableOnRightSide() {
        NexLog.logger().info("GuiView createTable2");
        this.rightTable = new RightSideTable();
        try {
            ((DefaultTableCellRenderer)this.rightTable.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
        }
        catch (Exception e) {
            NexLog.logger().fine("Exception when trying to set center alaignment to Attribute table: " + e.getMessage());
        }
        RightTableColumnListener tableColumnModelListener = new RightTableColumnListener();
        this.rightTable.getColumnModel().addColumnModelListener(tableColumnModelListener);
        this.rightTable.getColumnModel().setColumnSelectionAllowed(false);
        this.rightTable.setCellSelectionEnabled(false);
        this.rightTable.setRowSelectionAllowed(true);
        this.rightTable.getTableHeader().setReorderingAllowed(true);
        this.rightTable.setAutoCreateColumnsFromModel(false);
        this.rightTable.setModel(this.leftTable.getModel());
        this.setAttributeCellRenderer();
        this.rightTable.setSelectionModel(this.leftTable.getSelectionModel());
        this.setPreferredColumnSizes(this.rightTable, this.viewPreferences);
        this.rightTableScrollPane = new JScrollPane();
        this.rightTableScrollPane.setHorizontalScrollBarPolicy(30);
        this.rightTableScrollPane.setVerticalScrollBarPolicy(20);
        this.rightTableScrollBar = this.rightTableScrollPane.getVerticalScrollBar();
        this.rightTableScrollBar.setUnitIncrement(50);
        this.rightTableScrollBar.addAdjustmentListener(this);
        JScrollBar h2Adjust = this.rightTableScrollPane.getHorizontalScrollBar();
        h2Adjust.setUnitIncrement(50);
        this.rightTableScrollPane.setViewportView(this.rightTable);
        this.rightTable.addMouseMotionListener(new TableMouseMotionAdapter());
        this.tableMouseListener = new TableMouseListener(this.rightTable, this, this.toolService, this);
        this.rightTable.addMouseListener(this.tableMouseListener);
        this.tableKeyListener = new TableKeyListener(this, this);
        this.rightTable.addKeyListener(this.tableKeyListener);
        this.rightTable.setName("table2");
    }

    private void setPreferredColumnSizes(JTable table, GuiViewPreferences prefs) {
        this.setPreferredSizeToColumns(table, prefs.getColumnWidthPreference(this.getColumnNamesFromTable(table)));
    }

    @Override
    public void addColumnByClient(String columnName) {
        if (this.isAttributeInView(columnName)) {
            NexLog.logger().fine(" The column " + columnName + " is already visible");
            return;
        }
        if (columnName.equals(LDN_COLUMN_NAME)) {
            return;
        }
        this.addUserColumn(columnName);
        this.updateTableColumns();
        NexLog.logger().info("GuiView addColumn: " + columnName);
    }

    @Override
    public void removeColumnByClient(String columnName) {
        if (!this.standardNodeAttributes.contains(columnName)) {
            this.removeUserColumn(columnName);
            this.updateTableColumns();
        }
    }

    @Override
    public void refreshRequested() {
        if (this.refreshOngoing) {
            return;
        }
        String[] columnNames = this.model.getColumnNames();
        ArrayList<String> columnNamesCollection = new ArrayList<String>(columnNames.length);
        for (int i = 0; i < columnNames.length; ++i) {
            columnNamesCollection.add(columnNames[i]);
        }
        final int[] rows = this.leftTable.getSelectedRows();
        final Collection<NexTreeNode> nodes = this.getSelectedNodes();
        if (nodes.isEmpty()) {
            return;
        }
        ModelCallback<Void> callBackForGuiUpdate = new ModelCallback<Void>(){

            @Override
            public void run(Void result, boolean cancelled) {
                GuiView.this.modelAdapter.fireTableDataChanged();
                GuiView.this.selectRowsOnEDT(rows, false);
                GuiView.this.refreshOngoing = false;
                StringBuilder strB = new StringBuilder("Refresh of attributes done for: ");
                Iterator iter = nodes.iterator();
                strB.append(((NexTreeNode)iter.next()).getName());
                while (iter.hasNext()) {
                    strB.append(", and ");
                    strB.append(((NexTreeNode)iter.next()).getName());
                }
                strB.append(".");
                GuiView.this.messenger.setStatusMessage(strB.toString());
            }
        };
        this.refreshOngoing = true;
        this.model.asynchronousUpdateNodes(nodes, columnNamesCollection, callBackForGuiUpdate);
    }

    private void addUserColumn(String columnName) {
        this.columnNamesAddedByUser.add(columnName);
        this.viewPreferences.setUserColumnsPreference(this.columnNamesAddedByUser);
    }

    private void removeUserColumn(String columnName) {
        List<String> columnOrder = this.viewPreferences.getColumnOrderPreference();
        columnOrder.remove(columnName);
        this.viewPreferences.setColumnOrderPreference(columnOrder);
        this.columnNamesAddedByUser.remove(columnName);
        this.model.removeColumn(columnName);
        this.viewPreferences.setUserColumnsPreference(this.columnNamesAddedByUser);
    }

    private void setAttributeCellRenderer() {
        NexLog.logger().info("GuiView setAttributeCellRenderer");
        for (int i = 1; i < this.rightTable.getColumnCount(); ++i) {
            this.rightTable.getColumnModel().getColumn(i).setCellRenderer(new AttributeCellRenderer(this.leftTable.getForeground(), this.leftTable.getSelectionForeground(), this.leftTable.getBackground(), this.leftTable.getSelectionBackground(), new JLabel().getBackground()));
        }
    }

    private void initiateViewsPane() {
        NexLog.logger().info("GuiView buildViewsPane");
        this.viewsP = new JPanel(new BorderLayout());
        this.viewsP.setName(VIEWS_TITLE);
        this.supportedViewsList = new JList();
        this.viewDescriptionTA = new JTextArea();
        this.viewDescriptionTA.setLineWrap(true);
        this.viewDescriptionTA.setWrapStyleWord(true);
        this.viewDescriptionTA.setEditable(false);
        this.viewDescriptionTA.setOpaque(false);
        this.viewDescriptionTA.setBorder(new EmptyBorder(10, 10, 10, 10));
        JScrollPane listScrollPane = new JScrollPane(this.supportedViewsList);
        JScrollPane descScrollPane = new JScrollPane(this.viewDescriptionTA);
        descScrollPane.setHorizontalScrollBarPolicy(31);
        listScrollPane.setMinimumSize(new Dimension(240, 200));
        descScrollPane.setMinimumSize(new Dimension(200, 200));
        listScrollPane.setPreferredSize(SCROLLPANE_PREFERRED_SIZE);
        descScrollPane.setPreferredSize(SCROLLPANE_PREFERRED_SIZE);
        JSplitPane splitPane = new JSplitPane(1, listScrollPane, descScrollPane);
        splitPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.selectViewBtn = new JButton("Select View");
        this.selectViewBtn.setMnemonic(69);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.selectViewBtn);
        this.supportedViewsList.setSize(SCROLLPANE_PREFERRED_SIZE);
        this.viewsP.add(splitPane);
        this.viewsP.add((Component)buttonPanel, "South");
        this.supportedViewsList.addListSelectionListener(new ViewListSelectionListener());
        this.selectViewBtn.setActionCommand(ACTION_SELECT_BTN);
        this.selectViewBtn.addActionListener(this);
    }

    private void enableTreeButtons(boolean enable) {
        NexLog.logger().info("GuiView enableTreeButtons");
        if (!enable) {
            this.refreshTreeBtn.setEnabled(false);
            this.abortExpandBtn.setEnabled(true);
            this.viewIsListening(false);
            this.popupMgr.setRefreshOngoing(true);
            this.refreshOngoing = true;
        } else {
            this.refreshTreeBtn.setEnabled(this.connected);
            this.abortExpandBtn.setEnabled(false);
            this.viewIsListening(true);
            this.popupMgr.setRefreshOngoing(false);
            this.refreshOngoing = false;
        }
    }

    private void enableTableButtons(boolean enable) {
        NexLog.logger().info("GuiView enableTableButtons");
        if (!enable) {
            this.refreshTableBtn.setEnabled(false);
            this.abortUpdateTableBtn.setEnabled(true);
        } else {
            this.refreshTableBtn.setEnabled(this.connected);
            this.abortUpdateTableBtn.setEnabled(false);
        }
    }

    private void collapse() {
        int row = this.leftTable.getTree().getRowCount() - 1;
        while (row > -1) {
            NexLog.logger().info("Collapsing row " + row);
            this.leftTable.getTree().collapseRow(row);
            row = Math.min(row - 1, this.leftTable.getTree().getRowCount() - 1);
        }
    }

    private void refreshAttributeTable() {
        final int[] selectedRows = this.leftTable.getSelectedRows();
        ArrayList<NexTreeNode> nodes = new ArrayList<NexTreeNode>(this.modelAdapter.getRowCount());
        for (int i = 0; i < this.modelAdapter.getRowCount(); ++i) {
            nodes.add((NexTreeNode)this.modelAdapter.nodeForRow(i));
        }
        NodeServices nodeserv = null;
        try {
            nodeserv = this.toolService.getNodeServices();
        }
        catch (StartFailureException se) {
            NexLog.logger().warning("Could not get NodeServices.");
        }
        if (null != nodeserv) {
            this.monitorTableProcess("Refreshing attribute values...", this.model.asynchronousBatchUpdate(nodes, this.getColumnNamesFromTable(this.rightTable), nodeserv, new ModelCallback<Boolean>(){

                @Override
                public void run(Boolean b, boolean cancelled) {
                    if (cancelled) {
                        GuiView.this.setStatusMessage("The refresh of " + GuiView.this.viewName + " table values was aborted.");
                    } else {
                        GuiView.this.setStatusMessage("The table values of " + GuiView.this.viewName + " are refreshed.");
                    }
                    GuiView.this.modelAdapter.fireTableDataChanged();
                    GuiView.this.selectRowsOnEDT(selectedRows, false);
                }
            }));
        }
    }

    private void setColumnNamesAddedByUser(Collection<String> columns) {
        this.columnNamesAddedByUser = columns;
    }

    private void selectNewNodesCorrespondingToOldNodes(TreePath[] oldSelectedTreePaths) {
        ArrayList<Integer> rowsToSelect = new ArrayList<Integer>();
        if (oldSelectedTreePaths == null) {
            return;
        }
        block0: for (int oldPathno = 0; oldPathno < oldSelectedTreePaths.length; ++oldPathno) {
            for (int row = 0; row < this.leftTable.getRowCount(); ++row) {
                if (!this.leftTable.getTree().getPathForRow(row).toString().equals(oldSelectedTreePaths[oldPathno].toString())) continue;
                rowsToSelect.add(row);
                continue block0;
            }
        }
        if (0 == rowsToSelect.size()) {
            rowsToSelect.add(0);
        }
        int[] rows = new int[rowsToSelect.size()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = (Integer)rowsToSelect.get(i);
        }
        this.selectRowsOnEDT(rows, true);
    }

    private void selectRowsOnEDT(final int[] rows, final boolean scrollToRows) {
        if (0 == rows.length) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StringBuilder rowsToSelect = new StringBuilder();
                for (int i = 0; i < rows.length; ++i) {
                    rowsToSelect.append(" " + rows[i]);
                }
                NexLog.logger().info("Will select rows: " + rowsToSelect);
                GuiView.this.leftTable.getTree().setSelectionRows(rows);
                if (scrollToRows) {
                    int highestRowNo = rows[0];
                    for (int i = 0; i < rows.length; ++i) {
                        highestRowNo = highestRowNo < rows[i] ? rows[i] : highestRowNo;
                    }
                    Rectangle rect = GuiView.this.leftTable.getCellRect(highestRowNo, 0, true);
                    GuiView.this.leftTableScrollPane.getViewport().scrollRectToVisible(rect);
                }
                GuiView.this.toolService.sendEmNotification(new NexEvent(GuiTestEventTypes.ATTRIBUTE_TABLE_PANEL_UPDATED, (Object)this, GuiTestEventTypes.claimSeqNum(), "The table tab has been updated"));
            }
        });
    }

    private void checkAndUpdateColumns() {
        int rowNo = this.leftTable.getSelectedRow();
        if (rowNo > -1) {
            List<String> currentlyShownAttributes;
            NexTreeNode node = (NexTreeNode)this.modelAdapter.nodeForRow(rowNo);
            this.standardNodeAttributes = node.getTableAttributes();
            ArrayList<String> newTableAttributes = new ArrayList<String>();
            newTableAttributes.addAll(this.standardNodeAttributes);
            newTableAttributes.addAll(this.getColumnNamesAddedByUser());
            if (this.viewPreferences.getShowLDNFlag()) {
                newTableAttributes.add(LDN_COLUMN_NAME);
            }
            if ((currentlyShownAttributes = this.getColumnNamesFromTable(this.rightTable)).size() != newTableAttributes.size() || !currentlyShownAttributes.containsAll(newTableAttributes)) {
                this.updateTableColumns();
            } else {
                this.toolService.sendEmNotification(new NexEvent(GuiTestEventTypes.ATTRIBUTE_TABLE_PANEL_UPDATED, (Object)this, GuiTestEventTypes.claimSeqNum(), "MO attribute table is up to date. No refresh necessary."));
            }
        }
    }

    private void refreshTree() {
        final TreePath[] preselectedTreePaths = this.leftTable.getTree().getSelectionPaths();
        Enumeration<TreePath> expandedPaths = this.leftTable.getTree().getExpandedDescendants(this.leftTable.getTree().getPathForRow(0));
        this.collapse();
        this.monitorTreeProcess("Refreshing the tree...", this.model.asynchronousRefreshAll(expandedPaths, new ModelCallback<Collection<TreePath>>(){

            @Override
            public void run(Collection<TreePath> newPaths, boolean cancelled) {
                GuiView.this.modelAdapter.fireTableDataChanged();
                for (TreePath p : newPaths) {
                    GuiView.this.leftTable.getTree().expandPath(p);
                }
                if (!cancelled) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            GuiView.this.selectNewNodesCorrespondingToOldNodes(preselectedTreePaths);
                        }
                    });
                    GuiView.this.setStatusMessage("The tree of " + GuiView.this.viewName + " is refreshed.");
                } else {
                    GuiView.this.setStatusMessage("The tree refresh of " + GuiView.this.viewName + " was aborted.");
                }
            }
        }));
    }

    @Override
    public void setNodeStateIcons(NodeStateIcon[] iconArray) {
        for (int i = 0; i < 5; ++i) {
            this.stateIconArray[i].setIcon(null);
            this.stateIconArray[i].setToolTipText("");
        }
        if (null != iconArray) {
            int numberOfIcons = iconArray.length;
            if (numberOfIcons > 5) {
                NexLog.logger().warning("Maximum number of state icons exceeded.");
            }
            for (int i = 0; i < numberOfIcons; ++i) {
                NodeStateIcon icon = iconArray[i];
                String tooltip = iconArray[i].getTooltip();
                this.stateIconArray[i].setIcon(icon);
                this.stateIconArray[i].setToolTipText(tooltip);
                this.stateIconArray[i].setName(tooltip);
                if (icon.getIconHeight() <= 0 || icon.getIconWidth() <= 0) continue;
                this.toolService.sendEmNotification(new NexEvent(GuiTestEventTypes.STATUS_ICON_UPDATED, (Object)this, GuiTestEventTypes.claimSeqNum(), "Status Icon has been updated"));
            }
        }
    }

    public JLabel[] getStateIconArray() {
        return this.stateIconArray;
    }

    private String formatToolTipText(String text) {
        if (text.length() > 25) {
            String textRep = this.escRegEx(text);
            textRep = text.replaceAll(";", ";<br>");
            textRep = textRep.replaceAll(",", ",<br>");
            textRep = textRep.replaceAll("}", "}<br>");
            String newToolTip = new String("<html>" + textRep + "</html>");
            return newToolTip;
        }
        return text;
    }

    private String escRegEx(String inStr) {
        return inStr.replaceAll("([\\\\*+\\[\\](){}\\$.?\\^|])", "\\\\$1");
    }

    private void changeView() {
        final String selectedView = (String)this.supportedViewsList.getSelectedValue();
        if (selectedView == null) {
            NexLog.logger().finer("No view selected");
        } else {
            final NexTreeNode selectedNode = this.getSelectedNode();
            if (!selectedNode.isFolder()) {
                Runnable startViewFromViewTabRunner = new Runnable(){

                    public void run() {
                        GuiView.this.viewService.startView(selectedView, selectedNode.getLongName());
                    }
                };
                new Thread(startViewFromViewTabRunner, "startViewFromViewTabThread").start();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String actionCmd = evt.getActionCommand();
        if (evt.getSource() == this.updateTimer) {
            this.delayedChange();
        } else if (actionCmd.equals(ACTION_SELECT_BTN)) {
            this.changeView();
        } else if (actionCmd.equals(ACTION_REFRESH_TREE)) {
            this.refreshTree();
        } else if (actionCmd.equals(ACTION_ABORT_EXPAND)) {
            this.abortExpand();
        } else if (actionCmd.equals(ACTION_REFRESH_TABLE)) {
            this.setStatusMessage("Refreshing the table values...");
            this.refreshAttributeTable();
        } else if (actionCmd.equals(ACTION_ABORT_UPDATE_TABLE)) {
            this.abortUpdateTable();
        }
    }

    private void abortUpdateTable() {
        this.setStatusMessage("Abort");
        this.cancelTableProcess();
        this.tableProgressBar.setVisible(false);
        NexLog.logger().info("abortUpdateTableBtn cancelUpdate called");
    }

    private void abortExpand() {
        this.setStatusMessage("Abort");
        this.cancelTreeProcess();
        this.treeProgressBar.setVisible(false);
        NexLog.logger().info("abortExpandBtn cancelExpansion called");
    }

    private void delayedChange() {
        if (!this.leftTable.isShowing()) {
            return;
        }
        if (this.somethingChanged()) {
            this.lastSelectedRows = this.leftTable.getSelectedRows();
            this.lastNumRows = this.leftTable.getRowCount();
            this.lastWasNew = true;
            return;
        }
        if (!this.lastWasNew) {
            return;
        }
        this.lastWasNew = false;
        this.myCurrentTab = this.embeddablesPanel.getSelectedIndex();
        if (this.embeddablesPanel.getTitleAt(this.myCurrentTab).equals(VIEWS_TITLE)) {
            this.showViews();
        } else if (this.embeddablesPanel.getTitleAt(this.myCurrentTab).equals(DESCRIPTION_TITLE)) {
            this.showDescription();
        } else if (!this.embeddablesPanel.getTitleAt(this.myCurrentTab).equals(TABLE_TITLE)) {
            this.showEmbeddables();
        } else if (this.embeddablesPanel.getTitleAt(this.myCurrentTab).equals(TABLE_TITLE)) {
            this.checkAndUpdateColumns();
        }
    }

    private boolean somethingChanged() {
        int[] currentRows = this.leftTable.getSelectedRows();
        int currentNumRows = this.leftTable.getRowCount();
        int len = currentRows.length;
        if (len != this.lastSelectedRows.length || currentNumRows != this.lastNumRows) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (this.lastSelectedRows[i] == currentRows[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (this.updatingTableColumns) {
            if (e.getSource() == this.rightTableScrollBar) {
                this.rightTableScrollBar.setValue(this.leftTableScrollBar.getValue());
                this.updatingTableColumns = false;
            }
            return;
        }
        if (e.getSource() == this.leftTableScrollBar) {
            this.rightTableScrollBar.setValue(e.getValue());
        } else if (this.rightTable.getColumnCount() > 0) {
            this.leftTableScrollBar.setValue(e.getValue());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProcessListener
    implements PropertyChangeListener {
        private JProgressBar progressBar;
        private ModelWorker<?, ?> currentWorker = null;
        private HashMap<ModelWorker<?, ?>, String> workerMessages = new HashMap();
        private long startTime;
        private boolean justStarted;

        public ProcessListener(JProgressBar progressBar) {
            this.progressBar = progressBar;
        }

        public void cancelCurrent() {
            if (this.currentWorker != null) {
                this.currentWorker.cancel(false);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof ModelWorker) {
                if (evt.getPropertyName().equals("state")) {
                    if (evt.getNewValue().equals(SwingWorker.StateValue.STARTED)) {
                        this.startTime = System.currentTimeMillis();
                        this.justStarted = true;
                        this.currentWorker = (ModelWorker)((Object)evt.getSource());
                        String msg = this.workerMessages.get(this.currentWorker);
                        if (msg != null) {
                            GuiView.this.setStatusMessage(msg);
                        }
                    } else if (evt.getNewValue().equals(SwingWorker.StateValue.DONE)) {
                        this.progressBar.setVisible(false);
                        this.workerMessages.remove(this.currentWorker);
                        this.currentWorker = null;
                    }
                } else if (evt.getPropertyName().equals("progress")) {
                    if (this.justStarted && System.currentTimeMillis() - this.startTime > 2000L) {
                        this.progressBar.setVisible(true);
                        this.justStarted = false;
                        this.startTime = 0L;
                    }
                    this.progressBar.setValue((Integer)evt.getNewValue());
                }
            }
        }

        public void addWorker(ModelWorker<?, ?> worker, String message) {
            worker.addPropertyChangeListener(this);
            this.workerMessages.put(worker, message);
        }
    }

    private class ViewListSelectionListener
    implements ListSelectionListener {
        private ViewListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            String selectedView = (String)GuiView.this.supportedViewsList.getSelectedValue();
            if (selectedView != null) {
                String description = GuiView.this.viewService.getViewInfo().getDescription(selectedView);
                if (description == null) {
                    description = GuiView.DEFAULT_DESCRIPTION;
                }
                GuiView.this.viewDescriptionTA.setText(description);
            } else {
                GuiView.this.viewDescriptionTA.setText("");
            }
        }
    }

    private class RightTableColumnListener
    implements TableColumnModelListener {
        private RightTableColumnListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnMoved(TableColumnModelEvent e) {
            int to;
            int from = e.getFromIndex();
            if (from != (to = e.getToIndex())) {
                GuiView.this.viewPreferences.setColumnOrderPreference(GuiView.this.getColumnNamesFromTable(GuiView.this.rightTable));
            }
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    private class RightSideTable
    extends JTable {
        private static final long serialVersionUID = 6719025113549586906L;

        private RightSideTable() {
        }

        protected JTableHeader createDefaultTableHeader() {
            JTableHeader header = new JTableHeader(this.getColumnModel()){
                private static final long serialVersionUID = -8558903818615061842L;

                public String getToolTipText(MouseEvent e) {
                    Point p = e.getPoint();
                    int index = this.columnModel.getColumnIndexAtX(p.x);
                    return this.columnModel.getColumn(index).getHeaderValue().toString();
                }
            };
            GuiView.this.columnHeaderListener = new MouseAdapter(){

                public void mouseReleased(MouseEvent event) {
                    if (null != GuiView.this.viewPreferences) {
                        JTable table = ((JTableHeader)event.getSource()).getTable();
                        GuiView.this.viewPreferences.setColumnWidthPreference(GuiView.this.getColumnNameWidths(table));
                    }
                }
            };
            header.addMouseListener(GuiView.this.columnHeaderListener);
            return header;
        }
    }

    private class TabPaneChangeListener
    implements ChangeListener {
        private TabPaneChangeListener() {
        }

        public void stateChanged(ChangeEvent ev) {
            GuiView.this.myCurrentTab = GuiView.this.embeddablesPanel.getSelectedIndex();
            if (null == GuiView.this.embeddablesPanel || -1 == GuiView.this.myCurrentTab) {
                return;
            }
            GuiView.this.setStatusMessage("");
            if (GuiView.this.embeddablesPanel.getTitleAt(GuiView.this.myCurrentTab).equals(GuiView.TABLE_TITLE)) {
                GuiView.this.checkAndUpdateColumns();
            } else if (GuiView.this.embeddablesPanel.getTitleAt(GuiView.this.myCurrentTab).equals(GuiView.VIEWS_TITLE)) {
                GuiView.this.showViews();
            } else if (GuiView.this.embeddablesPanel.getTitleAt(GuiView.this.myCurrentTab).equals(GuiView.DESCRIPTION_TITLE)) {
                GuiView.this.showDescription();
            } else {
                GuiView.this.showEmbeddables();
            }
        }
    }

    private class TableMouseMotionAdapter
    extends MouseMotionAdapter {
        private TableMouseMotionAdapter() {
        }

        public void mouseMoved(MouseEvent ev) {
            if (ev.getSource() == GuiView.this.leftTable) {
                Point p = ev.getPoint().getLocation();
                int rowNo = GuiView.this.leftTable.rowAtPoint(p);
                NexTreeNode node = (NexTreeNode)GuiView.this.modelAdapter.nodeForRow(rowNo);
                GuiView.this.leftTable.setToolTipText(GuiView.this.formatToolTipText(node.getToolTip()));
            } else if (ev.getSource() == GuiView.this.rightTable) {
                Point p = ev.getPoint().getLocation();
                int rowNo = GuiView.this.rightTable.rowAtPoint(p);
                int colNo = GuiView.this.rightTable.columnAtPoint(p);
                GuiView.this.rightTable.setToolTipText(GuiView.this.formatToolTipText(GuiView.this.rightTable.getValueAt(rowNo, colNo).toString()));
            }
        }
    }

    private class LeftTableMouseListener
    implements MouseListener {
        private LeftTableMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() || e.isControlDown()) {
                Point p = e.getPoint().getLocation();
                int rowNo = GuiView.this.leftTable.rowAtPoint(p);
                int[] selRows = GuiView.this.leftTable.getSelectedRows();
                boolean found = false;
                for (int i = 0; i < selRows.length; ++i) {
                    if (selRows[i] != rowNo) continue;
                    found = true;
                }
                if (e.isPopupTrigger()) {
                    GuiView.this.leftTable.setRowSelectionInterval(rowNo, rowNo);
                } else if (e.isControlDown() && e.getButton() == 1) {
                    if (found) {
                        GuiView.this.leftTable.getSelectionModel().removeSelectionInterval(rowNo, rowNo);
                    } else {
                        GuiView.this.leftTable.getSelectionModel().addSelectionInterval(rowNo, rowNo);
                    }
                }
            }
            GuiView.this.setStatusMessage("");
        }

        public void mouseReleased(MouseEvent e) {
            Point p = e.getPoint().getLocation();
            int rowNo = GuiView.this.leftTable.rowAtPoint(p);
            if (e.isPopupTrigger()) {
                GuiView.this.leftTable.setRowSelectionInterval(rowNo, rowNo);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

