/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view.workers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.gui.view.MoTreeTableModel;
import se.ericsson.cello.nex.gui.view.NexTreeNode;
import se.ericsson.cello.nex.gui.view.workers.ModelCallback;
import se.ericsson.cello.nex.gui.view.workers.ModelWorker;
import se.ericsson.cello.nex.viewservices.model.ViewElementI;
import se.ericsson.cello.nex.viewservices.utils.MoReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchUpdateWorker
extends ModelWorker<Boolean, Object> {
    private ModelCallback<Boolean> callback;
    private Collection<String> attributes;
    private Collection<NexTreeNode> nodes;
    private NodeServices nodeServices;

    public BatchUpdateWorker(MoTreeTableModel model, NodeServices nodeServices, Collection<NexTreeNode> nodes, Collection<String> attributes, ModelCallback<Boolean> callback) {
        super(model);
        this.callback = callback;
        this.nodes = nodes;
        this.attributes = attributes;
        this.nodeServices = nodeServices;
    }

    @Override
    protected Boolean doWork() throws Exception {
        ArrayList<ViewElementI> viewElements = new ArrayList<ViewElementI>(this.nodes.size());
        for (NexTreeNode node : this.nodes) {
            viewElements.add(node.getViewElement());
        }
        MoReader moReader = new MoReader(this.nodeServices);
        moReader.refreshNodes(viewElements, this.attributes.toArray(new String[0]));
        while (!moReader.isRequestFinished()) {
            if (this.isCancelled()) {
                moReader.abortRequest();
                return false;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {}
        }
        for (ViewElementI element : viewElements) {
            if (this.isCancelled()) continue;
            element.refreshAttributes(this.attributes.toArray(new String[0]));
        }
        return true;
    }

    protected void done() {
        Boolean result;
        block4: {
            result = false;
            try {
                result = (Boolean)this.get();
            }
            catch (CancellationException e) {
            }
            catch (Exception e) {
                NexLog.logger().warning("Exception caught in BatchUpdateWorker.done() \n" + NexLog.stackToString(e));
                if (this.callback == null) break block4;
                this.callback.setException(e);
            }
        }
        if (this.callback != null) {
            this.callback.run(result, this.isCancelled());
        }
    }

    public String toString() {
        return "Batch updating attributes of " + this.nodes.size() + " nodes";
    }
}

