/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view.workers;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Timer;
import se.ericsson.cello.emt.utils.guihelper.SwingWorker;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.gui.view.MoTreeTableModel;
import se.ericsson.cello.nex.gui.view.NexTreeNode;
import se.ericsson.cello.nex.viewservices.model.ViewElementI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelWorker<T, V>
extends SwingWorker<T, V> {
    private MoTreeTableModel model;
    private Timer continuousProgressTimer;

    public ModelWorker(MoTreeTableModel model) {
        this.model = model;
        this.continuousProgressTimer = new Timer(100, new ActionListener(){
            private int progress = 0;

            public void actionPerformed(ActionEvent e) {
                this.progress += 10;
                ModelWorker.this.setProgress(this.progress % 100);
            }
        });
        this.continuousProgressTimer.setInitialDelay(2000);
    }

    protected abstract T doWork() throws Exception;

    protected T doInBackground() throws Exception {
        NexLog.logger().info("Running worker: " + ((Object)((Object)this)).toString());
        this.continuousProgressTimer.start();
        this.setProgress(0);
        T result = this.doWork();
        this.continuousProgressTimer.stop();
        NexLog.logger().info("Finished worker: " + ((Object)((Object)this)).toString());
        return result;
    }

    protected void updateProgress(int value) {
        this.continuousProgressTimer.stop();
        if (value > 100) {
            value = 100;
        }
        this.setProgress(value);
    }

    public MoTreeTableModel getModel() {
        return this.model;
    }

    protected void addNewChildrenToNode(NexTreeNode node, List<NexTreeNode> newChildren) {
        NexLog.logger().log(Level.INFO, "adding " + newChildren.size() + " children to " + node.getName());
        Collections.sort(newChildren);
        int[] indices = new int[newChildren.size()];
        int i = 0;
        for (NexTreeNode child : newChildren) {
            indices[i] = i;
            node.insert(child, i++);
        }
        this.model.nodesWereInserted(node, indices);
    }

    protected void replaceAllChildren(NexTreeNode parent, List<NexTreeNode> newChildren) {
        parent.removeAllChildren();
        this.model.nodeStructureChanged(parent);
        this.addNewChildrenToNode(parent, newChildren);
        parent.allChildrenFetched();
    }

    protected List<NexTreeNode> createNexTreeNodes(Collection<ViewElementI> viewElements) throws Exception {
        ArrayList<NexTreeNode> newNodes = new ArrayList<NexTreeNode>(viewElements.size());
        for (ViewElementI viewElem : viewElements) {
            newNodes.add(this.model.getNodeFactory().createNode(viewElem));
        }
        return newNodes;
    }

    protected List<NexTreeNode> createChildNodesFor(NexTreeNode node) throws Exception {
        String[] columnNames = this.model.getColumnNames();
        Collection<ViewElementI> childElements = node.getViewElement().getChildren(columnNames);
        return this.createNexTreeNodes(childElements);
    }
}

