/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.viewservices.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.nex.ConfigurationFactory;
import se.ericsson.cello.nex.ConfigurationI;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.viewservices.model.ChPaAttrData;
import se.ericsson.cello.nex.viewservices.model.ContainmentModel;
import se.ericsson.cello.nex.viewservices.model.MoHolder;
import se.ericsson.cello.nex.viewservices.model.Relation;
import se.ericsson.cello.nex.viewservices.model.Task;
import se.ericsson.cello.nex.viewservices.model.TreeNodeObjectHelperI;
import se.ericsson.cello.nex.viewservices.model.ViewElementDataI;
import se.ericsson.cello.nex.viewservices.model.ViewElementI;
import se.ericsson.cello.nex.viewservices.model.ViewModelI;
import se.ericsson.cello.nex.viewservices.utils.MoClassResolver;
import se.ericsson.cello.nex.viewservices.utils.MoReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNodeObject
implements ViewElementI {
    private boolean checkChildren = false;
    private ViewModelI viewModel;
    private Relation relation;
    private ViewElementDataI elementData;
    private Hashtable<String, String> attributeCache;
    private Hashtable<String, NameValue> nameValueCache;
    static final String NO_DESCRIPTION = "No description available.";
    static final String DEPRECATED = "Deprecated: ";
    static final String LOCK_BEFORE_DELETE = "LockBeforeDelete: ";
    public static final String ALL_MO_TYPES = "";
    private NodeServices nodeServ;
    private MimModel mim;
    private Mo mo;
    private MoHolder moHolder;
    private String rdn;
    private TreeNodeObjectHelperI helper;

    public TreeNodeObject(ViewModelI aViewModel, NodeServices nodeServices, Relation aRelation, String ldn, TreeNodeObjectHelperI helper) {
        this(aViewModel, nodeServices, aRelation, nodeServices.getNode().getCmService().getMo(ldn), helper);
    }

    public TreeNodeObject(ViewModelI aViewModel, NodeServices nodeServices, Relation aRelation, Mo anMo, TreeNodeObjectHelperI helper) {
        this(aViewModel, nodeServices, aRelation, new MoHolder(anMo, false, false), helper);
    }

    public TreeNodeObject(ViewModelI aViewModel, NodeServices nodeServices, Relation aRelation, MoHolder anMoHolder, TreeNodeObjectHelperI aHelper) {
        this.mim = nodeServices.getMimModel();
        this.relation = aRelation;
        this.elementData = this.relation.getNodeData();
        this.attributeCache = new Hashtable();
        this.nameValueCache = new Hashtable();
        this.viewModel = aViewModel;
        this.mo = anMoHolder.getMo();
        this.moHolder = anMoHolder;
        this.nodeServ = nodeServices;
        this.rdn = this.mo.getLdn().substring(this.mo.getLdn().lastIndexOf(",") + 1);
        ConfigurationI config = ConfigurationFactory.getConfigurationHandler();
        if (config != null) {
            this.checkChildren = config.shouldCheckChildren();
        }
        this.helper = aHelper;
    }

    @Override
    public Collection<Task> getTasks() {
        NexLog.logger().info("Gettting tasks for: " + this.getName());
        Collection<Object> retList = null;
        if (this.elementData != null && this.relation.getRelationKind() != 5) {
            retList = this.elementData.getTask();
        }
        return null != retList ? retList : new ArrayList(0);
    }

    @Override
    public String getLdn() {
        return this.mo.getLdn();
    }

    @Override
    public String getName() {
        if (4 == this.relation.getRelationKind()) {
            return this.elementData.getName();
        }
        return this.rdn;
    }

    @Override
    public ViewElementI.ViewElementType getType() {
        switch (this.relation.getRelationKind()) {
            case 2: {
                return ViewElementI.ViewElementType.PARENT;
            }
            case 1: {
                return ViewElementI.ViewElementType.CHILD;
            }
            case 3: {
                return ViewElementI.ViewElementType.REFERENCE;
            }
            case 5: {
                return ViewElementI.ViewElementType.CONTAINMENT;
            }
            case 4: {
                return ViewElementI.ViewElementType.FOLDER;
            }
            case 6: {
                return ViewElementI.ViewElementType.MO;
            }
        }
        return ViewElementI.ViewElementType.MO;
    }

    @Override
    public String getReferencingAttribute() {
        return this.elementData.getReferencingAttribute();
    }

    @Override
    public String getMoClass() {
        return this.mo.getType();
    }

    @Override
    public String getDescription() {
        String descr = this.elementData.getDescription();
        if (descr.equals(ALL_MO_TYPES)) {
            descr = NO_DESCRIPTION;
        }
        if (4 != this.relation.getRelationKind()) {
            MomClass ent = this.mim.getClass(this.mo.getType());
            if (null == ent) {
                descr = NO_DESCRIPTION;
            } else {
                descr = ent.getExtendedDescription();
                String deprecated = ent.getDeprecated();
                if (deprecated != null) {
                    descr = descr + "\n\nDeprecated: " + deprecated;
                }
                String lockBeforeDelete = null;
                if (ent.isLockBeforeDelete()) {
                    lockBeforeDelete = "LockBeforeDelete: true";
                }
                if (lockBeforeDelete != null) {
                    descr = descr + "\n" + lockBeforeDelete;
                }
            }
            if (null == descr) {
                descr = NO_DESCRIPTION;
            }
        }
        return descr;
    }

    @Override
    public Collection<ViewElementI> getChildren() throws Exception {
        return this.getChildren(new String[0]);
    }

    @Override
    public Collection<ViewElementI> getChildren(String[] attributes) throws Exception {
        NexLog.logger().info("getChildren for " + this.getName());
        Collection<Relation> relations = this.viewModel.getSubRelations(this.elementData);
        List<Object> moRefs = new ArrayList();
        List<Object> moHolders = new ArrayList();
        ArrayList<ViewElementI> children = new ArrayList<ViewElementI>();
        for (Relation rel : relations) {
            TreeNodeObject child;
            switch (rel.getRelationKind()) {
                case 1: {
                    moHolders = this.helper.getSubMoHoldersAsChildren(this.mim, this.mo, this.checkChildren, rel.getNodeData());
                    break;
                }
                case 4: {
                    moRefs = this.helper.getSubMOsAsFolder(this.mo, rel.getNodeData());
                    break;
                }
                case 3: {
                    moRefs = this.helper.getSubMOsAsReferences(this.mim, this.mo, rel.getNodeData());
                    break;
                }
                case 2: {
                    moRefs = this.helper.getSubMOsAsParent(this.mo, rel.getNodeData());
                    break;
                }
                case 5: {
                    moHolders = this.helper.getSubMoHoldersAsContainment(this.mim, this.mo, this.checkChildren);
                    break;
                }
                case 6: {
                    moRefs = this.helper.getSubMOsAsMO(this.nodeServ, this.mim, this.mo, rel.getNodeData());
                    break;
                }
                default: {
                    NexLog.logger().warning("An unknown kind of view element relation.");
                }
            }
            for (Mo mo : moRefs) {
                child = rel.getRelationKind() == 5 ? new TreeNodeObject((ViewModelI)new ContainmentModel(this.viewModel.getAttributeNames()), this.nodeServ, new Relation(5, this.elementData), mo, this.helper) : new TreeNodeObject(this.viewModel, this.nodeServ, rel, mo, this.helper);
                if (rel.getRelationKind() == 4 && rel.getNodeData().isHideEmptyFolderEnabled()) {
                    NexLog.logger().info("Hide empty folder is enabled. Check children");
                    if (child.getChildren().isEmpty()) continue;
                    children.add(child);
                    continue;
                }
                children.add(child);
            }
            for (MoHolder moHolder : moHolders) {
                child = rel.getRelationKind() == 5 ? new TreeNodeObject((ViewModelI)new ContainmentModel(this.viewModel.getAttributeNames()), this.nodeServ, new Relation(5, this.elementData), moHolder, this.helper) : new TreeNodeObject(this.viewModel, this.nodeServ, rel, moHolder, this.helper);
                children.add(child);
            }
            moRefs.clear();
            moHolders.clear();
        }
        if (attributes.length > 0) {
            NexLog.logger().info("Prefetching attributes");
            MoReader moAttributeReader = new MoReader(this.nodeServ);
            Map<String, NameValue[]> prefetchedData = moAttributeReader.fetchAttributes(children, attributes);
            NexLog.logger().info("Prefetching done. Will call refreshAttributes for all " + prefetchedData.size() + " children.");
            for (ViewElementI viewElementI : children) {
                viewElementI.refreshAttributes(attributes);
            }
        }
        return children;
    }

    @Override
    public boolean allowsChildren() {
        NexLog.logger().info("allowsChildren for " + this.getName());
        boolean canHaveChild = false;
        if (this.elementData.allowsChildren()) {
            Collection<Relation> relations = this.viewModel.getSubRelations(this.elementData);
            for (Relation rel : relations) {
                switch (rel.getRelationKind()) {
                    case 1: 
                    case 5: {
                        try {
                            if (MoClassResolver.resolveChildrenMoClasses(this.mim, "re(.*)", this.mo.getType()).size() <= 0) break;
                            canHaveChild = true;
                        }
                        catch (Exception e) {
                            NexLog.logger().log(Level.WARNING, e.getMessage());
                        }
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        canHaveChild = true;
                    }
                }
                if (!canHaveChild) continue;
                break;
            }
        }
        if (!canHaveChild) {
            this.moHolder.setHasChildren(false);
        }
        return canHaveChild;
    }

    @Override
    public boolean hasChildren() {
        boolean hasChildren = true;
        hasChildren = !this.checkChildren ? true : this.hasElementChildren();
        return hasChildren;
    }

    private boolean hasElementChildren() {
        NexLog.logger().info("hasChildren for " + this.getName());
        if (!this.allowsChildren()) {
            return false;
        }
        boolean foundChild = false;
        Collection<Relation> relations = this.viewModel.getSubRelations(this.elementData);
        for (Relation rel : relations) {
            switch (rel.getRelationKind()) {
                case 1: 
                case 5: {
                    if (!this.moHolder.hasCheckedChildren()) {
                        try {
                            this.moHolder.setHasChildren(this.mo.hasChildren(null));
                        }
                        catch (Exception e) {
                            NexLog.logger().log(Level.WARNING, e.getMessage());
                            this.moHolder.setHasChildren(true);
                        }
                    }
                    if (!this.moHolder.hasChildren()) break;
                    foundChild = true;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    foundChild = true;
                }
            }
            if (!foundChild) continue;
            break;
        }
        return foundChild;
    }

    @Override
    public boolean refreshHasChildren() {
        NexLog.logger().info("Refreshing if " + this.getName() + " has children");
        this.moHolder.resetCheck();
        return this.hasChildren();
    }

    @Override
    public void refreshAttributes(String[] attributes) {
        NexLog.logger().info("Refreshing attributes for: " + this.getName());
        this.attributeCache.clear();
        this.fillAttributeCache(attributes);
        this.nameValueCache.clear();
    }

    @Override
    public String getAttributeValue(String attributeName) {
        String attr = this.attributeCache.get(attributeName);
        if (null != attr) {
            return attr;
        }
        String ret = this.getAttributeValue(attributeName, this.mo);
        if ("Not Applicable".equals(ret)) {
            ret = this.getChildOrParentAttribute(attributeName.trim());
        }
        this.attributeCache.put(attributeName, ret);
        return ret;
    }

    @Override
    public Collection<String> getDefinedTableAttributes() {
        if (this.elementData.getTableAttributes().size() != 0) {
            return this.elementData.getTableAttributes();
        }
        return this.viewModel.getAttributeNames();
    }

    @Override
    public void setAttributeValues(NameValue[] nameValues) {
        this.nameValueCache.clear();
        if (nameValues != null) {
            for (int i = 0; i < nameValues.length; ++i) {
                this.nameValueCache.put(nameValues[i].getName(), nameValues[i]);
            }
        }
    }

    @Override
    public String getMoType() {
        return this.mo.getType();
    }

    private String getAttributeValue(String attributeName, Mo anMo) {
        NexLog.logger().info("getAttributeValue with MO: " + anMo.getLdn() + "\nand with attribute: " + attributeName);
        boolean isStruct = false;
        String structMemberName = ALL_MO_TYPES;
        int dotPlace = attributeName.indexOf(".");
        if (dotPlace > -1 && attributeName.length() > 1) {
            isStruct = true;
            structMemberName = attributeName.substring(dotPlace + 1);
            attributeName = attributeName.substring(0, dotPlace);
        }
        String retString = "Not Applicable";
        if (MoClassResolver.hasAttribute(this.mim, anMo.getType(), attributeName)) {
            try {
                NameValue nameVal = this.nameValueCache.get(attributeName);
                if (nameVal == null) {
                    nameVal = anMo.getAttribute(attributeName, null);
                }
                retString = isStruct && 11 == nameVal.getType() ? this.helper.getStructMemberValue(structMemberName, retString, nameVal) : this.helper.resolveEnum(this.mim, attributeName, nameVal, anMo);
            }
            catch (Exception exe) {
                StringBuilder messageBuilder = new StringBuilder();
                messageBuilder.append("Problem getting the value of the attribute ");
                messageBuilder.append(attributeName);
                messageBuilder.append(" for the MO ");
                messageBuilder.append(anMo.getLdn());
                messageBuilder.append(" ");
                messageBuilder.append(exe.toString());
                NexLog.logger().info(messageBuilder.toString());
            }
        }
        return retString;
    }

    private String getChildOrParentAttribute(String attributeString) {
        Mo anMo;
        String retString = "Not Applicable";
        Collection<ChPaAttrData> attrDatas = this.elementData.getChPaAttrData();
        if (attrDatas.size() > 0 && null != (anMo = this.helper.findChildOrParentMoWithAttribute(this.mim, this.mo, attributeString, attrDatas)) && (retString = this.getAttributeValue(attributeString, anMo)) != "Not Applicable") {
            retString = "[" + anMo.getType() + "] " + retString;
        }
        return retString;
    }

    private void fillAttributeCache(String[] attributes) {
        if (0 == attributes.length) {
            return;
        }
        if (this.getType().equals((Object)ViewElementI.ViewElementType.FOLDER)) {
            return;
        }
        if (1 == attributes.length) {
            this.getAttributeValue(attributes[0]);
            return;
        }
        ArrayList<String> attributesToFetch = new ArrayList<String>();
        ArrayList<String> notMyAttrs = new ArrayList<String>();
        for (String attr : attributes) {
            if (attr.contains(".")) {
                attr = attr.substring(0, attr.indexOf("."));
            }
            if (MoClassResolver.hasAttribute(this.mim, this.getMoClass(), attr)) {
                if (this.nameValueCache.containsKey(attr)) continue;
                attributesToFetch.add(attr);
                continue;
            }
            notMyAttrs.add(attr);
        }
        ArrayList<NameValue> nameValues = new ArrayList<NameValue>();
        nameValues.addAll(this.nameValueCache.values());
        if (attributesToFetch.size() > 0) {
            this.helper.getNameValuesFromNode(this.mo, attributesToFetch, nameValues);
        }
        block1: for (NameValue nv : nameValues) {
            for (String attrName : attributes) {
                if (attrName.startsWith(nv.getName() + ".") && 11 == nv.getType()) {
                    String defaultValue = "Not Applicable";
                    this.attributeCache.put(attrName, this.helper.getStructMemberValue(attrName, defaultValue, nv));
                    continue;
                }
                if (!nv.getName().equalsIgnoreCase(attrName)) continue;
                this.attributeCache.put(attrName, this.helper.resolveEnum(this.mim, attrName, nv, this.mo));
                continue block1;
            }
        }
        for (String attri : notMyAttrs) {
            String valu = this.getChildOrParentAttribute(attri.trim());
            this.attributeCache.put(attri, valu);
        }
    }
}

