/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common.reflect.common;

import java.lang.reflect.Field;
import java.util.Vector;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.common.reflect.common.Classes;

public class Fields {
    private static final int VAR_FIELDS_OP = 0;
    private static final int CONST_FIELDS_OP = 1;
    private static final int ALL_FIELDS_OP = 2;

    public static String value2name(Class c, Object value) {
        String name = null;
        Field[] f = Fields.getConstFields(c, null, null);
        for (int i = 0; i < f.length; ++i) {
            if (!Fields.getConstValue(c, f[i].getName()).equals(value)) continue;
            name = f[i].getName();
            break;
        }
        return name;
    }

    public static Field[] getVarFields(Class c, Class typeFilter, String fieldNameFilter) {
        return Fields.getFields(c, typeFilter, fieldNameFilter, 0);
    }

    public static Field[] getConstFields(Class c, Class typeFilter, String fieldNameFilter) {
        return Fields.getFields(c, typeFilter, fieldNameFilter, 1);
    }

    public static Object[] getConstValues(Object instance, Class typeFilter, String fieldNameFilter) {
        return Fields.getFieldValues(instance, typeFilter, fieldNameFilter, 1);
    }

    public static Object[] getVarValues(Object instance, Class typeFilter, String fieldNameFilter) {
        return Fields.getFieldValues(instance, typeFilter, fieldNameFilter, 0);
    }

    public static Object getConstValue(Class c, String fieldName) {
        Object o = null;
        try {
            Field fi = Fields.getField(c, fieldName);
            if (fi != null) {
                o = fi.get(fi);
            }
        }
        catch (NullPointerException npe) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return o;
    }

    public static Object getVarValue(Object instance, String fieldName) {
        Object o = null;
        try {
            Field fi = Fields.getField(instance.getClass(), fieldName);
            if (fi != null) {
                o = fi.get(instance);
            }
        }
        catch (NullPointerException npe) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return o;
    }

    public static Field getField(Class c, String fieldName) {
        Field f = null;
        try {
            f = Classes.getClassDescriptor(c).getDeclaredField(fieldName);
        }
        catch (IllegalArgumentException iarge) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return f;
    }

    public static boolean isVar(Field f) {
        return f != null && !Fields.isConst(f) && f.getModifiers() != 16;
    }

    public static boolean isConst(Field f) {
        return f != null && f.getModifiers() == 25;
    }

    public static boolean isPrim(Field f) {
        return f != null && f.getType().isPrimitive();
    }

    public static boolean isArray(Field f) {
        return f != null && f.getType().isArray();
    }

    public static boolean isPrimArray(Field f) {
        return f != null && f.getType().isArray() && (Fields.isIntArray(f) || Fields.isLongArray(f) || Fields.isStringArray(f) || Fields.isBooleanArray(f));
    }

    public static boolean isBooleanArray(Field f) {
        return Fields.isThisArrayType(f, Boolean.TYPE);
    }

    public static boolean isIntArray(Field f) {
        return Fields.isThisArrayType(f, Integer.TYPE);
    }

    public static boolean isLongArray(Field f) {
        return Fields.isThisArrayType(f, Long.TYPE);
    }

    public static boolean isString(Field f) {
        return Fields.isThisType(f, Strings.TYPE);
    }

    public static boolean isStringArray(Field f) {
        return Fields.isThisArrayType(f, Strings.TYPE) || Fields.isThisArrayType(f, Character.TYPE);
    }

    private static Object[] getFieldValues(Object instance, Class classTypeFilter, String fieldNameFilter, int operationType) {
        Object[] values = new Object[]{};
        switch (operationType) {
            case 1: {
                Field[] fields = Fields.getConstFields(instance.getClass(), classTypeFilter, fieldNameFilter);
                values = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    values[i] = Fields.getConstValue(instance.getClass(), fields[i].getName());
                }
                break;
            }
            case 0: {
                Field[] fields = Fields.getVarFields(instance.getClass(), classTypeFilter, fieldNameFilter);
                values = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    values[i] = Fields.getVarValue(instance, fields[i].getName());
                }
                break;
            }
        }
        return values;
    }

    private static boolean isThisType(Field f, Class c) {
        return f != null && c != null && f.getType().equals(c);
    }

    private static boolean isThisArrayType(Field f, Class c) {
        return f != null && c != null && Fields.isArray(f) && f.getType().getComponentType().equals(c);
    }

    private static boolean hasOpStatus(int operationType, Field f) {
        boolean status;
        switch (operationType) {
            case 0: {
                status = f == null ? false : Fields.isVar(f);
                break;
            }
            case 1: {
                status = f == null ? false : Fields.isConst(f);
                break;
            }
            default: {
                status = true;
            }
        }
        return status;
    }

    private static Field[] getFields(Class c, Class typeFilter, String fieldNameFilter, int operationType) {
        Field[] f = new Field[]{};
        switch (operationType) {
            case 0: 
            case 1: {
                f = Classes.getClassDescriptor(c).getFields();
                break;
            }
            case 2: {
                f = Classes.getClassDescriptor(c).getDeclaredFields();
                break;
            }
        }
        Vector<Field> v = new Vector<Field>(1, 1);
        for (int i = 0; i < f.length; ++i) {
            if (!(Fields.hasOpStatus(operationType, f[i]) && typeFilter != null && f[i].getType().getName().compareTo(typeFilter.getName()) == 0 && fieldNameFilter != null && Strings.contains(f[i].getName(), fieldNameFilter) || Fields.hasOpStatus(operationType, f[i]) && typeFilter != null && f[i].getType().getName().compareTo(typeFilter.getName()) == 0 && fieldNameFilter == null || Fields.hasOpStatus(operationType, f[i]) && typeFilter == null && fieldNameFilter != null && Strings.contains(f[i].getName(), fieldNameFilter)) && (!Fields.hasOpStatus(operationType, f[i]) || typeFilter != null || fieldNameFilter != null)) continue;
            v.addElement(f[i]);
        }
        return v.toArray(new Field[v.size()]);
    }
}

