/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common.reflect.common;

import java.lang.reflect.Field;
import se.ericsson.wcdma.rbs.boam.common.reflect.common.Arrays;
import se.ericsson.wcdma.rbs.boam.common.reflect.common.Classes;
import se.ericsson.wcdma.rbs.boam.common.reflect.common.Fields;

public class Logger {
    private static final String LOG_TITLE = "Parameters Values For Class ";
    private static final String SEP = ".";
    private static final String EQUAL = "=";
    private static final String OPEN_B = "[";
    private static final String CLOS_B = "]";
    private static final String SEMI_COL = ";";
    private static final int MAX_ARRAY_FIELDS_TRACED = 50;

    public static String asTrace(Object instance2Trace) {
        return Logger.asTrace(LOG_TITLE, instance2Trace, null);
    }

    public static String asTrace(String logTitle, Object instance2Trace) {
        return Logger.asTrace(logTitle, instance2Trace, null);
    }

    public static String asTrace(Object instance2Trace, Class filter) {
        return Logger.asTrace(LOG_TITLE, instance2Trace, filter);
    }

    public static String asTrace(String logTitle, Object instance2Trace, Class filter) {
        StringBuffer buf = new StringBuffer(logTitle);
        if (instance2Trace != null) {
            buf.append(instance2Trace.getClass().getName()).append("\n");
            Field[] varFields = Fields.getVarFields(instance2Trace.getClass(), filter, null);
            if (varFields != null) {
                buf = Logger.traceIn(instance2Trace, varFields, buf, null);
            }
        }
        return buf.toString();
    }

    public static String asTrace(Object[] instance2Trace) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < instance2Trace.length; ++i) {
            buf.append(Logger.asTrace(instance2Trace[i]));
        }
        return buf.toString();
    }

    private static StringBuffer traceIn(Object instance, Field[] fields, StringBuffer buf, String additionalInfo) {
        for (int i = 0; i < fields.length; ++i) {
            if (Logger.isLoggable(fields[i])) {
                buf.append(Logger.primAppend(instance, fields[i], additionalInfo));
                continue;
            }
            if (Fields.isPrimArray(fields[i])) {
                buf.append(Logger.primArrayAppend(instance, fields[i], additionalInfo));
                continue;
            }
            Object newInstance = Fields.getVarValue(instance, fields[i].getName());
            if (newInstance != null) {
                if (Fields.isArray(fields[i])) {
                    buf = Logger.recArrayAppend(newInstance, fields[i], additionalInfo, buf);
                    continue;
                }
                buf = Logger.recAppend(newInstance, fields[i], additionalInfo, buf);
                continue;
            }
            StringBuffer addInfo = new StringBuffer();
            addInfo.append(additionalInfo).append(SEP);
            if (Fields.isArray(fields[i])) {
                addInfo.append(Classes.getClassName(fields[i].getType()).substring(0, Classes.getClassName(fields[i].getType()).lastIndexOf(SEMI_COL)));
                buf.append(Logger.primAppend(instance, fields[i], addInfo.toString()));
                continue;
            }
            addInfo.append(Classes.getClassName(fields[i].getType()));
            buf.append(Logger.primAppend(instance, fields[i], addInfo.toString()));
        }
        return buf;
    }

    private static boolean isLoggable(Field f) {
        return f != null && (Fields.isPrim(f) || Fields.isString(f));
    }

    private static String primArrayAppend(Object instance, Field f, String additionalInfo) {
        Object array = Fields.getVarValue(instance, f.getName());
        StringBuffer buf = new StringBuffer();
        if (array != null) {
            int arrayLen = Arrays.getArrayLength(array);
            for (int i = 0; i < arrayLen && i < 50; ++i) {
                if (additionalInfo != null) {
                    buf.append(additionalInfo + SEP);
                }
                buf.append(Logger.asArrayLine(f.getName(), Arrays.get(array, i), i, true)).append("\n");
            }
            if (arrayLen > 50) {
                if (arrayLen > 51) {
                    buf.append("...\n");
                }
                if (additionalInfo != null) {
                    buf.append(additionalInfo + SEP);
                }
                buf.append(Logger.asArrayLine(f.getName(), Arrays.get(array, arrayLen - 1), arrayLen - 1, true)).append("\n");
            }
        } else {
            buf.append(Logger.primAppend(instance, f, additionalInfo));
        }
        return buf.toString();
    }

    private static String primAppend(Object instance, Field f, String additionalInfo) {
        Object valueForTest = Fields.getVarValue(instance, f.getName());
        StringBuffer buf = additionalInfo != null ? new StringBuffer(additionalInfo + SEP + f.getName()) : new StringBuffer(f.getName());
        buf.append(EQUAL);
        if (valueForTest != null) {
            buf.append(valueForTest.toString());
        } else {
            buf.append("null");
        }
        buf.append("\n");
        return buf.toString();
    }

    private static StringBuffer recAppend(Object instance, Field f, String additionalInfo, StringBuffer buf) {
        StringBuffer newAddInfo = new StringBuffer();
        if (additionalInfo != null) {
            newAddInfo.append(additionalInfo).append(SEP);
        }
        newAddInfo.append(Classes.getClassName(f.getType())).append(SEP).append(f.getName());
        return Logger.traceIn(instance, Fields.getVarFields(instance.getClass(), null, null), buf, newAddInfo.toString());
    }

    private static StringBuffer recArrayAppend(Object instance, Field f, String additionalInfo, StringBuffer buf) {
        int arrayLen = Arrays.getArrayLength(instance);
        for (int j = 0; j < arrayLen && j < 50; ++j) {
            Object aElem = Arrays.get(instance, j);
            if (aElem == null) continue;
            Logger.traceArrayElem(aElem, j, f, additionalInfo, buf);
        }
        if (arrayLen > 50) {
            if (arrayLen > 51) {
                buf.append("...\n");
            }
            Object aElem = Arrays.get(instance, arrayLen - 1);
            Logger.traceArrayElem(aElem, arrayLen - 1, f, additionalInfo, buf);
        }
        return buf;
    }

    private static void traceArrayElem(Object arrayElem, int arrayIndex, Field f, String additionalInfo, StringBuffer buf) {
        String className = Classes.getClassName(f.getType());
        className = className.indexOf(SEMI_COL) != -1 ? className.substring(0, Classes.getClassName(f.getType()).lastIndexOf(SEMI_COL)) : className;
        StringBuffer loggingPath = new StringBuffer();
        if (additionalInfo != null) {
            loggingPath.append(additionalInfo).append(SEP);
        }
        loggingPath.append(className).append(SEP).append(Logger.asArrayLine(f.getName(), null, arrayIndex, false));
        buf.append(Logger.traceIn(arrayElem, Fields.getVarFields(arrayElem.getClass(), null, null), new StringBuffer(), loggingPath.toString()).toString());
    }

    private static String asArrayLine(String fieldName, Object fieldValue, int index, boolean fullLine) {
        StringBuffer buf = new StringBuffer();
        buf.append(fieldName).append(OPEN_B).append(index).append(CLOS_B);
        if (fullLine) {
            buf.append(EQUAL);
            if (fieldValue != null) {
                buf.append(fieldValue.toString());
            } else {
                buf.append("null");
            }
        }
        return buf.toString();
    }
}

