/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.RbsErrorException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcHsdpaProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetPmRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetUptReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetUptRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcHsdpaRbsGetRecBitsRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcStartPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcStartUptReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcStopPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcStopUptReqS;
import se.ericsson.wcdma.rbs.boam.fpx.common.PmCounterTableManager;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.ScannedValue;
import se.ericsson.wcdma.rbs.boam.pms.iface.ProxyScanner;

public class ChcMeasurementProxy
extends ChcGenericProxy
implements ProxyScanner {
    private static final Class THIS_CLASS = ChcMeasurementProxy.class;
    private static final String SERVICE_NAME = "ChcMeasurementServiceName";
    private static ChcMeasurementProxy theOneAndOnly;

    private ChcMeasurementProxy() {
        super(SERVICE_NAME);
        MessageLog.traceEnter(THIS_CLASS, "ChcMeasurementProxy()");
    }

    public static synchronized ChcMeasurementProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new ChcMeasurementProxy();
        }
        return theOneAndOnly;
    }

    public void startUPT(int clientId, int measType, int froId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "startUPT()");
        ChcStartUptReqS reqSig = new ChcStartUptReqS(clientId, measType, froId);
        this.sendAndRec(reqSig);
    }

    public void stopUPT(int clientId, int measType, int froId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "stopUPT()");
        ChcStopUptReqS reqSig = new ChcStopUptReqS(clientId, measType, froId);
        this.sendAndRec(reqSig);
    }

    public int[] getUPT(int clientId, int froId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "getUPT()");
        ChcGetUptReqS reqSig = new ChcGetUptReqS(clientId, froId);
        ChcGetUptRspS rspSig = (ChcGetUptRspS)this.sendAndRec(reqSig);
        return rspSig.activeUptMeasurements;
    }

    public void pmsStart(String name, int granularityPeriod, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "pmsStart()");
        if (this.isIubDataStreamsPMCounter(name)) {
            ChcHsdpaProxy.instance().startPmIubMacdPduRbsReceivedBits(0, this.getMeasureType(name), granularityPeriod);
        } else {
            ChcStartPmReqS reqSig = new ChcStartPmReqS(0, this.getMeasureType(name), this.swapFroIdIfNeeded(froId, additionalInfo, name), granularityPeriod, bbPoolId);
            this.sendAndRec(reqSig);
        }
    }

    public void pmsStop(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "pmsStop()");
        if (this.isIubDataStreamsPMCounter(name)) {
            ChcHsdpaProxy.instance().stopPmIubMacdPduRbsReceivedBits(0, this.getMeasureType(name));
        } else {
            ChcStopPmReqS reqSig = new ChcStopPmReqS(0, this.getMeasureType(name), this.swapFroIdIfNeeded(froId, additionalInfo, name), bbPoolId);
            this.sendAndRec(reqSig);
        }
    }

    public ScannedValue[] getPmsAttribute(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPmsAttribute()<---");
        if (this.isIubDataStreamsPMCounter(name)) {
            ChcHsdpaRbsGetRecBitsRspS rspSig = ChcHsdpaProxy.instance().getPmIubMacdPduRbsReceivedBits(0);
            int[] receivedBits = rspSig.pmIubMacdPduRbsReceivedBits;
            return new ScannedValue[]{new ScannedValue(name, receivedBits)};
        }
        if (PmCounterTableManager.isInPmCounterTable(name)) {
            MessageLog.traceEnter(this.getClass(), "call the new signal ChcGetPmReqS for measType " + name);
            ChcGetPmReqS reqSig = new ChcGetPmReqS(0, Integer.parseInt(name), this.swapFroIdIfNeeded(froId, additionalInfo, name), bbPoolId);
            ChcGetPmRspS rspSig = (ChcGetPmRspS)this.sendAndRec(reqSig);
            return rspSig.counterList.toArray(new ScannedValue[rspSig.counterList.size()]);
        }
        String diagnosis = " Unknown PMS counter [group] name '" + name + "'";
        MessageLog.traceError(this.getClass(), diagnosis);
        ScannedValue[] empty = new ScannedValue[]{};
        return empty;
    }

    private int getMeasureType(String name) throws RbsErrorException {
        if (PmCounterTableManager.isInPmCounterTable(name)) {
            return Integer.parseInt(name);
        }
        if (this.isIubDataStreamsPMCounter(name)) {
            return 23;
        }
        String diagnosis = " Unknown PMS counter [group] name '" + name + "'";
        MessageLog.traceError(this.getClass(), diagnosis);
        throw new RbsErrorException(diagnosis);
    }

    private boolean isIubDataStreamsPMCounter(String counterName) {
        return counterName.equals("pmIubMacdPduRbsReceivedBits");
    }

    private int swapFroIdIfNeeded(int froId, int[] additionalInfo, String name) {
        if ((name.equals(String.valueOf(164)) || name.equals(String.valueOf(165)) || name.equals(String.valueOf(167)) || name.equals(String.valueOf(168))) && additionalInfo != null && additionalInfo.length > 0) {
            MessageLog.trace(3, this.getClass(), "Swapping froId for counter " + name + ", old froId: " + froId + " new froId: " + additionalInfo[0]);
            return additionalInfo[0];
        }
        return froId;
    }
}

