/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import enea.ose.system.UnlinkedSignal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.RbsErrorException;
import se.ericsson.wcdma.rbs.boam.common.generic.RbsGenericLicenseManager;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.reflect.common.Logger;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcErrorCodeMapper;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcHsdpaProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcCreateCellFeatListReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcCreateCellFeatListRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcCreateFeatureReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcCreateFeatureRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcDeleteCellFeatListReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcDeleteFeatureReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetFeatLicenseConstReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetFeatLicenseConstRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetLicenseFeatStateReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetLicenseFeatStateRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetRbsCapLicStateReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetRbsCapLicStateRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetRbsFeatLicStateReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetRbsFeatLicStateRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcLicenseCapacityInfoT;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcLicenseFeatureInfoT;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcNodeBGetDlCeUsageReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcNodeBGetDlCeUsageRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcNodeBGetUlCeUsageReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcNodeBGetUlCeUsageRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcNodeBPrimFaultCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcNodeBPrimFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcNodeBStartPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcNodeBStopPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcServiceNameT;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcSetFeatEul2BbpoolsReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcSetMbmsIubEffReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcSetNodebFeatStateReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcSetRbsFeatEul2msTtiReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcSetRbsFeatGrakeReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcSetRbsFeatureStateReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcSubscrRrhReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcGetNodeBParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcGetNodeBParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcNodeBEventIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcNodeBPrimFaultCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcNodeBPrimFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcSetNodeBDlPoolParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcSetNodeBUlPoolParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.BoamProxyUtils;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.ScannedValue;
import se.ericsson.wcdma.rbs.boam.pms.iface.ProxyScanner;

public class ChcNodeBFunctionProxy
extends ChcGenericProxy
implements ProxyScanner {
    private static ChcNodeBFunctionProxy uniqueInstance;
    private static final String SERVICE_NAME = "EqcRrhOmServiceName";
    private static final Class THIS_CLASS;
    private static final int CLIENT_ID = 0;
    private static final long LIC_FRACT_BB_POOL_INVALID_VALUE = -1L;
    private static final long LIC_FRACT_BB_POOL2_INVALID_VALUE = -1L;

    private ChcNodeBFunctionProxy() {
        super(SERVICE_NAME);
        MessageLog.traceEnter(this.getClass(), "ChcNodeBFunctionProxy() <---");
        this.boamSignalPort.addSignalObserver(this, EqcNodeBPrimFaultIndS.class);
        this.boamSignalPort.addSignalObserver(this, EqcNodeBPrimFaultCeaseIndS.class);
        this.boamSignalPort.addSignalObserver(this, EqcNodeBEventIndS.class);
        this.boamSignalPort.addSignalObserver(this, ChcNodeBPrimFaultIndS.class);
        this.boamSignalPort.addSignalObserver(this, ChcNodeBPrimFaultCeaseIndS.class);
    }

    public static synchronized ChcNodeBFunctionProxy instance() {
        if (uniqueInstance == null) {
            uniqueInstance = new ChcNodeBFunctionProxy();
        }
        return uniqueInstance;
    }

    public EqcGetNodeBParamRspS getNodeBFunctionParam(int transactionId, int clientId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNodeBFunctionParam()");
        EqcGetNodeBParamReqS reqSig = new EqcGetNodeBParamReqS(transactionId, clientId);
        return (EqcGetNodeBParamRspS)this.sendAndRec(reqSig);
    }

    public ChcLicenseFeatureInfoT getFeatureAndLicenseState(int clientId, int transactionId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, " getFeatureAndLicenseState()");
        ChcGetRbsFeatLicStateReqS reqSig = new ChcGetRbsFeatLicStateReqS(transactionId, clientId);
        ChcGetRbsFeatLicStateRspS rspSig = (ChcGetRbsFeatLicStateRspS)this.sendAndRec(reqSig);
        return rspSig.licenseFeatureInfo;
    }

    public ChcGetRbsFeatLicStateRspS getChcGetRbsFeatLicStateRspS(int clientId, int transactionId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, " getChcGetRbsFeatLicStateRspS()");
        ChcGetRbsFeatLicStateReqS reqSig = new ChcGetRbsFeatLicStateReqS(transactionId, clientId);
        ChcGetRbsFeatLicStateRspS rspSig = (ChcGetRbsFeatLicStateRspS)this.sendAndRec(reqSig);
        return rspSig;
    }

    public void setFeatureStateGrake(int clientId, int transactionId, int featureStateGrake) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "setFeatureStateGrake()");
        ChcSetRbsFeatGrakeReqS reqSig = new ChcSetRbsFeatGrakeReqS(transactionId, clientId, featureStateGrake);
        this.sendAndRec(reqSig);
    }

    public void setFeatureStateEul2msTTI(int clientId, int transactionId, int featureStateEul2msTti) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "setFeatureAndLicenseStateEul2msTTI()");
        ChcSetRbsFeatEul2msTtiReqS reqSig = new ChcSetRbsFeatEul2msTtiReqS(transactionId, clientId, featureStateEul2msTti);
        this.sendAndRec(reqSig);
    }

    public void setFeatureStateMbmsIubEfficiency(int clientId, int transactionId, int featureStateMbmsIubEfficiency) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "setFeatureAndLicenseStateEul2msTTI()");
        ChcSetMbmsIubEffReqS reqSig = new ChcSetMbmsIubEffReqS(transactionId, clientId, featureStateMbmsIubEfficiency);
        this.sendAndRec(reqSig);
    }

    public ChcLicenseCapacityInfoT getLicenseCapacityInfo(int clientId, int transactionId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, " getLicenseCapacityInfo()");
        ChcGetRbsCapLicStateReqS reqSig = new ChcGetRbsCapLicStateReqS(clientId);
        ChcGetRbsCapLicStateRspS rspSig = (ChcGetRbsCapLicStateRspS)this.sendAndRec(reqSig);
        return rspSig.licenseCapacityInfo;
    }

    public ChcGetRbsCapLicStateRspS getChcGetRbsCapLicStateRspS(int clientId, int transactionId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, " getLicenseCapacityInfo()");
        ChcGetRbsCapLicStateReqS reqSig = new ChcGetRbsCapLicStateReqS(clientId);
        ChcGetRbsCapLicStateRspS rspSig = (ChcGetRbsCapLicStateRspS)this.sendAndRec(reqSig);
        return rspSig;
    }

    public void setDlLicFractBbPool2(int clientId, int transactionId, int value) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "setDlLicFractBbPool2()");
        EqcSetNodeBDlPoolParamReqS reqSig = new EqcSetNodeBDlPoolParamReqS(transactionId, clientId, new long[]{-1L, -1L, -1L, -1L}, value);
        this.sendAndRec(reqSig);
    }

    public void setUlLicFractBbPool2(int clientId, int transactionId, int value) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "setUlLicFractBbPool2()");
        EqcSetNodeBUlPoolParamReqS reqSig = new EqcSetNodeBUlPoolParamReqS(transactionId, clientId, new long[]{-1L, -1L, -1L, -1L}, value);
        this.sendAndRec(reqSig);
    }

    public void setFeatureStateEulForLargeRbsConfig(int clientId, int transactionId, int featureStateEulForLargeRbsConfig) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "setFeatureStateEulForLargeRbsConfig");
        ChcSetFeatEul2BbpoolsReqS reqSig = new ChcSetFeatEul2BbpoolsReqS(transactionId, clientId, featureStateEulForLargeRbsConfig);
        this.sendAndRec(reqSig);
    }

    public void setFeatureState(int transactionId, int clientId, int featureId, int featureState) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "setFeatureState()");
        ChcSetNodebFeatStateReqS reqSig = new ChcSetNodebFeatStateReqS(transactionId, clientId, featureId, featureState);
        this.sendAndRec(reqSig);
    }

    public void subscribeToFroNotification() {
        MessageLog.traceEnter(this.getClass(), "subscribeToFroNotification");
        try {
            ChcSubscrRrhReqS reqSig = this.subscribeToChcAvcInd();
            this.sendAndRec(reqSig);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications serviceName:" + this.serviceName + ". Exception:" + (Object)((Object)e));
        }
    }

    private ChcSubscrRrhReqS subscribeToChcAvcInd() {
        ChcServiceNameT chcServiceName = new ChcServiceNameT(this.signalPort.getServiceName());
        ChcSubscrRrhReqS reqSig = new ChcSubscrRrhReqS(0L, chcServiceName, 0);
        return reqSig;
    }

    public ScannedValue[] getPmsAttribute(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPmsAttribute()<---");
        ArrayList<ScannedValue> result2 = new ArrayList<ScannedValue>();
        ScannedValue aValue = null;
        if (additionalInfo != null) {
            if (name.equals("pmCapacityNodeBDlCe")) {
                ChcNodeBGetDlCeUsageRspS rspSig = (ChcNodeBGetDlCeUsageRspS)this.sendAndRec(new ChcNodeBGetDlCeUsageReqS(0L));
                aValue = new ScannedValue(name, rspSig.ceUsage);
                result2.add(aValue);
            } else if (name.equals("capacityNodeBUlCe")) {
                ChcNodeBGetUlCeUsageRspS rspSig = (ChcNodeBGetUlCeUsageRspS)this.sendAndRec(new ChcNodeBGetUlCeUsageReqS(0L));
                aValue = new ScannedValue("pmCapacityNodeBUlCe", rspSig.ceUsage);
                result2.add(aValue);
                aValue = new ScannedValue("pmCapacityNodeBUlCeExt", rspSig.ceExtUsage);
                result2.add(aValue);
            } else {
                MessageLog.traceError(THIS_CLASS, "No such a PM counter: " + name);
                throw new RbsErrorException("getPmsAttribute():No such PM counter: " + name);
            }
        }
        return result2.toArray(new ScannedValue[result2.size()]);
    }

    public void pmsStart(String name, int granularityPeriod, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        if (name.equalsIgnoreCase("capacityNodeBUlCe")) {
            ChcHsdpaProxy.instance().startHschPm(0, froId, this.getMeasType(name), granularityPeriod, 0);
        } else {
            ChcNodeBStartPmReqS reqSig = new ChcNodeBStartPmReqS(0L, this.getMeasType(name), granularityPeriod);
            this.sendAndRec(reqSig);
        }
    }

    public void pmsStop(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        if (name.equalsIgnoreCase("capacityNodeBUlCe")) {
            ChcHsdpaProxy.instance().stopHschPm(0, froId, this.getMeasType(name), 0);
        } else {
            ChcNodeBStopPmReqS reqSig = new ChcNodeBStopPmReqS(0L, this.getMeasType(name));
            this.sendAndRec(reqSig);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getMeasType(String groupOrAttr) throws RbsErrorException {
        void var2_2;
        int measType;
        MessageLog.traceEnter(this.getClass(), "getMeasType() " + groupOrAttr);
        if (groupOrAttr.equals("pmCapacityNodeBDlCe")) {
            measType = 7;
        } else if (groupOrAttr.equals("capacityNodeBUlCe")) {
            measType = 912;
        } else {
            String diagnosis = " Unknown PMS counter [group] name `" + groupOrAttr + "'";
            MessageLog.traceError(this.getClass(), diagnosis);
            throw new RbsErrorException(diagnosis);
        }
        return (int)var2_2;
    }

    public void setDlLicFractBbPool(int clientId, int transactionId, int[] value) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "setDlLicFractBbPool()");
        long[] dlLicFractBbPool = new long[value.length];
        for (int i = 0; i < value.length; ++i) {
            dlLicFractBbPool[i] = value[i];
        }
        EqcSetNodeBDlPoolParamReqS reqSig = new EqcSetNodeBDlPoolParamReqS(transactionId, clientId, dlLicFractBbPool, -1L);
        this.sendAndRec(reqSig);
    }

    public void setUlLicFractBbPool(int clientId, int transactionId, int[] value) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "setUlLicFractBbPool()");
        long[] ulLicFractBbPool = new long[value.length];
        for (int i = 0; i < value.length; ++i) {
            ulLicFractBbPool[i] = value[i];
        }
        EqcSetNodeBUlPoolParamReqS reqSig = new EqcSetNodeBUlPoolParamReqS(transactionId, clientId, ulLicFractBbPool, -1L);
        this.sendAndRec(reqSig);
    }

    public ChcGetFeatLicenseConstRspS getFeatLicenseConst(int transactionId, int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        ChcGetFeatLicenseConstReqS reqSig = new ChcGetFeatLicenseConstReqS(transactionId, clientId);
        return (ChcGetFeatLicenseConstRspS)this.sendAndRec(reqSig);
    }

    public int createRbsFeatureRo(int transactionId, int clientId, int internalID, int cellFroId) throws FroRequestFailedException, FroNotAccessibleException {
        ChcCreateFeatureReqS reqSig = new ChcCreateFeatureReqS(transactionId, clientId, internalID, cellFroId);
        return ((ChcCreateFeatureRspS)this.sendAndRec((UnlinkedSignal)reqSig)).featureFroId;
    }

    public void deleteRbsFeatureRo(int transactionId, int clientId, int internalID, int cellFroId) throws FroRequestFailedException, FroNotAccessibleException {
        ChcDeleteFeatureReqS reqSig = new ChcDeleteFeatureReqS(transactionId, clientId, internalID, cellFroId);
        this.sendAndRec(reqSig);
    }

    public List createRbsCellFeatureListRo(int transactionId, int clientId, int cellFroId) throws FroRequestFailedException, FroNotAccessibleException {
        ChcCreateCellFeatListReqS reqSig = new ChcCreateCellFeatListReqS(transactionId, clientId, cellFroId);
        return ((ChcCreateCellFeatListRspS)this.sendAndRec((UnlinkedSignal)reqSig)).featureFroList;
    }

    public void deleteRbsCellFeatureListRo(int transactionId, int clientId, int cellFroId) throws FroRequestFailedException, FroNotAccessibleException {
        ChcDeleteCellFeatListReqS reqSig = new ChcDeleteCellFeatListReqS(transactionId, clientId, cellFroId);
        this.sendAndRec(reqSig);
    }

    public int getRbsGenericLicenseState(int transactionId, int clientId, int internalID, int cellFroId) throws FroRequestFailedException, FroNotAccessibleException {
        ChcGetLicenseFeatStateReqS reqSig = new ChcGetLicenseFeatStateReqS(transactionId, clientId, internalID, cellFroId);
        return ((ChcGetLicenseFeatStateRspS)this.sendAndRec((UnlinkedSignal)reqSig)).licenseState;
    }

    public int getRbsGenericFeatureState(int transactionId, int clientId, int internalID, int cellFroId) throws FroRequestFailedException, FroNotAccessibleException {
        ChcGetLicenseFeatStateReqS reqSig = new ChcGetLicenseFeatStateReqS(transactionId, clientId, internalID, cellFroId);
        return ((ChcGetLicenseFeatStateRspS)this.sendAndRec((UnlinkedSignal)reqSig)).featureState;
    }

    public void setRbsGenericFeatureState(int transactionId, int clientId, int internalID, int cellFroId, int featureState) throws FroRequestFailedException, FroNotAccessibleException {
        ChcSetRbsFeatureStateReqS reqSig = new ChcSetRbsFeatureStateReqS(transactionId, clientId, internalID, cellFroId, featureState);
        this.sendAndRec(reqSig);
    }

    public UnlinkedSignal sendAndRec(UnlinkedSignal reqSig) throws FroRequestFailedException, FroNotAccessibleException {
        String reqSigName = reqSig.getClass().getName();
        String RSP_SUFIX = "RspS";
        String REQ_SUFIX = "ReqS";
        this.verifyProxyAvaliable();
        MessageLog.traceParam(this.getClass(), Logger.asTrace(reqSig));
        int i = reqSigName.indexOf("ReqS");
        String rspSigName = reqSigName.substring(0, i) + "RspS";
        Class rspSigClass = ChcNodeBFunctionProxy.getSignalClass(rspSigName);
        UnlinkedSignal rspSig = (UnlinkedSignal)SignalHelper.sendAndReceive((OseProcess)this.processId, (Signal)reqSig, (Class)rspSigClass);
        BoamProxyUtils.verifyRoLayerResponse((InSignal)rspSig, this.getClass(), this.getServiceName());
        MessageLog.traceParam(this.getClass(), Logger.asTrace(rspSig));
        this.ensureResponse(reqSig, rspSig);
        return rspSig;
    }

    private static Class getSignalClass(String name) throws FroRequestFailedException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new FroRequestFailedException(name, 1, "OperationFailure", -1, "no class found for: " + name);
        }
    }

    private static int getIntValue(UnlinkedSignal rspSig, String key) {
        Object obj = BoamProxyUtils.getFieldValue(key, rspSig);
        return Integer.parseInt(obj.toString());
    }

    public void ensureResponse(UnlinkedSignal reqSig, UnlinkedSignal rspSig) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "ensureResponse");
        int result2 = ChcNodeBFunctionProxy.getIntValue(rspSig, "result");
        int errorCode = ChcNodeBFunctionProxy.getIntValue(rspSig, "errorCode");
        if (result2 == 0) {
            return;
        }
        if (reqSig instanceof ChcSetRbsFeatureStateReqS && errorCode == 53) {
            String exceptionCauseTag = "CHC_RRH_" + RbsGenericLicenseManager.getRbsLicenseFeature((int)ChcNodeBFunctionProxy.getIntValue((UnlinkedSignal)reqSig, (String)"internalID")).licenseName.toUpperCase(Locale.ENGLISH) + "_LICENSE_NOT_ENABLED";
            throw new FroRequestFailedException(rspSig.getClass().getName(), result2, exceptionCauseTag, errorCode, "Request to subsystem Chc is failed, for farther analyze, this information should be sent to Chc and BOAM.");
        }
        ChcErrorCodeMapper.throwFroRequestFailedException(this.getServiceName(), rspSig.getClass().getName(), result2, errorCode);
    }

    static {
        THIS_CLASS = ChcNodeBFunctionProxy.class;
    }
}

