/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies;

import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcAbPrimFaultCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcAbPrimFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSubscrAbFaultReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateAbReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateAbRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcDeleteAbReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcDeleteAbRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetAbParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetAbParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcSetAbParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcSetAbParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsServiceNameT;

public class EqcAntennaBranchProxy
extends EcGenericProxy {
    protected static final SignalPort portManager = PortManager.instance();
    private static EqcAntennaBranchProxy theOneAndOnly = null;
    private static final String SERVICE_NAME = "EqcBdhBoardDeviceHandler";
    public static final String CURRENT_CLASS = EqcAntennaBranchProxy.class.getName();

    private EqcAntennaBranchProxy() {
        super(SERVICE_NAME);
        this.boamSignalPort.addSignalObserver(this, EcAbPrimFaultIndS.class);
        this.boamSignalPort.addSignalObserver(this, EcAbPrimFaultCeaseIndS.class);
    }

    public static synchronized EqcAntennaBranchProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new EqcAntennaBranchProxy();
        }
        return theOneAndOnly;
    }

    public EqcCreateAbRspS createAb(int transactionId, int clientId, int sectorFroId, long branchName, int parentFroId, int lowCurrentSupervision) throws FroRequestFailedException, FroNotAccessibleException {
        EqcCreateAbReqS reqSig = new EqcCreateAbReqS(transactionId, clientId, sectorFroId, branchName, parentFroId, lowCurrentSupervision);
        return (EqcCreateAbRspS)this.sendAndRec(reqSig);
    }

    public EqcDeleteAbRspS deleteAb(int transactionId, int clientId, int abFroId) throws FroRequestFailedException, FroNotAccessibleException {
        EqcDeleteAbReqS reqSig = new EqcDeleteAbReqS(transactionId, clientId, abFroId);
        return (EqcDeleteAbRspS)this.sendAndRec(reqSig);
    }

    public EqcGetAbParamRspS getAbParam(int transactionId, int clientId, int abFroId) throws FroRequestFailedException, FroNotAccessibleException {
        EqcGetAbParamReqS reqSig = new EqcGetAbParamReqS(transactionId, clientId, abFroId);
        return (EqcGetAbParamRspS)this.sendAndRec(reqSig);
    }

    public EqcSetAbParamRspS setAbParam(int transactionId, int clientId, int abFroId, int lowCurrentSupervision) throws FroRequestFailedException, FroNotAccessibleException {
        EqcSetAbParamReqS reqSig = new EqcSetAbParamReqS(transactionId, clientId, abFroId, lowCurrentSupervision);
        return (EqcSetAbParamRspS)this.sendAndRec(reqSig);
    }

    private void subscAb(int clientId, int subscriptionRequest) throws FroRequestFailedException, FroNotAccessibleException {
        RbsServiceNameT rbsServiceName = new RbsServiceNameT();
        rbsServiceName.serviceName = this.signalPort.getServiceName();
        EcSubscrAbFaultReqS reqSig = new EcSubscrAbFaultReqS(clientId, rbsServiceName, subscriptionRequest);
        this.sendAndRec(reqSig);
    }

    public void subscribeToFroNotification() {
        MessageLog.traceEnter(this.getClass(), "subscribeToFroNotification");
        try {
            this.subscAb(0, 0);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }
}

