/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.RbsErrorException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.common.PmCounterTableManager;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcGetPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcGetPmRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcStartPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcStopPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.ScannedValue;
import se.ericsson.wcdma.rbs.boam.pms.iface.ProxyScanner;

public class EqcPmHelperProxy
extends EcGenericProxy
implements ProxyScanner {
    private static EqcPmHelperProxy theOneAndOnly = null;
    private static final String SERVICE_NAME = "EqcBdhBoardDeviceHandler";
    public static final String CURRENT_CLASS = EqcPmHelperProxy.class.getName();

    private EqcPmHelperProxy() {
        super(SERVICE_NAME);
    }

    public static synchronized EqcPmHelperProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new EqcPmHelperProxy();
        }
        return theOneAndOnly;
    }

    public void pmsStart(String name, int granularityPeriod, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "pmsStart()<---");
        EcStartPmReqS regSig = new EcStartPmReqS(0, this.getMeasureType(name), froId, granularityPeriod);
        this.sendAndRec(regSig);
    }

    public void pmsStop(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "pmsStop()<---");
        EcStopPmReqS regSig = new EcStopPmReqS(0, this.getMeasureType(name), froId);
        this.sendAndRec(regSig);
    }

    private int getMeasureType(String name) throws MoAccessException {
        if (PmCounterTableManager.isInPmCounterTable(name)) {
            return Integer.parseInt(name);
        }
        String diagnosis = " Unknown PMS counter [group] name '" + name + "'";
        MessageLog.traceError(this.getClass(), diagnosis);
        throw new RbsErrorException(diagnosis);
    }

    public ScannedValue[] getPmsAttribute(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPmsAttribute()<--- with pmName '" + name + "'");
        if (PmCounterTableManager.isInPmCounterTable(name)) {
            MessageLog.traceEnter(this.getClass(), "call the new signal EcGetPmReqS for measType " + name);
            EcGetPmReqS reqSig = new EcGetPmReqS(0, this.getMeasureType(name), froId);
            EcGetPmRspS rspSig = (EcGetPmRspS)this.sendAndRec(reqSig);
            return rspSig.counterList.toArray(new ScannedValue[rspSig.counterList.size()]);
        }
        String diagnosis = " Unknown PMS counter [group] name '" + name + "'";
        MessageLog.traceError(this.getClass(), diagnosis);
        return new ScannedValue[0];
    }
}

