/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import java.io.IOException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.AvcIndication;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsBasicHwPidT;

public class EcAuxPiuHwPidChangedIndS
extends AvcIndication {
    public static final int SIG_NO = 16814620;
    public int clientId;
    public long auxPiuFroId;
    public RbsBasicHwPidT basicHwPid = new RbsBasicHwPidT();

    public EcAuxPiuHwPidChangedIndS() {
        super(16814620);
    }

    public EcAuxPiuHwPidChangedIndS(int clientId, long auxPiuFroId, RbsBasicHwPidT basicHwPid) {
        super(16814620);
        this.clientId = clientId;
        this.auxPiuFroId = auxPiuFroId;
        this.basicHwPid = basicHwPid;
    }

    public void initReceive() {
        SignalInputStream in = this.getSignalInputStream();
        try {
            this.clientId = in.readS32();
            this.auxPiuFroId = in.readU32();
            this.basicHwPid.hwProductNumber = in.readString();
            long bytesToSkip = 25 - this.basicHwPid.hwProductNumber.length() - 1;
            if (in.skip(bytesToSkip) != bytesToSkip) {
                MessageLog.traceError(this.getClass(), (String)"skip() could not skip the requested amount of bytes");
            }
            this.basicHwPid.hwProductRevision = in.readString();
            bytesToSkip = 8 - this.basicHwPid.hwProductRevision.length() - 1;
            if (in.skip(bytesToSkip) != bytesToSkip) {
                MessageLog.traceError(this.getClass(), (String)"skip() could not skip the requested amount of bytes");
            }
            this.basicHwPid.hwProductName = in.readString();
            bytesToSkip = 65 - this.basicHwPid.hwProductName.length() - 1;
            if (in.skip(bytesToSkip) != bytesToSkip) {
                MessageLog.traceError(this.getClass(), (String)"skip() could not skip the requested amount of bytes");
            }
            this.basicHwPid.hwProductType = in.readString();
            bytesToSkip = 5 - this.basicHwPid.hwProductType.length() - 1;
            if (in.skip(bytesToSkip) != bytesToSkip) {
                MessageLog.traceError(this.getClass(), (String)"skip() could not skip the requested amount of bytes");
            }
            this.basicHwPid.hwProductionDate = in.readString();
            bytesToSkip = 9 - this.basicHwPid.hwProductionDate.length() - 1;
            if (in.skip(bytesToSkip) != bytesToSkip) {
                MessageLog.traceError(this.getClass(), (String)"skip() could not skip the requested amount of bytes");
            }
            this.basicHwPid.hwSerialNumber = in.readString();
            bytesToSkip = 14 - this.basicHwPid.hwSerialNumber.length() - 1;
            if (in.skip(bytesToSkip) != bytesToSkip) {
                MessageLog.traceError(this.getClass(), (String)"skip() could not skip the requested amount of bytes");
            }
        }
        catch (IOException e) {
            MessageLog.traceError(this.getClass(), (String)("initReceive failed in EcAuxPiuHwPidChangedIndS: " + e));
        }
    }

    public void initSend() {
        SignalOutputStream out = this.getSignalOutputStream();
        try {
            out.writeS32(this.clientId);
            out.writeU32(this.auxPiuFroId);
            out.writeString(this.basicHwPid.hwProductNumber);
            out.writeU8Array(new int[25 - this.basicHwPid.hwProductNumber.length() - 1]);
            out.writeString(this.basicHwPid.hwProductRevision);
            out.writeU8Array(new int[8 - this.basicHwPid.hwProductRevision.length() - 1]);
            out.writeString(this.basicHwPid.hwProductName);
            out.writeU8Array(new int[65 - this.basicHwPid.hwProductName.length() - 1]);
            out.writeString(this.basicHwPid.hwProductType);
            out.writeU8Array(new int[5 - this.basicHwPid.hwProductType.length() - 1]);
            out.writeString(this.basicHwPid.hwProductionDate);
            out.writeU8Array(new int[9 - this.basicHwPid.hwProductionDate.length() - 1]);
            out.writeString(this.basicHwPid.hwSerialNumber);
            out.writeU8Array(new int[14 - this.basicHwPid.hwSerialNumber.length() - 1]);
            out.flush();
        }
        catch (IOException e) {
            MessageLog.traceError(this.getClass(), (String)("initSend failed in EcAuxPiuHwPidChangedIndS: " + e));
        }
    }
}

