/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import java.io.IOException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.AvcIndication;
import se.ericsson.wcdma.rbs.boam.common.Strings;

public class EcAuxPiuSupportUnitIndS
extends AvcIndication {
    public static final int SIG_NO = 16814615;
    public int clientId;
    public int action;
    public long auxPiuFroId;
    public String supportUnitRef;

    public EcAuxPiuSupportUnitIndS() {
        super(16814615);
    }

    public EcAuxPiuSupportUnitIndS(int clientId, int action, long auxPiuFroId, String supportUnitRef) {
        super(16814615);
        this.clientId = clientId;
        this.action = action;
        this.auxPiuFroId = auxPiuFroId;
        this.supportUnitRef = supportUnitRef;
    }

    public void initReceive() {
        SignalInputStream in = this.getSignalInputStream();
        try {
            this.clientId = in.readS32();
            this.action = in.readS32();
            this.auxPiuFroId = in.readU32();
            this.supportUnitRef = Strings.toString(in.readS8Array(256));
        }
        catch (IOException e) {
            MessageLog.traceError(this.getClass(), (String)("initReceive failed in EcAuxPiuSupportUnitIndS: " + e));
        }
    }

    public void initSend() {
        SignalOutputStream out = this.getSignalOutputStream();
        try {
            out.writeS32(this.clientId);
            out.writeS32(this.action);
            out.writeU32(this.auxPiuFroId);
            out.writeS8Array(Strings.getBytes(this.supportUnitRef, 256));
        }
        catch (IOException e) {
            MessageLog.traceError(this.getClass(), (String)("initSend failed in EcAuxPiuSupportUnitIndS: " + e));
        }
    }
}

