/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSpecialIndT;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcUniqueHwIdT;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcLedInfoT;

public class EqcGetAuxPiuParamRspS
extends UnlinkedSignal {
    public static final int SIG_NO = 16814589;
    public long clientId;
    public int result;
    public int auxPiuType;
    public int opState;
    public int availStatus;
    public int admState;
    public int isSharedWithExternalMe;
    public EqcLedInfoT ledInfo;
    public int errorCode;
    public String hubPosition;
    public EcUniqueHwIdT uniqueHwId;
    public EcSpecialIndT[] specialInd = new EcSpecialIndT[1];

    public EqcGetAuxPiuParamRspS() {
        super(16814589);
        this.ledInfo = new EqcLedInfoT();
        this.hubPosition = "";
        this.uniqueHwId = new EcUniqueHwIdT();
        this.specialInd[0] = new EcSpecialIndT();
    }

    public EqcGetAuxPiuParamRspS(long clientId, int result2, int auxPiuType, int opState, int availStatus, int admState, int isSharedWithExternalMe, EqcLedInfoT ledInfo, int errorCode, String hubPosition, EcUniqueHwIdT uniqueHwId, EcSpecialIndT[] specialInd) {
        super(16814589);
        this.clientId = clientId;
        this.result = result2;
        this.auxPiuType = auxPiuType;
        this.opState = opState;
        this.availStatus = availStatus;
        this.admState = admState;
        this.isSharedWithExternalMe = isSharedWithExternalMe;
        this.ledInfo = ledInfo;
        this.errorCode = errorCode;
        this.hubPosition = hubPosition;
        this.uniqueHwId = uniqueHwId;
        this.specialInd = specialInd;
    }

    public void initReceive() {
        SignalInputStream in = this.getSignalInputStream();
        try {
            this.clientId = in.readU32();
            this.result = in.readS32();
            this.auxPiuType = in.readS32();
            this.opState = in.readS32();
            this.availStatus = in.readS32();
            this.admState = in.readS32();
            this.isSharedWithExternalMe = in.readS32();
            this.ledInfo.redLed = in.readS32();
            this.ledInfo.greenLed = in.readS32();
            this.ledInfo.yellowLed = in.readS32();
            this.ledInfo.blueLed = in.readS32();
            this.errorCode = in.readS32();
            this.hubPosition = Strings.toString(in.readS8Array(10));
            this.uniqueHwId.uniqueHwIdLength = in.readU8();
            this.uniqueHwId.uniqueHwId = Strings.toString(in.readS8Array(this.uniqueHwId.uniqueHwIdLength));
            long bytesToSkip = 19 - this.uniqueHwId.uniqueHwIdLength;
            if (in.skip(bytesToSkip) != bytesToSkip) {
                MessageLog.traceError(((Object)((Object)this)).getClass(), (String)"skip() could not skip the requested amount of bytes");
            }
            in.align(4);
            this.specialInd[0].name = Strings.toString(in.readS8Array(64));
            this.specialInd[0].status = in.readS32();
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("initReceive failed in EqcGetAuxPiuParamRspS: " + e));
        }
    }

    public void initSend() {
        SignalOutputStream out = this.getSignalOutputStream();
        try {
            out.writeU32(this.clientId);
            out.writeS32(this.result);
            out.writeS32(this.auxPiuType);
            out.writeS32(this.opState);
            out.writeS32(this.availStatus);
            out.writeS32(this.admState);
            out.writeS32(this.isSharedWithExternalMe);
            out.writeS32(this.ledInfo.redLed);
            out.writeS32(this.ledInfo.greenLed);
            out.writeS32(this.ledInfo.yellowLed);
            out.writeS32(this.ledInfo.blueLed);
            out.writeS32(this.errorCode);
            out.writeS8Array(Strings.getBytes(this.hubPosition, 10));
            out.writeU8(this.uniqueHwId.uniqueHwIdLength);
            out.writeS8Array(Strings.getBytes(this.uniqueHwId.uniqueHwId, 19));
            out.align(4);
            out.writeS8Array(Strings.getBytes(this.specialInd[0].name, 64));
            out.writeS32(this.specialInd[0].status);
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("initSend failed in EqcGetAuxPiuParamRspS: " + e));
        }
    }
}

