/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsUlsaCapabilityConfigT;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsUlsaSpectrumInfoT;

public class EqcGetUlsaCapabilityRspS
extends UnlinkedSignal {
    public static final int SIG_NO = 16816685;
    public long clientId;
    public int result;
    public int errorCode;
    public long numOfCapabilities;
    public RbsUlsaCapabilityConfigT capabilities = new RbsUlsaCapabilityConfigT();

    public EqcGetUlsaCapabilityRspS() {
        super(16816685);
    }

    public EqcGetUlsaCapabilityRspS(long clientId, int result2, int errorCode, long numOfCapabilities, RbsUlsaCapabilityConfigT capabilities) {
        super(16816685);
        this.clientId = clientId;
        this.result = result2;
        this.errorCode = errorCode;
        this.numOfCapabilities = numOfCapabilities;
        this.capabilities = capabilities;
    }

    public void initReceive() {
        SignalInputStream in = this.getSignalInputStream();
        try {
            this.clientId = in.readU32();
            this.result = in.readS32();
            this.errorCode = in.readS32();
            this.numOfCapabilities = in.readU32();
            for (int portIndex = 0; portIndex < 8; ++portIndex) {
                in.align(4);
                this.capabilities.capabilityInfo[portIndex].carrierRfPort = in.readU32();
                this.capabilities.capabilityInfo[portIndex].numSpectrumTypes = in.readU32();
                this.capabilities.capabilityInfo[portIndex].numTriggerTypes = in.readU32();
                this.capabilities.capabilityInfo[portIndex].trigger1DataDefined = in.readU16();
                this.capabilities.capabilityInfo[portIndex].minPower = in.readS32();
                this.capabilities.capabilityInfo[portIndex].maxPower = in.readS32();
                int spectrumNum = (int)this.capabilities.capabilityInfo[portIndex].numSpectrumTypes > 0 ? (int)this.capabilities.capabilityInfo[portIndex].numSpectrumTypes : 1;
                this.capabilities.capabilityInfo[portIndex].spectrumInfo = new RbsUlsaSpectrumInfoT[spectrumNum];
                for (int i = 0; i < spectrumNum; ++i) {
                    this.capabilities.capabilityInfo[portIndex].spectrumInfo[i] = new RbsUlsaSpectrumInfoT();
                    this.capabilities.capabilityInfo[portIndex].spectrumInfo[i].minFrequency = in.readS32();
                    this.capabilities.capabilityInfo[portIndex].spectrumInfo[i].maxFrequency = in.readS32();
                    this.capabilities.capabilityInfo[portIndex].spectrumInfo[i].flatGainBW = in.readU32();
                    this.capabilities.capabilityInfo[portIndex].spectrumInfo[i].samplingRate = in.readU32();
                    this.capabilities.capabilityInfo[portIndex].spectrumInfo[i].maxNumSamplings = in.readU32();
                }
            }
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("initReceive failed in EqcGetUlsaCapabilityRspS: " + e));
        }
    }

    public void initSend() {
        SignalOutputStream out = this.getSignalOutputStream();
        try {
            out.writeU32(this.clientId);
            out.writeS32(this.result);
            out.writeS32(this.errorCode);
            out.writeU32(this.numOfCapabilities);
            for (int portIndex = 0; portIndex < 8; ++portIndex) {
                out.align(4);
                out.writeU32(this.capabilities.capabilityInfo[portIndex].carrierRfPort);
                out.writeU32(this.capabilities.capabilityInfo[portIndex].numSpectrumTypes);
                out.writeU32(this.capabilities.capabilityInfo[portIndex].numTriggerTypes);
                out.writeU16(this.capabilities.capabilityInfo[portIndex].trigger1DataDefined);
                out.writeS32(this.capabilities.capabilityInfo[portIndex].minPower);
                out.writeS32(this.capabilities.capabilityInfo[portIndex].maxPower);
                int spectrumNum = (int)this.capabilities.capabilityInfo[portIndex].numSpectrumTypes > 0 ? (int)this.capabilities.capabilityInfo[portIndex].numSpectrumTypes : 1;
                for (int i = 0; i < spectrumNum; ++i) {
                    out.writeS32(this.capabilities.capabilityInfo[portIndex].spectrumInfo[i].minFrequency);
                    out.writeS32(this.capabilities.capabilityInfo[portIndex].spectrumInfo[i].maxFrequency);
                    out.writeU32(this.capabilities.capabilityInfo[portIndex].spectrumInfo[i].flatGainBW);
                    out.writeU32(this.capabilities.capabilityInfo[portIndex].spectrumInfo[i].samplingRate);
                    out.writeU32(this.capabilities.capabilityInfo[portIndex].spectrumInfo[i].maxNumSamplings);
                }
            }
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("initSend failed in EqcGetUlsaCapabilityRspS: " + e));
        }
    }
}

