/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import java.io.IOException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.fpx.common.PlugAndPlayIndImpl;

public class EqcStartSamplingIndS
extends PlugAndPlayIndImpl {
    public static final int SIG_NO = 16816688;
    public long clientId;
    public long fileSize;
    public String samplingFilePath;
    public String samplingFileName;
    public long errorCode;

    public EqcStartSamplingIndS() {
        super(16816688);
    }

    public EqcStartSamplingIndS(long clientId, long fileSize, String samplingFilePath, String samplingFileName, long errorCode, long ulsaFroId) {
        super(16816688);
        this.clientId = clientId;
        this.fileSize = fileSize;
        this.samplingFilePath = samplingFilePath;
        this.samplingFileName = samplingFileName;
        this.errorCode = errorCode;
        this.froId = ulsaFroId;
    }

    public void initReceive() {
        SignalInputStream in = this.getSignalInputStream();
        try {
            this.clientId = in.readU32();
            this.fileSize = in.readU32();
            this.samplingFilePath = Strings.toString(in.readS8Array(200));
            this.samplingFileName = Strings.toString(in.readS8Array(36));
            this.errorCode = in.readU32();
            this.froId = in.readU32();
        }
        catch (IOException e) {
            MessageLog.traceError(this.getClass(), (String)("initReceive failed in EqcStartSamplingIndS: " + e));
        }
    }

    public void initSend() {
        SignalOutputStream out = this.getSignalOutputStream();
        try {
            out.writeU32(this.clientId);
            out.writeU32(this.fileSize);
            out.writeS8Array(Strings.getBytes(this.samplingFilePath, 200));
            out.writeS8Array(Strings.getBytes(this.samplingFileName, 36));
            out.writeU32(this.errorCode);
            out.writeU32(this.froId);
        }
        catch (IOException e) {
            MessageLog.traceError(this.getClass(), (String)("initSend failed in EqcStartSamplingIndS: " + e));
        }
    }
}

