/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsServiceNameT;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsTestIdT;

public class EqcTestGroupReqS
extends UnlinkedSignal {
    public static final int SIG_NO = 16814994;
    public long clientId;
    public long groupFroId;
    public RbsServiceNameT receiverServiceName;
    public RbsTestIdT testId;

    public EqcTestGroupReqS() {
        super(16814994);
        this.receiverServiceName = new RbsServiceNameT();
        this.testId = new RbsTestIdT();
    }

    public EqcTestGroupReqS(long clientId, long groupFroId, RbsServiceNameT receiverServiceName, RbsTestIdT testId) {
        super(16814994);
        this.clientId = clientId;
        this.groupFroId = groupFroId;
        this.receiverServiceName = receiverServiceName;
        this.testId = testId;
    }

    public int getSignalNumber() {
        return 16814994;
    }

    public void initReceive() {
        SignalInputStream in = this.getSignalInputStream();
        try {
            this.clientId = in.readU32();
            this.groupFroId = in.readU32();
            this.receiverServiceName.serviceName = Strings.toString(in.readS8Array(64));
            this.testId.name = Strings.toString(in.readS8Array(32));
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), "initReceive failed in EcSubscrHwPidInfoReqS: " + e);
        }
    }

    public void initSend() {
        SignalOutputStream out = this.getSignalOutputStream();
        try {
            out.writeU32(this.clientId);
            out.writeU32(this.groupFroId);
            out.writeString(this.receiverServiceName.serviceName);
            out.writeU8Array(new int[64 - this.receiverServiceName.serviceName.length() - 1]);
            out.writeS8Array(Strings.getBytes(this.testId.name, 32));
            out.flush();
        }
        catch (IOException ioe) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), "initSend failed in EqcTestGroupReqS: " + ioe);
        }
    }
}

