/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies;

import java.util.ArrayList;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.RbsErrorException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcAddCommunicCpToNbapReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcAddCommunicCpToNbapRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcAddNodebCpToNbapReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcAddNodebCpToNbapRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcDelCommunicCpFromnbapReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcDelCommunicCpFromnbapRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcDelNodebCpFromNbapReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcDelNodebCpFromNbapRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcGetNbapL3SupParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcGetNbapL3SupParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcNodebStartPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcNodebStartPmRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcNodebStopPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcNodebStopPmRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.NcNodebGetPmNoDiscReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.NcNodebGetPmNoDiscRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.NcNodebGetPmTimeCongReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.NcNodebGetPmTimeCongRspS;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.ScannedValue;
import se.ericsson.wcdma.rbs.boam.pms.iface.ProxyScanner;

public class NcNbapProxy
extends NcGenericProxy
implements ProxyScanner {
    private static NcNbapProxy theOneAndOnly = null;
    private static final String SERVICE_NAME = "bcNphNbapHandler";

    private NcNbapProxy() {
        super(SERVICE_NAME);
        MessageLog.traceEnter(this.getClass(), "Constructor");
    }

    public static synchronized NcNbapProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new NcNbapProxy();
        }
        return theOneAndOnly;
    }

    public BcAddNodebCpToNbapRspS addNodebCpToNbap(int transactionId, int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "addNodebCpToNbap()");
        BcAddNodebCpToNbapReqS reqSig = new BcAddNodebCpToNbapReqS(transactionId, clientId);
        return (BcAddNodebCpToNbapRspS)this.sendAndRec(reqSig);
    }

    public BcAddCommunicCpToNbapRspS addCommunicCpToNbap(int transactionId, int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "addCommunicCpToNbap()");
        BcAddCommunicCpToNbapReqS reqSig = new BcAddCommunicCpToNbapReqS(transactionId, clientId);
        return (BcAddCommunicCpToNbapRspS)this.sendAndRec(reqSig);
    }

    public BcDelNodebCpFromNbapRspS delNodebCpFromNbap(int transactionId, int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "delNodebCpFromNbap()");
        BcDelNodebCpFromNbapReqS reqSig = new BcDelNodebCpFromNbapReqS(transactionId, clientId);
        return (BcDelNodebCpFromNbapRspS)this.sendAndRec(reqSig);
    }

    public BcDelCommunicCpFromnbapRspS delCommunicCpFromNbap(int transactionId, int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "delCommunicCpFromNbap()");
        BcDelCommunicCpFromnbapReqS reqSig = new BcDelCommunicCpFromnbapReqS(transactionId, clientId);
        return (BcDelCommunicCpFromnbapRspS)this.sendAndRec(reqSig);
    }

    public BcGetNbapL3SupParamRspS getNbapL3SupParam(int clientId, int transactionId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "getNbapL3SupParam()");
        BcGetNbapL3SupParamReqS reqSig = new BcGetNbapL3SupParamReqS(clientId, transactionId);
        return (BcGetNbapL3SupParamRspS)this.sendAndRec(reqSig);
    }

    private NcNodebGetPmTimeCongRspS getPmTimeCong(int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "getPmTimeCong()");
        NcNodebGetPmTimeCongReqS reqSig = new NcNodebGetPmTimeCongReqS(clientId);
        return (NcNodebGetPmTimeCongRspS)this.sendAndRec(reqSig);
    }

    private NcNodebGetPmNoDiscRspS getPmNoDisc(int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "getPmNoDisc()");
        NcNodebGetPmNoDiscReqS reqSig = new NcNodebGetPmNoDiscReqS(clientId);
        return (NcNodebGetPmNoDiscRspS)this.sendAndRec(reqSig);
    }

    public BcNodebStartPmRspS bcNodebStartPm(int clientId, int measType, int froId, int granularityPeriod) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "bcNodebStartPm()");
        BcNodebStartPmReqS reqSig = new BcNodebStartPmReqS(clientId, measType, granularityPeriod, this.signalPort.getServiceName());
        return (BcNodebStartPmRspS)this.sendAndRec(reqSig);
    }

    public BcNodebStopPmRspS bcNodebStopPm(int clientId, int measType, int froId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "bcNodebStopPm()");
        BcNodebStopPmReqS reqSig = new BcNodebStopPmReqS(clientId, measType);
        return (BcNodebStopPmRspS)this.sendAndRec(reqSig);
    }

    public void pmsStart(String name, int granularityPeriod, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "pmsStart()<---");
        if (name.equalsIgnoreCase("pmTotalTimeIubLinkCongestedUl") || name.equalsIgnoreCase("pmNoOfDiscardedMsg")) {
            this.bcNodebStartPm(0, this.getMeasureType(name), froId, granularityPeriod);
        }
    }

    public void pmsStop(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "pmsStop()<---");
        if (name.equalsIgnoreCase("pmTotalTimeIubLinkCongestedUl") || name.equalsIgnoreCase("pmNoOfDiscardedMsg")) {
            this.bcNodebStopPm(0, this.getMeasureType(name), froId);
        }
    }

    private int getMeasureType(String name) throws MoAccessException {
        int measType = -1;
        if (name.equals("pmTotalTimeIubLinkCongestedUl")) {
            measType = 1;
        } else if (name.equals("pmNoOfDiscardedMsg")) {
            measType = 0;
        } else {
            MessageLog.traceError(this.getClass(), "No such a PM counter : " + name);
            throw new RbsErrorException("getMeasType():No such a PM counter " + name);
        }
        return measType;
    }

    public ScannedValue[] getPmsAttribute(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPmsAttribute()<---");
        ArrayList<ScannedValue> result2 = new ArrayList<ScannedValue>();
        ScannedValue aValue = null;
        if (additionalInfo != null) {
            if (name.equals("pmTotalTimeIubLinkCongestedUl")) {
                NcNodebGetPmTimeCongRspS rspSig = this.getPmTimeCong(0);
                int[] pmTimeCong = new int[]{rspSig.totalTimeIubLinkCongUl};
                aValue = new ScannedValue(name, pmTimeCong);
                result2.add(aValue);
            } else if (name.equals("pmNoOfDiscardedMsg")) {
                NcNodebGetPmNoDiscRspS rspSig = this.getPmNoDisc(0);
                int[] pmNoDisc = new int[]{rspSig.noOfDiscardedMsg};
                aValue = new ScannedValue(name, pmNoDisc);
                result2.add(aValue);
            } else {
                MessageLog.traceError(this.getClass(), "No such a PM counter: " + name);
                throw new RbsErrorException("getPmsAttribute():No such PM counter: " + name);
            }
        }
        return result2.toArray(new ScannedValue[result2.size()]);
    }
}

