/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies;

import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcGetRestartClockStatusReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcGetRestartClockStatusRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcRestartEventIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcSetRestartClockStatusReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcSetRestartClockStatusRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcSubscRestartEventReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcSubscRestartEventRspS;

public class NcRestartServiceProxy
extends NcGenericProxy {
    private static NcRestartServiceProxy theOneAndOnly = null;
    private static final String SERVICE_NAME = "bcNmStartController";

    private NcRestartServiceProxy() {
        super(SERVICE_NAME);
        MessageLog.traceEnter(this.getClass(), "Constructor");
        this.boamSignalPort.addSignalObserver(this, BcRestartEventIndS.class);
    }

    public static synchronized NcRestartServiceProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new NcRestartServiceProxy();
        }
        return theOneAndOnly;
    }

    public BcSubscRestartEventRspS subToRestartEvent(int clientId, int subscribeOperation) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "subToRestartEvent()");
        BcSubscRestartEventReqS reqSig = new BcSubscRestartEventReqS(clientId, subscribeOperation, this.signalPort.getServiceName());
        return (BcSubscRestartEventRspS)this.sendAndRec(reqSig);
    }

    public BcGetRestartClockStatusRspS getRestartClockStatus(int transactionId, int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "getRestartClockStatus()");
        BcGetRestartClockStatusReqS reqSig = new BcGetRestartClockStatusReqS(transactionId, clientId);
        return (BcGetRestartClockStatusRspS)this.sendAndRec(reqSig);
    }

    public BcSetRestartClockStatusRspS setRestartClockStatus(int transactionId, int clientId, int activationClockStatus) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "setrestartClockStatus()");
        BcSetRestartClockStatusReqS reqSig = new BcSetRestartClockStatusReqS(transactionId, clientId, activationClockStatus);
        return (BcSetRestartClockStatusRspS)this.sendAndRec(reqSig);
    }

    public void subscribeToFroNotification() {
        MessageLog.traceEnter(this.getClass(), "subscribeToFroNotification");
        int CLIENT_ID = 0;
        try {
            this.subToRestartEvent(CLIENT_ID, 0);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }
}

