/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.proxies;

import enea.ose.system.InSignal;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.AvcIndication;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroObjectTypeDefs;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.FroProxy;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;

public abstract class AvcIndProxy
extends FroProxy {
    protected AvcIndProxy(String serviceName) {
        super(serviceName);
        MessageLog.traceEnter(this.getClass(), "AvcIndProxy(), serviceName:" + serviceName);
    }

    public void subscribeToFroNotification() {
        MessageLog.traceEnter(this.getClass(), "subscribeToFroNotification() serviceName:" + this.serviceName);
    }

    public void signalReceived(InSignal inSig) {
        MessageLog.traceEnter(this.getClass(), "signalReceived");
        try {
            if (inSig instanceof AvcIndication) {
                this.handleAVCind((AvcIndication)inSig);
            } else {
                this.superSignalReceived(inSig);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            MessageLog.traceError(this.getClass(), "SW error, exception caught in AvcIndProxy.java->signalReceived(). Exception: ", e);
        }
    }

    protected void superSignalReceived(InSignal inSig) {
        super.signalReceived(inSig);
    }

    protected void handleAVCind(AvcIndication avcSig) throws MoAccessException {
        String moType = this.getMoType(avcSig);
        BoamManagedObject mo = this.getMo(moType, avcSig);
        String attributeName = this.getAttributeName(mo, avcSig);
        if (mo != null && attributeName != null) {
            mo.sendAVC(attributeName, avcSig.getAvcValue());
        }
    }

    private String getMoType(AvcIndication avcSig) {
        String moType = this.froTypeToMoType(avcSig.getFroType());
        if (moType == null || moType.equals("")) {
            MessageLog.traceError(this.getClass(), "Can't send AVC. Could not find Fro type '" + avcSig.getFroType() + "' with froId '" + avcSig.getFroId() + ", rec signal: " + avcSig.getClass().getName());
            return null;
        }
        return moType;
    }

    protected BoamManagedObject getMo(String moType, AvcIndication avcSig) {
        ManagedObject mo = null;
        if (moType != null && moType.length() > 0) {
            try {
                mo = this.getMoFromFroId(moType, (int)avcSig.getFroId());
                if (!(mo instanceof BoamManagedObject)) {
                    MessageLog.traceError(this.getClass(), "MO [" + mo.getFullDistinguishedName() + "] (froId = " + avcSig.getFroId() + ") not descendant of BoamManagedObject. Impossible to send AVC notification.");
                }
            }
            catch (MoAccessException e) {
                MessageLog.traceError(this.getClass(), "Could not find MO of type: " + moType + " with froId: " + avcSig.getFroId());
            }
        }
        return (BoamManagedObject)mo;
    }

    private String getAttributeName(BoamManagedObject mo, AvcIndication avcSig) throws MoAccessException {
        String attributeName = avcSig.getAttributeName();
        if (attributeName == null) {
            MessageLog.traceError(this.getClass(), "MO [" + (mo != null ? mo.getFullDistinguishedName() : "?") + "] (froId = " + avcSig.getFroId() + ") Failed to map attribute. Impossible to send AVC notification.");
        }
        return attributeName;
    }

    protected ManagedObject getMoFromFroId(String moType, int froId) throws MoAccessException {
        return BoamHelper.getMoForFroId(moType, froId);
    }

    protected String froTypeToMoType(int froType) {
        return FroObjectTypeDefs.getMoTypeName(froType);
    }

    public String[] getSpecificErrorCodePrefixes() {
        return new String[0];
    }

    public void ensureResponse(String aRequest, int result2, int errorCode) throws FroRequestFailedException, FroNotAccessibleException {
    }
}

