/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.proxies;

import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;

public class ScannedValue {
    private final String counterName;
    private final int[] counterValues;

    public ScannedValue(String counterName, int[] counterValues) throws InternalErrorException {
        if (counterName == null) {
            String message = "cannot create ScannedValue, name is null";
            MessageLog.traceError(this.getClass(), "cannot create ScannedValue, name is null");
            throw new InternalErrorException("cannot create ScannedValue, name is null");
        }
        if (counterValues == null) {
            String message = "cannot create ScannedValue for counter named '" + counterName + "': value is null";
            MessageLog.traceError(this.getClass(), message);
            throw new InternalErrorException(message);
        }
        if (counterValues.length == 0) {
            String message = "cannot create ScannedValue for counter named '" + counterName + "': zero-length value";
            MessageLog.traceError(this.getClass(), message);
            throw new InternalErrorException(message);
        }
        this.counterName = counterName;
        this.counterValues = counterValues;
    }

    public String getName() {
        return this.counterName;
    }

    public int[] getValue() {
        return this.counterValues;
    }
}

