/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.alarm;

import enea.ose.system.UnlinkedSignal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.Alarm;
import se.ericsson.cello.faultmanagement.AlarmDuplicatedException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.wcdma.rbs.boam.common.AlarmObserver;
import se.ericsson.wcdma.rbs.boam.common.CeasedIndSignalInfo;
import se.ericsson.wcdma.rbs.boam.common.DelayedFroObserver;
import se.ericsson.wcdma.rbs.boam.common.FaultCeasedInfo;
import se.ericsson.wcdma.rbs.boam.common.FaultIndSignalInfo;
import se.ericsson.wcdma.rbs.boam.common.FroObjectTypeDefs;
import se.ericsson.wcdma.rbs.boam.common.generic.RbsGenericLicenseManager;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcNodeBPrimFaultCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcNodeBPrimFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcExtAlarmCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcExtAlarmIndS;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.FroProxy;
import se.ericsson.wcdma.rbs.boam.mao.alarm.AdditionalInfoExcep;
import se.ericsson.wcdma.rbs.boam.mao.alarm.AdditionalTextExcep;
import se.ericsson.wcdma.rbs.boam.mao.alarm.AlarmInfo;
import se.ericsson.wcdma.rbs.boam.mao.alarm.AlarmInfoList;
import se.ericsson.wcdma.rbs.boam.mao.alarm.ExternalAlarmsMapTable;
import se.ericsson.wcdma.rbs.boam.mao.alarm.FaultIndExcep;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarmsException;
import se.ericsson.wcdma.rbs.boam.mao.alarm.SwErrorLogHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AlmDeviceMo;

public class MoAlarms
implements AlarmObserver,
DelayedFroObserver,
Resource {
    private static final Class SELF = MoAlarms.class;
    public static final String CELLO_INPUT = "";
    public static final String ADD_INFO_NAME = "DN";
    public static final String W_SP = " ";
    private static final String MAP_FAULT_IND = "FaultType : ";
    private final ManagedObject myMo;
    private final FroProxy[] myFroProxies;
    private final int froId;
    private final int froObjectType;
    private final Vector alarmTable = new Vector();
    private final Object alarmTableLock = new Object();
    private volatile int alarmStatusAttr = 0;
    private final Object alarmStatusAttrLock = new Object();
    private final HashMap faultTypeMappingTable = new HashMap();
    private static final String SW_ERROR_ALARM_LOG_PATH = "/c/logfiles/SwErrorAlarmLog/";
    private static final String EVENT_ID = "EventID";
    private static final String MO = "MO";
    private static final String FAULT_MESSAGE = "faultMessage";
    private static final String FAULT_ID = "faultID";
    private static final String FAULT_DESCRIPTION = "faultDescription";
    private static final String COLON = ":";
    private static final String SEMICOLON = ";";
    private static final String START_FLAG = "<";
    private static final String END_FLAG = ">";

    public MoAlarms(ManagedObject mo, FroProxy proxy, int froObjectType, int froId, Coordinator context) throws MoAccessException {
        this(mo, new FroProxy[]{proxy}, froObjectType, froId, context);
    }

    public MoAlarms(ManagedObject mo, FroProxy[] proxies, int froObjectType, int froId, Coordinator context) throws MoAccessException {
        if (mo == null || proxies == null) {
            throw new SoftwareErrorException();
        }
        this.myMo = mo;
        this.froObjectType = froObjectType;
        this.froId = froId;
        this.myFroProxies = proxies;
        for (int i = 0; i < this.myFroProxies.length; ++i) {
            this.myFroProxies[i].registerForNotifications(context, this, froId);
        }
        this.faultTypeMappingTable.put(new Integer(49578), new Integer(49182));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAlarmStatus() {
        Object object = this.alarmStatusAttrLock;
        synchronized (object) {
            return this.alarmStatusAttr;
        }
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "delete(), MO: " + this.myMo.getLocalDistinguishedName());
        for (int i = 0; i < this.myFroProxies.length; ++i) {
            this.myFroProxies[i].deregisterForNotifications(context, (long)this.froId);
        }
        try {
            context.registerResource((Resource)this);
        }
        catch (InactiveTransactionException e) {
            MessageLog.traceError(SELF, "Unable to register to Transaction Resource!! due to Excep:" + (Object)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Object object = this.alarmTableLock;
        synchronized (object) {
            MessageLog.traceEnter(SELF, "commit(), delete MO, cleaning the alarms.");
            for (int i = 0; i < this.alarmTable.size(); ++i) {
                ((AlarmRecord)this.alarmTable.elementAt(i)).getAlarm().clear();
            }
            this.alarmTable.removeAllElements();
        }
    }

    public boolean prepare() {
        return true;
    }

    public void rollback() {
        MessageLog.traceEnter(SELF, "rollback(), delete MO, Nothing to do!!");
    }

    public FroProxy[] getFroProxies() {
        return this.myFroProxies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceRemoved(String proxyName) {
        Object object = this.alarmTableLock;
        synchronized (object) {
            MessageLog.traceEnter(SELF, "serviceRemoved(), proxyName: " + proxyName);
            Enumeration iter = this.alarmTable.elements();
            while (iter.hasMoreElements()) {
                AlarmRecord ar = (AlarmRecord)iter.nextElement();
                if (ar.containsProxyClassName(proxyName)) {
                    try {
                        ar.removeProxyClass(proxyName);
                    }
                    catch (MoAlarmsException e) {
                        MessageLog.traceError(SELF, proxyName + " couldn't be removed from fault submitters list due to exception!! ", e);
                    }
                }
                if (!ar.isFaultSubmitterListEmpty()) continue;
                ar.receivedAfterProxyDown = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeoutAfterServiceAvailable(String proxyName) {
        MessageLog.traceEnter(SELF, "timeoutAfterServiceAvailable()");
        ArrayList<AlarmRecord> removeList = new ArrayList<AlarmRecord>();
        Object object = this.alarmTableLock;
        synchronized (object) {
            AlarmRecord ar;
            Enumeration enumer = this.alarmTable.elements();
            while (enumer.hasMoreElements()) {
                ar = (AlarmRecord)enumer.nextElement();
                if (ar.receivedAfterProxyDown) continue;
                removeList.add(ar);
            }
            Iterator iter = removeList.iterator();
            while (iter.hasNext()) {
                ar = (AlarmRecord)iter.next();
                MessageLog.trace(5, SELF, "Alarm with specificProblem= " + ar.getSpecificProblem() + " is not received after timeout and removed from alarmTable");
                this.alarmTable.removeElement(ar);
            }
        }
        Iterator iter = removeList.iterator();
        while (iter.hasNext()) {
            AlarmRecord ar = (AlarmRecord)iter.next();
            ar.getAlarm().clear();
        }
        if (removeList.size() > 0) {
            this.recalculateAlarmStatus();
        }
    }

    public void setAlarmSeverity(String severity) {
        try {
            Enumeration iter = this.alarmTable.elements();
            while (iter.hasMoreElements()) {
                ((AlarmRecord)iter.nextElement()).getAlarm().setPerceivedSeverity(severity);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateAlarmStatus() {
        MessageLog.traceEnter(SELF, "recalculateAlarmStatus()");
        Object object = this.alarmStatusAttrLock;
        synchronized (object) {
            Object object2 = this.alarmTableLock;
            synchronized (object2) {
                int aS = this.alarmStatusAttr & 1;
                Enumeration iter = this.alarmTable.elements();
                while (iter.hasMoreElements()) {
                    AlarmRecord ar = (AlarmRecord)iter.nextElement();
                    String severity = ar.perceivedSeverity;
                    if (severity.equals("2")) {
                        aS |= 0x12;
                        continue;
                    }
                    if (severity.equals("3")) {
                        aS |= 0x14;
                        continue;
                    }
                    if (severity.equals("4")) {
                        aS |= 0x18;
                        continue;
                    }
                    aS |= 0x10;
                }
                this.alarmStatusAttr = aS;
            }
        }
    }

    public void alarmRaised(UnlinkedSignal alarmInd, String proxyName) {
        if (alarmInd == null) {
            MessageLog.traceError(SELF, "alarmRaised(), Error, alarm ind signal is null!! Mo: " + this.myMo.getFullDistinguishedName());
            return;
        }
        StringBuffer sigInfo = new StringBuffer();
        try {
            FaultIndSignalInfo recInd = (FaultIndSignalInfo)alarmInd;
            sigInfo.append(this.myMo.getLocalDistinguishedName() + ", ");
            sigInfo.append("froId: " + recInd.getFroId() + ", ");
            if (recInd instanceof ChcNodeBPrimFaultIndS) {
                recInd.setSpecificProblem(this.getSpecificProblemForGenericRbsLicense(((ChcNodeBPrimFaultIndS)recInd).internalID));
            }
            sigInfo.append("specificProblem: " + recInd.getSpecificProblem() + ", ");
            sigInfo.append("faulty resources: " + recInd.getNrOfFaultyResources() + ", info: [");
            for (int i = 0; i < recInd.getNrOfFaultyResources(); ++i) {
                if (i > 0) {
                    sigInfo.append(", ");
                }
                sigInfo.append("{froId: " + recInd.getFaultyResourceFroId()[i] + ", froType: " + recInd.getFaultyResourceType()[i] + "}");
            }
            sigInfo.append("]");
            MessageLog.traceEnter(SELF, "alarmRaised() on MO: " + sigInfo);
        }
        catch (Exception e) {
            MessageLog.traceEnter(SELF, "alarmRaised() on MO: " + this.myMo);
            MessageLog.traceError(SELF, "failed to prepare detailed message", e);
        }
        if (proxyName == null) {
            MessageLog.traceError(SELF, "alarmRaised(), Error, proxy name is null!! MO: " + this.myMo.getFullDistinguishedName());
            return;
        }
        try {
            AlarmObserver dispatcher = FaultIndExcep.getDispatcher(this.myMo, alarmInd);
            if (dispatcher != null) {
                dispatcher.alarmRaised(alarmInd, proxyName);
            } else {
                FaultIndSignalInfo recInd = (FaultIndSignalInfo)alarmInd;
                this.handleAlarmRaised(recInd, proxyName);
            }
        }
        catch (MoAlarmsException e) {
            MessageLog.traceError(SELF, "Could not generate alarm due to exception!! (" + sigInfo + ")", e);
        }
    }

    private void handleAlarmRaised(FaultIndSignalInfo alarmInd, String proxyName) throws MoAlarmsException {
        MessageLog.traceEnter(SELF, "handleAlarmRaised()");
        int specificProblem = alarmInd.getSpecificProblem();
        if (!this.checkAndUpdateIfReceivedAfterProxyDown(proxyName, specificProblem)) {
            Alarm alarm;
            String severity;
            if (alarmInd instanceof EqcExtAlarmIndS && this.myMo.getType().equals("AlmDevice")) {
                severity = this.getAlmDevPerceivedSeverity();
                alarm = this.createExtAlm(alarmInd);
            } else if (alarmInd instanceof ChcNodeBPrimFaultIndS) {
                AlarmInfo alarmInfo = new AlarmInfo(this.froObjectType, specificProblem, "x4", "14", "3", RbsGenericLicenseManager.getRbsLicenseFeature((int)((ChcNodeBPrimFaultIndS)alarmInd).internalID).licenseName + "LicenseNotValid");
                alarm = this.createAlarm(alarmInfo, alarmInd);
                severity = alarmInfo.getPerceivedSeverity();
            } else {
                this.checkAndUpdateIfAlarmShouldBeMapped(alarmInd);
                this.checkAndUpdateIfGeneralSwErrorFaultInd(alarmInd);
                AlarmInfo alarmInfo = AlarmInfoList.getAlarmInfo(this.froObjectType, alarmInd.getSpecificProblem());
                if (alarmInfo == null) {
                    throw new MoAlarmsException("Unknown specificProblem: " + alarmInd.getSpecificProblem() + ", fRo type " + this.froObjectType + " received from FRO, signal: " + alarmInd.getClass().getName() + ", MO:" + this.myMo.getFullDistinguishedName());
                }
                alarm = this.createAlarm(alarmInfo, alarmInd);
                severity = alarmInfo.getPerceivedSeverity();
            }
            if (alarm != null) {
                this.addAlarm(proxyName, alarmInd.getSpecificProblem(), severity, alarm);
                this.recalculateAlarmStatus();
            }
        }
    }

    private void checkAndUpdateIfAlarmShouldBeMapped(FaultCeasedInfo alarmInd) {
        Integer newFaultType;
        if (!this.isAlarmInfoGenerated(alarmInd) && (newFaultType = (Integer)this.faultTypeMappingTable.get(new Integer(alarmInd.getSpecificProblem()))) != null) {
            MessageLog.trace(5, SELF, "Mapping faultType from signal: " + alarmInd.getSpecificProblem() + " to new faultType: " + newFaultType);
            alarmInd.setSpecificProblem(newFaultType);
        }
    }

    private void checkAndUpdateIfGeneralSwErrorFaultInd(FaultIndSignalInfo alarmInd) {
        MessageLog.traceEnter(SELF, "checkAndUpdateIfGeneralSwErrorFaultInd()");
        AlarmInfo alarmInfo = AlarmInfoList.getAlarmInfo(this.froObjectType, alarmInd.getSpecificProblem());
        if (alarmInfo == null && AlarmInfoList.getAlarmInfo(this.froObjectType, 49154) != null) {
            MessageLog.traceError(SELF, "Mapping Unknown specificProblem : " + alarmInd.getSpecificProblem() + " to General Software Error , fRo type: " + this.froObjectType + " received from FRO, signal : " + alarmInd.getClass().getName() + "    Mo:" + this.myMo.getFullDistinguishedName());
            alarmInd.setAdditionalText(MAP_FAULT_IND + alarmInd.getSpecificProblem());
            alarmInd.setSpecificProblem(49154);
        }
    }

    private boolean isAlarmInfoGenerated(FaultCeasedInfo alarmInd) {
        AlarmInfo alarmInfo = AlarmInfoList.getAlarmInfo(this.froObjectType, alarmInd.getSpecificProblem());
        return alarmInfo != null;
    }

    public void alarmCeased(UnlinkedSignal alarmCeasedInd, String proxyName) {
        CeasedIndSignalInfo recInd = (CeasedIndSignalInfo)alarmCeasedInd;
        if (recInd instanceof ChcNodeBPrimFaultCeaseIndS) {
            recInd.setSpecificProblem(this.getSpecificProblemForGenericRbsLicense(((ChcNodeBPrimFaultCeaseIndS)recInd).internalID));
        }
        MessageLog.traceEnter(SELF, "alarmCeased(" + this.myMo.getLocalDistinguishedName() + ", specificProblem = " + recInd.getSpecificProblem() + ", froId = " + recInd.getFroId() + ")");
        try {
            AlarmObserver dispatcher = FaultIndExcep.getDispatcher(this.myMo, alarmCeasedInd);
            if (dispatcher != null) {
                dispatcher.alarmCeased(alarmCeasedInd, proxyName);
            } else {
                this.clearAlarm(proxyName, alarmCeasedInd);
                this.recalculateAlarmStatus();
            }
        }
        catch (MoAlarmsException e) {
            MessageLog.traceError(SELF, "Couldn't cease the alarm due to exception", e);
        }
    }

    private int checkGeneralSwErrorGetSpecificProblem(UnlinkedSignal alarmInd) {
        if (!(alarmInd instanceof EqcExtAlarmCeaseIndS)) {
            AlarmInfo alarmInfo = AlarmInfoList.getAlarmInfo(this.froObjectType, ((CeasedIndSignalInfo)alarmInd).getSpecificProblem());
            AlarmInfo generalSoftwareErrorAlarmInfo = AlarmInfoList.getAlarmInfo(this.froObjectType, 49154);
            if (alarmInfo == null && generalSoftwareErrorAlarmInfo != null) {
                MessageLog.traceError(SELF, "Mapping Unknown specificProblem : " + ((CeasedIndSignalInfo)alarmInd).getSpecificProblem() + " to General Software Error , fRo type: " + this.froObjectType + " received from FRO, signal : " + alarmInd.getClass().getName() + "    Mo:" + this.myMo.getFullDistinguishedName());
                return 49154;
            }
        }
        return ((CeasedIndSignalInfo)alarmInd).getSpecificProblem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndUpdateIfReceivedAfterProxyDown(String proxyClassName, int specificProblem) throws MoAlarmsException {
        Object object = this.alarmTableLock;
        synchronized (object) {
            for (int i = 0; i < this.alarmTable.size(); ++i) {
                AlarmRecord ar = (AlarmRecord)this.alarmTable.elementAt(i);
                if (ar.getSpecificProblem() != specificProblem) continue;
                ar.receivedAfterProxyDown = true;
                ar.addProxyClass(proxyClassName);
                MessageLog.trace(5, SELF, "Alarm already exists; " + proxyClassName + " is added to the set of fault submitters; new size: " + ar.faultIndSubmitters.size());
                return true;
            }
            return false;
        }
    }

    private Alarm createAlarm(AlarmInfo alarmInfo, FaultIndSignalInfo alarmInd) throws MoAlarmsException {
        Alarm alarm;
        try {
            alarm = Alarm.create((String)this.myMo.getType(), (String)this.myMo.getFullDistinguishedName(), (String)alarmInfo.getEventType(), (String)CELLO_INPUT, (String)alarmInfo.getProbableCause(), (String)alarmInfo.getPerceivedSeverity(), (String)alarmInfo.getSpecificProblem(), (String)AdditionalTextExcep.getAdditionalText(this.myMo, alarmInd), (AdditionalInfo[])this.getAdditionalInfoList(alarmInd), (int[])alarmInd.getEventIds(), (boolean)alarmInd.isSecondary());
            StringBuffer mpswIV = new StringBuffer();
            mpswIV.append("Alarm").append(W_SP).append(alarmInfo.getEventType()).append(W_SP).append(alarmInfo.getProbableCause()).append(W_SP).append(alarmInfo.getSpecificProblem()).append(W_SP).append("severity").append(W_SP).append(alarmInfo.getPerceivedSeverity());
            MessageLog.trace(5, SELF, mpswIV.toString());
            if (alarmInd.getSpecificProblem() == 49154) {
                this.writeLog(alarmInd);
            }
        }
        catch (AlarmDuplicatedException e) {
            throw new MoAlarmsException("Couldn't create Alarm with specificProblem = " + alarmInfo.getSpecificProblem() + ", due to exception!! " + (Object)((Object)e));
        }
        return alarm;
    }

    private AdditionalInfo[] getAdditionalInfoList(FaultIndSignalInfo alarmInd) {
        ArrayList<AdditionalInfo> addInfoList;
        ArrayList<AdditionalInfo> possibleAddInfoList = AdditionalInfoExcep.getAdditionalInfo(this.myMo, alarmInd);
        if (possibleAddInfoList == null) {
            addInfoList = new ArrayList<AdditionalInfo>(1);
            int faultyDevNr = alarmInd.getNrOfFaultyResources();
            long[] faultyDevFroIds = alarmInd.getFaultyResourceFroId();
            int[] faultyDevTypes = alarmInd.getFaultyResourceType();
            int addInfiIndex = 2;
            for (int i = 0; i < faultyDevNr; ++i) {
                AdditionalInfo addInfoElement = this.getAdditionalInfo(faultyDevTypes[i], faultyDevFroIds[i], addInfiIndex);
                if (addInfoElement == null) continue;
                ++addInfiIndex;
                addInfoList.add(addInfoElement);
                MessageLog.trace(5, this.myMo.getClass(), "getAdditionalInfoList(),addInfo " + addInfoElement.getName() + ", " + addInfoElement.getValue());
            }
        } else {
            addInfoList = possibleAddInfoList;
        }
        return addInfoList.toArray(new AdditionalInfo[addInfoList.size()]);
    }

    private AdditionalInfo getAdditionalInfo(int froFaultyDeviceType, long froId, int addInfoIndex) {
        MoIterator iter;
        String strMoType = FroObjectTypeDefs.getMoTypeName(froFaultyDeviceType);
        if (strMoType.endsWith("DeviceGroup")) {
            MoIterator possibleIter = BoamHelper.findMOs(strMoType);
            if (possibleIter.size() > 0) {
                iter = possibleIter;
            } else {
                int indexOfDeviceGroupKeyword = strMoType.indexOf("DeviceGroup");
                String strMoId = strMoType.substring(0, indexOfDeviceGroupKeyword);
                iter = BoamHelper.findMOs("DeviceGroup", strMoId);
            }
        } else {
            iter = BoamHelper.findMOs(strMoType);
        }
        while (iter.hasMoreElements()) {
            ManagedObject mo = iter.nextMo();
            try {
                if ((long)((MaoHasFro)mo).getFroId(null) != froId) continue;
                return new AdditionalInfo(ADD_INFO_NAME + addInfoIndex, mo.getFullDistinguishedName());
            }
            catch (MoAccessException e) {
                MessageLog.trace(5, SELF, "could not get froId: " + (Object)((Object)e));
            }
        }
        MessageLog.trace(5, SELF, "WARNING: getAdditionalInfo(), AdditionalInfo couldn't be created; failed to find MO. Probably wrong froId is sent by RO for this object type!! FaultyDeviceType: " + froFaultyDeviceType + " (looked up as " + strMoType + "), faultyDevFroId: " + froId + ", MO:" + this.myMo.getFullDistinguishedName());
        return null;
    }

    private String getAlmDevPerceivedSeverity() {
        try {
            AlmDeviceMo almMo = (AlmDeviceMo)this.myMo;
            return Integer.toString(almMo.getPerceivedSeverity(null));
        }
        catch (MoAccessException e) {
            return "0";
        }
    }

    private Alarm createExtAlm(FaultIndSignalInfo recInd) throws MoAlarmsException {
        String addText = CELLO_INPUT;
        String probableCause = CELLO_INPUT;
        try {
            AlmDeviceMo almMo = (AlmDeviceMo)this.myMo;
            addText = "AlmDevice " + almMo.getAlarmSlogan(null);
            probableCause = Integer.toString(almMo.getProbableCause(null));
        }
        catch (MoAccessException ignored) {
            // empty catch block
        }
        try {
            Alarm alarm = Alarm.create((String)this.myMo.getType(), (String)this.myMo.getFullDistinguishedName(), (String)ExternalAlarmsMapTable.getEventType(probableCause), (String)CELLO_INPUT, (String)probableCause, (String)this.getAlmDevPerceivedSeverity(), (String)"AlmDevice_ExternalAlarm", (String)addText, (AdditionalInfo[])new AdditionalInfo[0], (int[])recInd.getEventIds(), (boolean)recInd.isSecondary());
            StringBuffer mpswIV = new StringBuffer();
            mpswIV.append("Alarm").append(W_SP).append("x3").append(W_SP).append(probableCause).append(W_SP).append("AlmDevice_ExternalAlarm").append(W_SP).append("severity").append(W_SP).append(this.getAlmDevPerceivedSeverity());
            MessageLog.trace(5, SELF, mpswIV.toString());
            return alarm;
        }
        catch (AlarmDuplicatedException e) {
            throw new MoAlarmsException("Couldn't create Alarm with specificProblem = AlmDevice_ExternalAlarm, due to exception!! " + (Object)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAlarm(String proxyClassName, int specificProblem, String severity, Alarm anAlarm) throws MoAlarmsException {
        Object object = this.alarmTableLock;
        synchronized (object) {
            if (anAlarm != null) {
                AlarmRecord alarmRecord = new AlarmRecord(proxyClassName, specificProblem, severity, anAlarm);
                this.alarmTable.addElement(alarmRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAlarm(String proxyClassName, UnlinkedSignal alarmCeasedInd) throws MoAlarmsException {
        this.checkAndUpdateIfAlarmShouldBeMapped((FaultCeasedInfo)alarmCeasedInd);
        int specificProblem = this.checkGeneralSwErrorGetSpecificProblem(alarmCeasedInd);
        Object object = this.alarmTableLock;
        synchronized (object) {
            if (!this.removeProxyClearAlarm(specificProblem, proxyClassName)) {
                MessageLog.trace(5, SELF, "No Alarm to be cleared, with SpecificProblem : " + ((CeasedIndSignalInfo)alarmCeasedInd).getSpecificProblem() + " received from FRO, signal : " + alarmCeasedInd.getClass().getName() + "    Mo:" + this.myMo.getFullDistinguishedName());
            }
        }
    }

    private boolean removeProxyClearAlarm(int specificProblem, String proxyClassName) throws MoAlarmsException {
        boolean result2 = false;
        for (int i = 0; i < this.alarmTable.size(); ++i) {
            AlarmRecord ar = (AlarmRecord)this.alarmTable.elementAt(i);
            if (ar.getSpecificProblem() != specificProblem) continue;
            result2 = true;
            if (ar.containsProxyClassName(proxyClassName)) {
                ar.removeProxyClass(proxyClassName);
                MessageLog.trace(5, SELF, proxyClassName + " was removed from set of submitters, remaining size: " + ar.faultIndSubmitters.size());
            }
            if (ar.isFaultSubmitterListEmpty()) {
                ar.getAlarm().clear();
                this.alarmTable.removeElementAt(i);
                MessageLog.trace(5, SELF, "Alarm cleared for specificProblem: " + specificProblem);
                continue;
            }
            MessageLog.trace(5, SELF, "Alarm not cleared for specificProblem: " + specificProblem + "; n. of remaining submitters: " + ar.faultIndSubmitters.size());
        }
        return result2;
    }

    private int getSpecificProblemForGenericRbsLicense(int internalId) {
        return 26024 + internalId;
    }

    private void writeLog(FaultIndSignalInfo alarmInd) {
        StringBuffer sb = new StringBuffer();
        sb.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS").format(new Date())).append(SEMICOLON);
        sb.append(EVENT_ID).append(COLON);
        int[] eventIds = alarmInd.getEventIds();
        for (int i = 0; i < eventIds.length; ++i) {
            sb.append(eventIds[i]).append(SEMICOLON);
        }
        sb.append(MO).append(COLON).append(this.myMo.getFullDistinguishedName()).append(SEMICOLON);
        String additionalText = alarmInd.getAdditionalText();
        sb.append(FAULT_MESSAGE).append(COLON).append(SwErrorLogHelper.getInfo(additionalText, "faultMessage<", END_FLAG)).append(SEMICOLON);
        sb.append(FAULT_ID).append(COLON).append(SwErrorLogHelper.getInfo(additionalText, "faultID<", END_FLAG)).append(SEMICOLON);
        sb.append(FAULT_DESCRIPTION).append(COLON).append(SwErrorLogHelper.getInfo(additionalText, "faultDescription<", END_FLAG));
        sb.append("\n");
        SwErrorLogHelper.writeLog(SW_ERROR_ALARM_LOG_PATH, sb.toString());
    }

    private static class AlarmRecord {
        private final int specificProblem;
        private final Alarm alarm;
        private final Set faultIndSubmitters = new HashSet(1);
        private final String perceivedSeverity;
        private boolean receivedAfterProxyDown = true;

        public AlarmRecord(String proxyClassName, int specificProblem, String perceivedSeverity, Alarm anAlarm) throws MoAlarmsException {
            this.addProxyClass(proxyClassName);
            this.specificProblem = specificProblem;
            this.perceivedSeverity = perceivedSeverity;
            this.alarm = anAlarm;
        }

        public Alarm getAlarm() {
            return this.alarm;
        }

        public boolean containsProxyClassName(String name) {
            return this.faultIndSubmitters.contains(name);
        }

        public void addProxyClass(String name) throws MoAlarmsException {
            if (!this.faultIndSubmitters.add(name)) {
                throw new MoAlarmsException(name + " can't be added to the fault submitters list for mo. Proxy already exists in the list!! specificProblem: " + this.specificProblem);
            }
        }

        public void removeProxyClass(String name) throws MoAlarmsException {
            if (!this.faultIndSubmitters.remove(name)) {
                throw new MoAlarmsException(name + " proxy doesn't exist in the fault submitters list!! specificProblem: " + this.specificProblem);
            }
        }

        public boolean isFaultSubmitterListEmpty() {
            return this.faultIndSubmitters.isEmpty();
        }

        public int getSpecificProblem() {
            return this.specificProblem;
        }
    }
}

