/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos;

import java.util.Hashtable;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;

public final class DhcpOptionsReader {
    public static final int DHCP_OPTIONS_CODE_SUBNETMASK = 1;
    public static final int DHCP_OPTIONS_CODE_SERVERIDENTIFIER = 54;
    public static final int DHCP_OPTIONS_CODE_DOMAINNAMESERVER = 6;
    public static final int DHCP_OPTIONS_ROUTER = 3;
    public static final int DHCP_OPTIONS_CODE_TFTPSERVER = 66;
    public static final int DHCP_OPTIONS_CODE_BOOTFILE = 67;
    public static final int DHCP_OPTIONS_CODE_DHCP_CLIENT_ID = 61;
    public static final int DHCP_OPTIONS_CODE_PARAM_REQ_LIST = 55;
    public static final int DHCP_OPTIONS_CODE_END = 255;
    private static final String PROTOCOL_SEPARATOR_SYMBOL = ".";
    private static final String DHCP_OPTION_NO_SEPARATOR = "";
    private final Hashtable dhcpOptions = new Hashtable();

    public DhcpOptionsReader(int[] options) {
        MessageLog.trace(1, this.getClass(), "DhcpOptionsReader(): content of dhcp options int array : " + this.toString(options));
        this.dhcpOptionsArrayToHashtable(options, 0);
    }

    public String getSubnetMask() {
        String value = this.getValue(1, PROTOCOL_SEPARATOR_SYMBOL);
        return !value.equalsIgnoreCase(DHCP_OPTION_NO_SEPARATOR) ? value.substring(0, value.length() - 1) : value;
    }

    public String getDhcpIpAddress() {
        String value = this.getValue(54, PROTOCOL_SEPARATOR_SYMBOL);
        return !value.equalsIgnoreCase(DHCP_OPTION_NO_SEPARATOR) ? value.substring(0, value.length() - 1) : value;
    }

    public String getDnsIpAddress() {
        String value = this.getValue(6, PROTOCOL_SEPARATOR_SYMBOL);
        return !value.equalsIgnoreCase(DHCP_OPTION_NO_SEPARATOR) ? value.substring(0, value.length() - 1) : value;
    }

    public String getDefaultGateway() {
        String value = this.getValue(3, PROTOCOL_SEPARATOR_SYMBOL);
        return !value.equalsIgnoreCase(DHCP_OPTION_NO_SEPARATOR) ? value.substring(0, value.length() - 1) : value;
    }

    public String getSmrsIpAddress() {
        String value = this.getValue(66, DHCP_OPTION_NO_SEPARATOR);
        return value;
    }

    public String getSummaryAbsolutePathname() {
        return this.getValue(67, DHCP_OPTION_NO_SEPARATOR);
    }

    private String getValue(int dhcpCode, String valueSeparator) {
        int[] values = this.getOptionValue(dhcpCode);
        StringBuffer val = new StringBuffer();
        if (values == null || values.length == 0) {
            return DHCP_OPTION_NO_SEPARATOR;
        }
        for (int i = 0; i < values.length; ++i) {
            if (valueSeparator.equalsIgnoreCase(DHCP_OPTION_NO_SEPARATOR)) {
                val.append((char)values[i]);
                continue;
            }
            val.append(String.valueOf(values[i]) + PROTOCOL_SEPARATOR_SYMBOL);
        }
        return val.toString();
    }

    private void dhcpOptionsArrayToHashtable(int[] options, int codeIndex) {
        int optionLength = 0;
        int optionValueStartIndex = codeIndex + 2;
        int optionValueEndIndex = 0;
        try {
            optionLength = options[codeIndex + 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
        optionValueEndIndex = optionValueStartIndex + optionLength;
        if (optionValueEndIndex >= options.length) {
            MessageLog.traceError(this.getClass(), "Definition of Dhcp Option #" + options[codeIndex] + " is incorrect!");
            return;
        }
        if (codeIndex < options.length) {
            this.dhcpOptions.put(new Integer(options[codeIndex]), this.arrayCopy(options, optionValueStartIndex, optionValueEndIndex));
            this.dhcpOptionsArrayToHashtable(options, optionValueEndIndex);
        }
    }

    public int[] arrayCopy(int[] srcArray, int start, int end) {
        int[] arr = new int[end - start];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = srcArray[i + start];
        }
        return arr;
    }

    private int[] getOptionValue(int dhcpCode) {
        return (int[])this.dhcpOptions.get(new Integer(dhcpCode));
    }

    public String toString(int[] dhcpOptions) {
        if (dhcpOptions == null) {
            return DHCP_OPTION_NO_SEPARATOR;
        }
        StringBuffer result2 = new StringBuffer();
        for (int i = 0; i < dhcpOptions.length; ++i) {
            result2.append(dhcpOptions[i] + " ");
        }
        return result2.toString();
    }
}

