/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos;

import se.ericsson.cello.ipoam.IpMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.RbsConfigurationFailedException;

public class RbsConfigurationIpHelper {
    private static final Class THIS_CLASS = RbsConfigurationIpHelper.class;
    private static final String IP_LDN = "ManagedElement=1,IpOam=1,Ip=1";
    private MoRepository moRepository = MoRepository.instance();

    public String getOamIpAddress(Coordinator coordinator) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getOamIpAddress()");
        String exceptionInfo = "";
        String result2 = "";
        IpMo ipMo = (IpMo)this.moRepository.lookup(IP_LDN);
        if (ipMo == null) {
            throw new RbsConfigurationFailedException("Could not find Ip mo with LDN ManagedElement=1,IpOam=1,Ip=1");
        }
        String ipv6NodeIpAddress = ipMo.getNodeIpv6Address(coordinator);
        if (RbsConfigurationIpHelper.existsAndNotEmpty(ipv6NodeIpAddress)) {
            exceptionInfo = exceptionInfo + "nodeInterfaceName: " + ipMo + "with" + ipv6NodeIpAddress;
            result2 = ipv6NodeIpAddress;
        } else {
            String ipv4NodeIpAddress = ipMo.getNodeIpAddress(coordinator);
            if (RbsConfigurationIpHelper.existsAndNotEmpty(ipv4NodeIpAddress)) {
                exceptionInfo = exceptionInfo + "nodeInterfaceName: " + ipMo + "with" + ipv4NodeIpAddress;
                result2 = ipv4NodeIpAddress;
            }
        }
        if (result2 == null || "".equals(result2)) {
            throw new RbsConfigurationFailedException("Unable to find O&M Ip Address! " + exceptionInfo);
        }
        return result2;
    }

    public static boolean existsAndNotEmpty(String string) {
        return string != null && !"".equals(string) && !"-".equals(string);
    }
}

