/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice;

import java.io.File;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.swmanagement.LoadModuleMo;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcProgramProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateProgramRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetProgramParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsLmIdT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu.AuxPlugInUnitUpgradeHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.XpProgramMo;

public class XpProgramMoImpl
extends BoamManagedObject
implements XpProgramMo {
    public static final int XP_PROGRAM_TYPE = 1;
    public static final String XP_PROGRAM_FRO_ID = "xpProgramFroId";
    public static final int MAX_NO_OF_CHILDREN = 2;
    public static final int MO_DATA_REVISION = 8013001;
    protected MoData myData;
    private EqcProgramProxy eqcProgramProxy = EqcProgramProxy.instance();

    private XpProgramMoImpl(ManagedObject parent, String identity, String hwProductNumber, String hwProductRevision, LoadModuleMo checkedLoadModule, String checkedUserLabel, int checkedStartState, Coordinator context) throws MoAccessException {
        super(parent, "XpProgram", identity, context, 2);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        int groupFroId = ((AuxDeviceGroupMo)parent).getAuxGroupFroId(context);
        if (checkedLoadModule.getFileState(context) == 0) {
            throw new ValueOutOfRangeException("XpProgram", "The LM is not installed. LM should be installed before create XpProgram!!. LM: " + checkedLoadModule.getLocalDistinguishedName());
        }
        Struct loadModuleProductData = checkedLoadModule.getProductData(context);
        String completeFilePath = checkedLoadModule.getLoadModuleFilePath(context);
        RbsLmIdT rbsLmId = new RbsLmIdT(this.checkFilePath(completeFilePath), this.checkFileName(completeFilePath), this.getFileSize(completeFilePath), (String)loadModuleProductData.getValue("productNumber"), (String)loadModuleProductData.getValue("productRevision"), hwProductNumber, hwProductRevision);
        EqcCreateProgramRspS rspSig = this.eqcProgramProxy.createProgram(this.getTxIdTransactional(context), 0L, groupFroId, checkedStartState, rbsLmId, 1);
        this.initMoData(parent, checkedUserLabel, checkedLoadModule, (int)rspSig.programFroId, context);
        MessageLog.trace(1, this.getClass(), "XpProgram MO is Created ");
    }

    private XpProgramMoImpl(ManagedObject parent, String identity, String hwProductNumber, String hwProductRevision, String preInstalledSwProdNum, String preInstalledSwProdRev, Coordinator context) throws MoAccessException {
        super(parent, "XpProgram", identity, context, 2);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        int groupFroId = ((AuxDeviceGroupMo)parent).getAuxGroupFroId(context);
        RbsLmIdT rbsLmId = new RbsLmIdT("", "", 0, preInstalledSwProdNum, preInstalledSwProdRev, hwProductNumber, hwProductRevision);
        EqcCreateProgramRspS rspSig = this.eqcProgramProxy.createProgram(this.getTxIdTransactional(context), 0L, groupFroId, 1, rbsLmId, 1);
        this.initMoData(parent, "", null, (int)rspSig.programFroId, context);
        MessageLog.trace(1, this.getClass(), "XpProgram MO is Created :" + this.getFullDistinguishedName());
    }

    public XpProgramMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
        MessageLog.trace(1, this.getClass(), "XpProgram MO is Restored ");
    }

    public static synchronized XpProgramMoImpl create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(XpProgramMoImpl.class, "create()");
        XpProgramMoImpl.checkTransaction(context);
        XpProgramMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "XpProgram");
        int checkedStartState = ValidateAttributes.checkAndGetIntAttribute(attributes, "startState", "optional", 1, 0, 1, "XpProgram");
        ManagedObject checkedLoadModule = ValidateAttributes.checkAndGetReferenceAttribute("loadModule", attributes, "mandatory", new String[]{"LoadModule"}, "XpProgram");
        ValidateAttributes.checkOtherAttributes(attributes, "XpProgram");
        AuxPlugInUnitMo auxPlugInUnitMoImpl = (AuxPlugInUnitMo)parent.getParent();
        PiuTypeMo piuTypeMoImpl = (PiuTypeMo)auxPlugInUnitMoImpl.getPiuType(context);
        Struct piuTypeProductData = piuTypeMoImpl.getProductData(context);
        String hwProductNumber = (String)piuTypeProductData.getValue("productNumber");
        String hwProductRevision = (String)piuTypeProductData.getValue("productRevision");
        return new XpProgramMoImpl(parent, identity, hwProductNumber, hwProductRevision, (LoadModuleMo)checkedLoadModule, checkedUserLabel, checkedStartState, context);
    }

    public static synchronized XpProgramMoImpl createWithUpSw(ManagedObject parent, String identity, String hwProductNumber, String hwProductRevision, ManagedObject loadModule, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(XpProgramMoImpl.class, "create() with UpSw");
        XpProgramMoImpl.checkTransaction(context);
        XpProgramMoImpl.checkParent(parent);
        if (hwProductNumber == null || hwProductNumber.length() == 0) {
            throw new AttrMissingAtCreateException("hwProductNumber", "XpProgram");
        }
        if (hwProductRevision == null || hwProductRevision.length() == 0) {
            throw new AttrMissingAtCreateException("hwProductRevision", "XpProgram");
        }
        if (loadModule == null || !(loadModule instanceof LoadModuleMo)) {
            throw new AttrMissingAtCreateException("loadModule ref is null or wrong type!!", "XpProgram");
        }
        return new XpProgramMoImpl(parent, identity, hwProductNumber, hwProductRevision, (LoadModuleMo)loadModule, "", 1, context);
    }

    public static synchronized XpProgramMoImpl createWithpreInstalledSw(ManagedObject parent, String identity, String hwProductNumber, String hwProductRevision, String preInstalledSwProdNum, String preInstalledSwProdRev, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(XpProgramMoImpl.class, "create() with preInstalledSw");
        XpProgramMoImpl.checkTransaction(context);
        XpProgramMoImpl.checkParent(parent);
        if (hwProductNumber == null || hwProductNumber.length() == 0) {
            throw new AttrMissingAtCreateException("hwProductNumber", "XpProgram");
        }
        if (hwProductRevision == null || hwProductRevision.length() == 0) {
            throw new AttrMissingAtCreateException("hwProductRevision", "XpProgram");
        }
        if (preInstalledSwProdNum == null || preInstalledSwProdNum.length() == 0) {
            throw new AttrMissingAtCreateException("preInstalledSwProdNum", "XpProgram");
        }
        if (preInstalledSwProdRev == null || preInstalledSwProdRev.length() == 0) {
            throw new AttrMissingAtCreateException("preInstalledSwProdRev", "XpProgram");
        }
        return new XpProgramMoImpl(parent, identity, hwProductNumber, hwProductRevision, preInstalledSwProdNum, preInstalledSwProdRev, context);
    }

    private static void checkParent(ManagedObject parent) throws MoAccessException {
        MessageLog.traceEnter(XpProgramMoImpl.class, "checkParent()  " + parent);
        if (parent == null) {
            throw new IllegalParentException("Parent is null!!");
        }
        if (!AuxPlugInUnitUpgradeHelper.isAuxGroupLoadable(parent)) {
            throw new IllegalParentException("Unexpected parent:" + parent.getClass().getName());
        }
    }

    private void initMoData(ManagedObject parent, String checkedUserLabel, LoadModuleMo checkedLoadModule, int xpProgramFroId, Coordinator context) throws MoAccessException {
        MessageLog.trace(1, this.getClass(), "initMoData()");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.bcmStoreAndRegisterIntAttribute(XP_PROGRAM_FRO_ID, xpProgramFroId);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterReferenceAttribute("loadModule", (ManagedObject)checkedLoadModule);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.myData.setRevision(8013001);
    }

    private String checkFileName(String str) {
        MessageLog.traceEnter(this.getClass(), " checkFileName oldFilePath and name from loadModuleMo : " + str);
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return "";
        }
        StringBuffer newStrBuf = new StringBuffer(str);
        StringBuffer reversedStrBuf = newStrBuf.reverse();
        String reversedStr = new String(reversedStrBuf);
        int index = reversedStr.indexOf("/");
        String str1 = reversedStr.substring(0, index);
        StringBuffer newStrBuf1 = new StringBuffer(str1);
        String fileName = new String(newStrBuf1.reverse());
        MessageLog.traceEnter(this.getClass(), " checkFileName returned newFileName to be send to RO : " + fileName);
        return fileName;
    }

    private String checkFilePath(String str) {
        MessageLog.traceEnter(this.getClass(), " checkFilePath oldFilePath from loadModuleMo : " + str);
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return "";
        }
        StringBuffer newStrBuf = new StringBuffer(str);
        StringBuffer reversedStrBuf = newStrBuf.reverse();
        String reversedStr = new String(reversedStrBuf);
        int index = reversedStr.indexOf("/");
        String str1 = reversedStr.substring(index + 1, reversedStr.length());
        StringBuffer newStrBuf1 = new StringBuffer(str1);
        String filePath = new String(newStrBuf1.reverse());
        MessageLog.traceEnter(this.getClass(), " checkFilePath newFilePath to RO : " + filePath);
        return filePath;
    }

    private int getFileSize(String absoluteFilePathNameString) throws MoAccessException {
        int fileSize = 0;
        try {
            File outFile = new File(absoluteFilePathNameString);
            long theOutFileSize = 0L;
            if (outFile.exists() && outFile.isFile()) {
                theOutFileSize = outFile.length();
            }
            fileSize = new Long(theOutFileSize).intValue();
        }
        catch (RuntimeException e) {
            throw new MoCanNotBeCreatedException("XpProgram, could not get file size from file system for: " + absoluteFilePathNameString + " due to Exception: " + e);
        }
        MessageLog.trace(1, this.getClass(), " getFileSize(), The loadModule file path:" + absoluteFilePathNameString + ", file size: " + fileSize);
        return fileSize;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int xpProgramFroId = this.getXpProgramFroId(context);
        this.eqcProgramProxy.deleteProgram(this.getTxIdTransactional(context), 0L, xpProgramFroId);
        this.myData.delete(context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), "XpProgram is Deleted");
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel()");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel()");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public int getOperationalState(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        return 0;
    }

    public int getStartState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getStartState()");
        int xpProgramFroId = this.getXpProgramFroId(context);
        EqcGetProgramParamRspS cfmSig = this.eqcProgramProxy.getProgramParameters(this.getTxIdNonTransactional(context), 0L, xpProgramFroId);
        return cfmSig.startState;
    }

    public void setStartState(int newStartState, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setStartState()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int xpProgramFroId = this.getXpProgramFroId(context);
        if (newStartState != 0 && newStartState != 1) {
            throw new ValueOutOfRangeException("startState", "XpProgram");
        }
        int currStartState = this.getStartState(context);
        if (newStartState == currStartState && currStartState == 0) {
            MessageLog.trace(2, this.getClass(), " The startState of this XpProgram is already disabled ");
        }
        if (newStartState == currStartState) {
            MessageLog.trace(2, this.getClass(), " Ignoring the set operation!! The new startState is same as old startStat. startStat:" + newStartState);
        } else {
            this.eqcProgramProxy.setProgramState(this.getTxIdTransactional(context), 0L, newStartState, xpProgramFroId);
            this.sendAVC("startState", newStartState, context);
        }
    }

    public ManagedObject getLoadModule(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getLoadModule()");
        return this.bcmGetReferenceAttribute("loadModule", context);
    }

    public int getXpProgramFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getXpProgramFroId()");
        return this.bcmGetIntAttribute(XP_PROGRAM_FRO_ID, context);
    }

    public String getType() {
        return "XpProgram";
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public void actionStopImmediate(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStopImmediate()");
    }

    public void actionStartImmediate(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStartImmediate()");
    }

    public boolean getIsUpgradePersistent(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getIsUpgradePersistent()");
        return false;
    }

    public void setIsUpgradePersistent(boolean value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setIsUpgradePersistent()");
        XpProgramMoImpl.checkTransaction(context);
    }
}

