/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu;

import java.lang.reflect.Field;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.wcdma.rbs.boam.common.EnumConverter;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcAuxPiuProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSpecialIndT;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateAuxPiuRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetAuxPiuBHwPidRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetAuxPiuParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.common.ProductDataUtil;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.AuxPlugInUnitHubPosition;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NoConnectionWithAuxiliaryUnitException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.struct.SpecialIndicatorStruct;

public final class AuxPlugInUnitFroMao {
    private static final EqcAuxPiuProxy relatedProxy = EqcAuxPiuProxy.instance();
    private static final int PIU_FRO_ID1 = 0;
    private static final int PIU_FRO_ID2 = 1;
    private static final int EQC_LED_DOUBLE_BLINK_AND_OUT = 7;
    private static final int EQC_LED_DOUBLE_BLINK_AND_STEADY_LIGHT = 8;
    private static final String MID_LINE = "-";
    private ManagedObject mo;

    public AuxPlugInUnitFroMao(ManagedObject mo) {
        this.mo = mo;
    }

    public int createAuxPlugInUnit(int transactionId, int clientId, int auxPiuType, int[] piuFroId, int hubPosition, String uniqueHwId, int externalAntenna, int additionalInfo, int auType, int sectorAntennaFroId, int additionalDeviceInfo, int isSharedWithExternalMe) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "createAuxPlugInUnit()<---");
        int aFroId = 0;
        String hubPosName = this.convHubPositionIntToName(hubPosition);
        try {
            EqcCreateAuxPiuRspS rspSig = relatedProxy.createAuxPiu(transactionId, clientId, auxPiuType, piuFroId[0], piuFroId[1], hubPosName, additionalInfo, sectorAntennaFroId, additionalDeviceInfo, isSharedWithExternalMe);
            aFroId = (int)rspSig.auxPiuFroId;
            if (auType == 18 || auType == 25 || auType == 26 && !uniqueHwId.equalsIgnoreCase(MID_LINE)) {
                relatedProxy.setUniqueHwId(transactionId, clientId, aFroId, externalAntenna, uniqueHwId);
            }
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 33) {
                MessageLog.trace(1, this.getClass(), this.mo.getType() + "createAuxPlugInUnit() : wrong slot position !");
                throw new MoCanNotBeCreatedException("The second available slot should be used");
            }
            throw e;
        }
        catch (MoAccessException moe) {
            throw moe;
        }
        return aFroId;
    }

    private String convHubPositionIntToName(int hubPos) {
        Field[] hubPosConsts = AuxPlugInUnitHubPosition.class.getFields();
        for (int f = 0; f < hubPosConsts.length; ++f) {
            try {
                int constValue = hubPosConsts[f].getInt(class$se$ericsson$wcdma$rbs$boam$mao$iface$gen$enumer$AuxPlugInUnitHubPosition == null ? AuxPlugInUnitFroMao.class$("se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.AuxPlugInUnitHubPosition") : class$se$ericsson$wcdma$rbs$boam$mao$iface$gen$enumer$AuxPlugInUnitHubPosition);
                if (hubPos != constValue) continue;
                return hubPosConsts[f].getName();
            }
            catch (IllegalAccessException iae) {
                return "";
            }
        }
        return "";
    }

    public void deleteAuxPlugInUnit(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteAuxPlugInUnit()<---");
        relatedProxy.deleteAuxPiu(transactionId, clientId, froId);
        MessageLog.trace(1, this.getClass(), this.mo.getType() + " has been deleted!");
    }

    public void setAuxPlugInUnitParameter(int transactionId, int clientId, int froId, int piuFroId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "setAuxPlugInUnitParameter()<---");
        relatedProxy.setAuxPiuParam(transactionId, clientId, froId, piuFroId);
    }

    public int getGreenLedStatusFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getGreenLedFroMao()<---");
        return AuxPlugInUnitFroMao.relatedProxy.getLedInfo((long)((long)clientId), (long)((long)transactionId), (long)((long)froId)).greenLed;
    }

    public int getRedLedStatusFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getRedLedFroMao()<----");
        return AuxPlugInUnitFroMao.relatedProxy.getLedInfo((long)((long)clientId), (long)((long)transactionId), (long)((long)froId)).redLed;
    }

    public int getYellowLedStatusFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getYellowLedFroMao()<---");
        return AuxPlugInUnitFroMao.relatedProxy.getLedInfo((long)((long)clientId), (long)((long)transactionId), (long)((long)froId)).yellowLed;
    }

    public int getFaultIndicatorFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getFaultIndicatorFroMao()<---");
        return this.performTemporaryMappingOfIndicationValues(AuxPlugInUnitFroMao.relatedProxy.getLedInfo((long)((long)clientId), (long)((long)transactionId), (long)((long)froId)).redLed);
    }

    public int getOperationalIndicatorFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getoperationalIndicatorFroMao()<---");
        return this.performTemporaryMappingOfIndicationValues(AuxPlugInUnitFroMao.relatedProxy.getLedInfo((long)((long)clientId), (long)((long)transactionId), (long)((long)froId)).greenLed);
    }

    public int getMaintenanceIndicatorFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getMaintenanceIndicatorFroMao()<---");
        return this.performTemporaryMappingOfIndicationValues(AuxPlugInUnitFroMao.relatedProxy.getLedInfo((long)((long)clientId), (long)((long)transactionId), (long)((long)froId)).blueLed);
    }

    private int performTemporaryMappingOfIndicationValues(int value) {
        switch (value) {
            case 8: {
                return 7;
            }
            case 7: {
                return 8;
            }
        }
        return value;
    }

    public int getOperationalStateFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getOperationalStateFroMao()<---");
        try {
            EqcGetAuxPiuParamRspS rpsSig = relatedProxy.getAuxPiuParameters(transactionId, clientId, froId);
            return rpsSig.opState;
        }
        catch (MoAccessException e) {
            MessageLog.traceError(AuxPlugInUnitFroMao.class, "getOperationalStateFroMao() : error occured");
            throw e;
        }
    }

    public int getAvailibilityStatusFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getAvailibilityStatusFroMao()<---");
        try {
            EqcGetAuxPiuParamRspS rpsSig = relatedProxy.getAuxPiuParameters(transactionId, clientId, froId);
            return rpsSig.availStatus;
        }
        catch (MoAccessException e) {
            MessageLog.traceError(AuxPlugInUnitFroMao.class, "getAvailibilityStatusFroMao() : error occured");
            throw e;
        }
    }

    public String getHubPositionFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getAvailibilityStatusFroMao()<---");
        try {
            EqcGetAuxPiuParamRspS rpsSig = relatedProxy.getAuxPiuParameters(transactionId, clientId, froId);
            return rpsSig.hubPosition;
        }
        catch (MoAccessException e) {
            MessageLog.traceError(AuxPlugInUnitFroMao.class, "getAdministrativeState() : error occured");
            throw e;
        }
    }

    public int getAdministrativeStateFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getAdministrativeStateFroMao()<---");
        try {
            EqcGetAuxPiuParamRspS rpsSig = relatedProxy.getAuxPiuParameters(transactionId, clientId, froId);
            return rpsSig.admState;
        }
        catch (MoAccessException e) {
            MessageLog.traceError(AuxPlugInUnitFroMao.class, "getAdministrativeState() : error occured");
            throw e;
        }
    }

    public void setAdministrativeStateFroMao(int transactionId, int clientId, int froId, int value) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "setAdministrativeStateFroMao()<---");
        try {
            relatedProxy.setAuxPiuAdmState(transactionId, clientId, froId, value);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(AuxPlugInUnitFroMao.class, "setAdministrativeStateFroMao failed");
            throw e;
        }
    }

    public boolean getIsSharedWithExternalMeFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getIsSharedWithExternalMeFroMao()<---");
        try {
            EqcGetAuxPiuParamRspS rpsSig = relatedProxy.getAuxPiuParameters(transactionId, clientId, froId);
            return EnumConverter.rbsBooleanTConverter(rpsSig.isSharedWithExternalMe);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(AuxPlugInUnitFroMao.class, "getIsSharedWithExternalMeFroMao() : error occured");
            throw e;
        }
    }

    public void setIsSharedWithExternalMeFroMao(int transactionId, int clientId, int froId, boolean value) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "setIsSharedWithExternalMeFroMao()<---");
        try {
            relatedProxy.setIsSharedWithExternalMe(transactionId, clientId, froId, EnumConverter.rbsBooleanTConverter(value));
        }
        catch (MoAccessException e) {
            MessageLog.traceError(AuxPlugInUnitFroMao.class, "setIsSharedWithExternalMeFroMao failed");
            throw e;
        }
    }

    public void actionRestartAuxUnitFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "actionRestartAuxUnitFroMao()<---");
        try {
            relatedProxy.restartAuxPiu(transactionId, clientId, froId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 14) {
                throw new NoConnectionWithAuxiliaryUnitException();
            }
            if (e.getOrgErrorCode() == 12) {
                throw new InternalErrorException();
            }
            throw e;
        }
    }

    public String getProductNumberFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getProductNumberFroMao()<---");
        EqcGetAuxPiuBHwPidRspS rspSig = relatedProxy.getRbsBasicHwPidT(transactionId, clientId, froId);
        return rspSig.basicHwPid.hwProductNumber;
    }

    public String getRStateFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getRStateFroMao()<---");
        EqcGetAuxPiuBHwPidRspS rspSig = relatedProxy.getRbsBasicHwPidT(transactionId, clientId, froId);
        return rspSig.basicHwPid.hwProductRevision;
    }

    public String getProductNameFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getProductNameFroMao()<---");
        EqcGetAuxPiuBHwPidRspS rspSig = relatedProxy.getRbsBasicHwPidT(transactionId, clientId, froId);
        return rspSig.basicHwPid.hwProductName;
    }

    public String getProductTypeFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getProductTypeFroMao()<---");
        EqcGetAuxPiuBHwPidRspS rspSig = relatedProxy.getRbsBasicHwPidT(transactionId, clientId, froId);
        return rspSig.basicHwPid.hwProductType;
    }

    public String getSerialNumberFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getSerialNumberFroMao()<---");
        EqcGetAuxPiuBHwPidRspS rspSig = relatedProxy.getRbsBasicHwPidT(transactionId, clientId, froId);
        return rspSig.basicHwPid.hwSerialNumber;
    }

    public String getProductionDateFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getProductionDateFroMao()<---");
        EqcGetAuxPiuBHwPidRspS rspSig = relatedProxy.getRbsBasicHwPidT(transactionId, clientId, froId);
        return ProductDataUtil.verifyDateFormat(rspSig.basicHwPid);
    }

    public String getUniqueHwId(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getUniqueHwIdFroMao()<---");
        try {
            EqcGetAuxPiuParamRspS rpsSig = relatedProxy.getAuxPiuParameters(transactionId, clientId, froId);
            return rpsSig.uniqueHwId.uniqueHwId;
        }
        catch (MoAccessException e) {
            MessageLog.traceError(AuxPlugInUnitFroMao.class, "getUniqueHwId() : error occured");
            throw e;
        }
    }

    public void setUniqueHwId(int transactionId, int clientId, int aFroId, int externalAntenna, String uniqueHwId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "setUniqueHwId()<---");
        relatedProxy.setUniqueHwId(transactionId, clientId, aFroId, externalAntenna, uniqueHwId);
    }

    public Struct[] getSpecialIndicatorFroMao(int transactionId, int clientId, int froId) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "getSpecialIndicator()<----");
        EcSpecialIndT[] specialIndicators = relatedProxy.getSpecialIndicator(clientId, transactionId, froId);
        SpecialIndicatorStruct[] specialIndicatorStructs = new SpecialIndicatorStruct[specialIndicators.length];
        for (int i = 0; i < specialIndicators.length; ++i) {
            specialIndicatorStructs[i] = new SpecialIndicatorStruct(specialIndicators[i].name, specialIndicators[i].status);
        }
        return specialIndicatorStructs;
    }

    public void setIsRadioInUcfFroMao(int transactionId, int clientId, int froId, boolean value) throws MoAccessException {
        MessageLog.traceEnter(AuxPlugInUnitFroMao.class, "setIsRadioInUcfFroMao()<---");
        try {
            relatedProxy.setIsRadioInUcf(transactionId, clientId, froId, EnumConverter.rbsBooleanTConverter(value));
        }
        catch (MoAccessException e) {
            MessageLog.traceError(AuxPlugInUnitFroMao.class, "setIsRadioInUcfFroMao failed");
            throw e;
        }
    }
}

