/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.climate;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CluDeviceGroupMo;

public class CluDeviceGroupMoImpl
extends AuxDeviceGroupMoImpl
implements CluDeviceGroupMo {
    public static final int MO_DATA_REVISION = 3020001;

    public CluDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery CluDeviceGroupMoImpl() <---");
        if (recoveredData.getAttribute("alarmStatus") == null) {
            MessageLog.traceError(this.getClass(), "Recovered attribute alarmStatusis null");
        }
        if (recoveredData.getAttribute("auxGroupFroId") == null) {
            MessageLog.traceError(this.getClass(), "Recovered attribute auxGroupFroIdis null");
        }
        if (recoveredData.getAttribute("userLabel") == null) {
            MessageLog.traceError(this.getClass(), "Recovered attribute userLabelis null");
        }
        try {
            this.addObservers(49568, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    private CluDeviceGroupMoImpl(ManagedObject parent, int alarmStatus, String userLabel, String identity, Coordinator context) throws MoAccessException {
        super(parent, "CluDeviceGroup", identity, context);
        MessageLog.traceEnter(this.getClass(), "CluDeviceGroupMoImpl() <---");
        EqcCreateGroupRspS rsp = this.createAuxDeviceGroupResource(parent, 49568, context);
        this.initMoData(userLabel, alarmStatus, (int)rsp.groupFroInfo.groupFroId, context);
        AuxDeviceGroupMoFactory.instance(49568).createDeviceGroupMoTree((ManagedObject)this, rsp.groupFroInfo, "", context);
        this.addObservers(49568, context);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(CluDeviceGroupMoImpl.class, "create() <---");
        ValidateAttributes.checkTransaction(context);
        ValidateAttributes.checkParent(parent, "AuxPlugInUnit");
        if (((AuxPlugInUnitMo)parent).getAuType(null) != 16) {
            throw new IllegalParentException("CluDeviceGroup");
        }
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "CluDeviceGroup");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "CluDeviceGroup");
        ValidateAttributes.checkOtherAttributes(attributes, "CluDeviceGroup");
        return new CluDeviceGroupMoImpl(parent, checkedAlarmStatus, checkedUserLabel, identity, context);
    }

    public String getType() {
        return "CluDeviceGroup";
    }

    private void initMoData(String userLabel, int alarmStatus, int auxGroupFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() <---");
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterIntAttribute("auxGroupFroId", auxGroupFroId);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.initAlarmStatus(alarmStatus, context);
        this.getMyMoData().setRevision(3020001);
    }
}

