/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.climate;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetClimCabinetParamsRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsGroupFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.common.ErrorMgr;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.AlreadyInitiatedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FunctionNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.MoNotLockedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationFailedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ParameterValueErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.TestBoardDependencyException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.FcuDeviceGroupMo;

public class FcuDeviceGroupMoImpl
extends AuxDeviceGroupMoImpl
implements FcuDeviceGroupMo {
    public static final int MO_DATA_REVISION = 3020001;

    public FcuDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "BfuDeviceGroupMoImpl() recovered constructor <---");
        ErrorMgr.shotDownIfNull((IntegerAttribute)recoveredData.getAttribute("alarmStatus"), "alarmStatus");
        ErrorMgr.shotDownIfNull((StringAttribute)recoveredData.getAttribute("userLabel"), "userLabel");
        ErrorMgr.shotDownIfNull((IntegerAttribute)recoveredData.getAttribute("auxGroupFroId"), "auxGroupFroId");
        try {
            this.addObservers(49565, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    private FcuDeviceGroupMoImpl(ManagedObject parent, int alarmStatus, String userLabel, int[] cabinetParameters, String identity, Coordinator context) throws MoAccessException {
        super(parent, "FcuDeviceGroup", identity, context);
        EqcCreateGroupRspS rsp = this.createAuxDeviceGroupResource(parent, 49565, context);
        RbsGroupFroInfoT groupFroInfo = rsp.groupFroInfo;
        int auxGroupFroId = (int)rsp.groupFroInfo.groupFroId;
        this.initMoData(userLabel, auxGroupFroId, context);
        this.initAlarmStatus(alarmStatus, context);
        AuxDeviceGroupMoFactory.instance(49565).createDeviceGroupMoTree((ManagedObject)this, groupFroInfo, "", context);
        this.setCabinetParameters(cabinetParameters, context);
        this.addObservers(49565, context);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(FcuDeviceGroupMoImpl.class, "create() <---");
        ValidateAttributes.checkTransaction(context);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "FcuDeviceGroup");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "FcuDeviceGroup");
        int[] checkedCabinetParameters = ValidateAttributes.checkAndGetIntSeqAttribute(attributes, "cabinetParameters", "optional", FcuDeviceGroupMo.CABINET_PARAMETERS_DEF_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, 50, "FcuDeviceGroup");
        ValidateAttributes.checkOtherAttributes(attributes, "FcuDeviceGroup");
        return new FcuDeviceGroupMoImpl(parent, checkedAlarmStatus, checkedUserLabel, checkedCabinetParameters, identity, context);
    }

    public String getType() {
        return "FcuDeviceGroup";
    }

    public int[] getCabinetParameters(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCabinetParameters() <---");
        EqcGetClimCabinetParamsRspS eqcGetClimCabinetParamsRspS = this.eqcDeviceGroupProxy.getCabinetParameters(0L, this.getTxIdNonTransactional(c));
        int[] cabParamIntVal = new int[eqcGetClimCabinetParamsRspS.cabinetParam.length];
        for (int i = 0; i < eqcGetClimCabinetParamsRspS.cabinetParam.length; ++i) {
            cabParamIntVal[i] = new Long(eqcGetClimCabinetParamsRspS.cabinetParam[i]).intValue();
        }
        return cabParamIntVal;
    }

    public void setCabinetParameters(int[] cabinetParameters, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setCabinetParameters() <---");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (cabinetParameters == null) {
            throw new ParameterValueErrorException();
        }
        if (cabinetParameters.length > 50) {
            throw new ValueOutOfRangeException("cabinetParameters", this.getType());
        }
        this.eqcDeviceGroupProxy.setCabinetParameters(0, cabinetParameters, c.getTransactionID());
    }

    public void setAlarmStatus(int alarmStatusType, Coordinator context) throws MoAccessException, TransactionRequiredException {
        super.setAlarmStatus(alarmStatusType, context);
        MessageLog.traceEnter(this.getClass(), "setAlarmStatus() <---");
    }

    public int getOperationalState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState() <---");
        return super.getOperationalState(context);
    }

    public void actionStartHwTest(String testId, Coordinator context) throws MoAccessException, AlreadyInitiatedException, MoNotLockedException, OperationFailedException, FunctionNotSupportedException, TestBoardDependencyException {
        MessageLog.traceEnter(this.getClass(), "actionStartHwTest() <---");
        super.actionStartHwTest(testId, context);
    }

    private void initMoData(String userLabel, int auxGroupFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() <---");
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterIntAttribute("auxGroupFroId", auxGroupFroId);
        this.getMyMoData().setRevision(3020001);
    }

    public int getNumberOfFanGroups(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNumberOfFanGroups()");
        EqcGetClimCabinetParamsRspS eqcGetClimCabinetParamsRspS = this.eqcDeviceGroupProxy.getCabinetParameters(0L, this.getTxIdNonTransactional(c));
        return eqcGetClimCabinetParamsRspS.numberOfFanGroups;
    }
}

