/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.device;

import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcBdhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetDeviceParametersRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceMo;

public abstract class DeviceMoImpl
extends BoamManagedObjectWithAlarms
implements DeviceMo,
MaoHasFro {
    public static final String DEVICE_FRO_ID = "deviceFroId";
    private static final String USER_LABEL = "userLabel";
    private static final int USER_LABEL_MIN_LENGTH = 0;
    private static final int USER_LABEL_MAX_LENGTH = 128;
    private static int CLIENT_ID = 0;
    protected EqcDeviceProxy eqcDeviceProxy = EqcDeviceProxy.instance();
    protected EqcBdhIndProxy eqcBdhIndProxy = EqcBdhIndProxy.instance();

    public DeviceMoImpl(ManagedObject parent, String thisMoName, int deviceFroId, String identity, Coordinator context, String userlabel) throws MoAccessException {
        super(parent, thisMoName, identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        MessageLog.trace(1, this.getClass(), "Creating DeviceMoImpl ");
        IntegerAttribute tmpIntAttr = new IntegerAttribute(DEVICE_FRO_ID, false);
        tmpIntAttr.setValue(deviceFroId);
        this.myData.registerPersistentAttr((Attribute)tmpIntAttr);
        this.bcmStoreAndRegisterStringAttribute(USER_LABEL, userlabel);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    public DeviceMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()<---");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void sysDelete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sysDelete()");
        if (this.isReserved(context)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.removeObservers(context);
        super.delete(context);
    }

    public void superDelete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "superDelete() Device");
        this.removeObservers(context);
        super.delete(context);
    }

    public String getIdentity(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getIdentity()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), c);
    }

    public int getOperationalState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        EqcGetDeviceParametersRspS rspSig = this.eqcDeviceProxy.getDeviceParameters(this.getTxIdNonTransactional(context), CLIENT_ID, this.getDeviceFroId(context));
        return rspSig.opState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        EqcGetDeviceParametersRspS rspSig = this.eqcDeviceProxy.getDeviceParameters(this.getTxIdNonTransactional(context), CLIENT_ID, this.getDeviceFroId(context));
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.availStatus);
    }

    public int getUsageState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUsageState()");
        EqcGetDeviceParametersRspS rspSig = this.eqcDeviceProxy.getDeviceParameters(this.getTxIdNonTransactional(context), CLIENT_ID, this.getDeviceFroId(context));
        return rspSig.usageState;
    }

    public int getPiuFroId(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPiuFroId()");
        ManagedObject piu = this.getParent().getParent().getParent();
        return BoamHelper.getPlugInUnitFroId(piu, c);
    }

    public int getDeviceFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getDeviceFroId()");
        IntegerAttribute attribute = (IntegerAttribute)this.myData.getAttribute(DEVICE_FRO_ID);
        return attribute.getValue(c);
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.getDeviceFroId(context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.bcmGetStringAttribute(USER_LABEL, context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmSetStringAttribute(USER_LABEL, value, 0, 128, this.getType(), context);
        this.sendAVC(USER_LABEL, value, context);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcBdhIndProxy, froType, this.getFroId(context), context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }
}

