/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.device;

import java.io.File;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.swmanagement.LoadModuleMo;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcProgramProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateProgramRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetProgramParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsLmIdT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AiuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DbDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DpProgramMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ObifDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RaxDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RfifDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RuifDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.StrxDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TrxDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TxDeviceGroupMo;

public class DpProgramMoImpl
extends BoamManagedObject
implements DpProgramMo {
    public static final int DISABLED = 0;
    public static final int ENABLED = 1;
    public static final int DP_PROGRAM_TYPE = 0;
    public static final int MAX_NO_OF_CHILDREN = 2;
    static final String HW_PRODUCT_NUMBER = "productNumber";
    static final String LM_PRODUCT_REVISION = "productRevision";
    static final String HW_PRODUCT_REVISION = "productRevision";
    public static final String DP_PROGRAM_FRO_ID = "dpProgramFroId";
    public static final int MO_DATA_REVISION = 8013601;
    protected MoData myData;
    private EqcProgramProxy eqcProgramProxy = EqcProgramProxy.instance();

    private DpProgramMoImpl(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        super(parent, "DpProgram", identity, context, 2);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        DpProgramMoImpl.checkTransaction(context);
        this.checkParent(parent);
        this.initMoData(attributes, parent, context);
    }

    public DpProgramMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
        MessageLog.trace(1, this.getClass(), "DpProgram MO is Restored ");
        MessageLog.trace(1, this.getClass(), "Version Attribute in MoData = " + this.myData.getRevision());
    }

    public static synchronized DpProgramMoImpl create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(DpProgramMoImpl.class, "create()");
        return new DpProgramMoImpl(parent, attributes, identity, source, c);
    }

    private void checkParent(ManagedObject parent) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkParent()  " + parent);
        if (!(parent instanceof TxDeviceGroupMo || parent instanceof TrxDeviceGroupMo || parent instanceof RaxDeviceGroupMo || parent instanceof RuifDeviceGroupMo || parent instanceof RfifDeviceGroupMo || parent instanceof StrxDeviceGroupMo || parent instanceof AiuDeviceGroupMo || parent instanceof DeviceGroupMo || parent instanceof ObifDeviceGroupMo)) {
            throw new IllegalParentException("Exception received:" + parent.getClass().getName());
        }
    }

    private void initMoData(AttrList attributes, ManagedObject parent, Coordinator context) throws MoAccessException, TransactionRequiredException, AttrMissingAtCreateException, WrongAttributeTypeException, NotHandledAttributeTypeException, ValueOutOfRangeException {
        MessageLog.trace(1, this.getClass(), "initMoData()");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, this.getType());
        int checkedStartState = ValidateAttributes.checkAndGetIntAttribute(attributes, "startState", "optional", 1, 0, 1, this.getType());
        LoadModuleMo checkedLoadModule = this.getCheckedLoadModule(attributes, context);
        int groupFroId = ((DbDeviceGroupMo)parent).getGroupFroId(context);
        PlugInUnitMo piuMo = (PlugInUnitMo)DpProgramMoImpl.getAncestor(this, "PlugInUnit");
        PiuTypeMo piuTypeMoImpl = (PiuTypeMo)piuMo.getPiuType(context);
        Struct loadModuleProductData = checkedLoadModule.getProductData(context);
        Struct piuTypeProductData = piuTypeMoImpl.getProductData(context);
        String oldCompleteFilePath = checkedLoadModule.getLoadModuleFilePath(context);
        String m_lmFileName = this.checkFileName(oldCompleteFilePath);
        String m_lmFilePath = this.checkFilePath(oldCompleteFilePath);
        int m_lmFileSize = this.getFileSize(oldCompleteFilePath);
        String m_lmProductNumber = (String)loadModuleProductData.getValue(HW_PRODUCT_NUMBER);
        String m_lmProductRevision = (String)loadModuleProductData.getValue("productRevision");
        String m_hwProductNumber = (String)piuTypeProductData.getValue(HW_PRODUCT_NUMBER);
        String m_hwProductRevision = (String)piuTypeProductData.getValue("productRevision");
        RbsLmIdT rbsLmId = new RbsLmIdT(m_lmFilePath, m_lmFileName, m_lmFileSize, m_lmProductNumber, m_lmProductRevision, m_hwProductNumber, m_hwProductRevision);
        EqcCreateProgramRspS rspSig = this.eqcProgramProxy.createProgram(this.getTxIdTransactional(context), 0L, groupFroId, checkedStartState, rbsLmId, 0);
        int dpProgramFroId = (int)rspSig.programFroId;
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterIntAttribute(DP_PROGRAM_FRO_ID, dpProgramFroId);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterReferenceAttribute("loadModule", (ManagedObject)checkedLoadModule);
        ValidateAttributes.checkOtherAttributes(attributes, this.getType());
        this.myData.setRevision(8013601);
    }

    private String checkFileName(String str) {
        MessageLog.traceEnter(this.getClass(), " checkFileName() oldFilePath and name from loadModuleMo : " + str);
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return "";
        }
        StringBuffer newStrBuf = new StringBuffer(str);
        StringBuffer reversedStrBuf = newStrBuf.reverse();
        String reversedStr = new String(reversedStrBuf);
        int index = reversedStr.indexOf("/");
        String str1 = reversedStr.substring(0, index);
        StringBuffer newStrBuf1 = new StringBuffer(str1);
        String fileName = new String(newStrBuf1.reverse());
        MessageLog.traceEnter(this.getClass(), " checkFileName returned newFileName to be send to RO : " + fileName);
        return fileName;
    }

    private String checkFilePath(String str) {
        MessageLog.traceEnter(this.getClass(), " checkFilePath() oldFilePath from loadModuleMo : " + str);
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return "";
        }
        StringBuffer newStrBuf = new StringBuffer(str);
        StringBuffer reversedStrBuf = newStrBuf.reverse();
        String reversedStr = new String(reversedStrBuf);
        int index = reversedStr.indexOf("/");
        String str1 = reversedStr.substring(index + 1, reversedStr.length());
        StringBuffer newStrBuf1 = new StringBuffer(str1);
        String filePath = new String(newStrBuf1.reverse());
        MessageLog.traceEnter(this.getClass(), " checkFilePath newFilePath to RO : " + filePath);
        return filePath;
    }

    private int getFileSize(String absoluteFilePathNameString) throws MoAccessException {
        int fileSize = 0;
        try {
            File outFile = new File(absoluteFilePathNameString);
            long theOutFileSize = 0L;
            if (outFile.exists() && outFile.isFile()) {
                theOutFileSize = outFile.length();
            }
            fileSize = new Long(theOutFileSize).intValue();
        }
        catch (RuntimeException e) {
            throw new MoCanNotBeCreatedException("DpProgram, Couldn,t get file size from file system for:" + absoluteFilePathNameString + "du to Exception:" + e);
        }
        MessageLog.trace(2, this.getClass(), " getFileSize(), The loadModule file path:" + absoluteFilePathNameString + ", file size: " + fileSize);
        return fileSize;
    }

    private LoadModuleMo getCheckedLoadModule(AttrList attributes, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkAndSaveLoadModule()");
        int index = attributes.indexOf("loadModule");
        if (index == -1) {
            throw new AttrMissingAtCreateException("loadModule", "DpProgram");
        }
        Object obj = attributes.getValue(index);
        if (!(obj instanceof LoadModuleMo)) {
            throw new WrongAttributeTypeException("loadModule", "DpProgram");
        }
        LoadModuleMo loadModule = (LoadModuleMo)obj;
        if (loadModule.getFileState(context) == 0) {
            throw new ValueOutOfRangeException("DpProgram", "The LM is not installed. LM should be installed before create DpProgram and this should be done by BSM or CPP. LM: " + loadModule.getLocalDistinguishedName());
        }
        attributes.removeElementAt(index);
        return loadModule;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int dpProgramFroId = this.getDpProgramFroId(context);
        this.eqcProgramProxy.deleteProgram(this.getTxIdTransactional(context), 0L, dpProgramFroId);
        this.myData.delete(context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), "DpProgram is Deleted");
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel()");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel()");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public int getStartState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getStartState()");
        int dpProgramFroId = this.getDpProgramFroId(context);
        EqcGetProgramParamRspS cfmSig = this.eqcProgramProxy.getProgramParameters(this.getTxIdNonTransactional(context), 0L, dpProgramFroId);
        return cfmSig.startState;
    }

    public void setStartState(int newStartState, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setStartState()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int dpProgramFroId = this.getDpProgramFroId(context);
        if (newStartState != 0 && newStartState != 1) {
            throw new ValueOutOfRangeException("startState", "DpProgram");
        }
        int currStartState = this.getStartState(context);
        if (newStartState == currStartState && currStartState == 0) {
            MessageLog.trace(2, this.getClass(), " The startState of this DpProgram is already disabled");
        }
        if (newStartState == currStartState && currStartState == 1) {
            MessageLog.trace(2, this.getClass(), " The startState of this DpProgram is already enabled");
        }
        this.eqcProgramProxy.setProgramState(this.getTxIdTransactional(context), 0L, newStartState, dpProgramFroId);
        this.sendAVC("startState", newStartState, context);
    }

    public ManagedObject getLoadModule(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getLoadModule()");
        return this.bcmGetReferenceAttribute("loadModule", context);
    }

    public int getDpProgramFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDpProgramFroId()");
        return this.bcmGetIntAttribute(DP_PROGRAM_FRO_ID, context);
    }

    public String getType() {
        return "DpProgram";
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public String getDpProgramId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDpProgramId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public int getOperationalState(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        int currOperationalState = this.getStartState(c);
        return currOperationalState;
    }

    public void actionStopImmediate(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStopImmediate()");
    }

    public void actionStartImmediate(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStartImmediate()");
    }

    public boolean getIsUpgradePersistent(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getIsUpgradePersistent()");
        boolean checkedAttribute = false;
        return checkedAttribute;
    }

    public void setIsUpgradePersistent(Coordinator context, boolean value) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setIsUpgradePersistent()");
        DpProgramMoImpl.checkTransaction(context);
    }

    public void setIsUpgradePersistent(boolean value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setIsUpgradePersistent()");
        DpProgramMoImpl.checkTransaction(context);
    }
}

