/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.tr;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsGroupFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.common.ErrorMgr;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AscDeviceGroupMo;

public class AscDeviceGroupMoImpl
extends AuxDeviceGroupMoImpl
implements AscDeviceGroupMo {
    public static final int MO_DATA_REVISION = 3020002;

    public AscDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "AscDeviceGroupMoImpl() Recovery constructor");
        ErrorMgr.shotDownIfNull(recoveredData.getAttribute("userLabel"), "userLabel");
        ErrorMgr.shotDownIfNull(recoveredData.getAttribute("auxGroupFroId"), "auxGroupFroId");
        ErrorMgr.shotDownIfNull(recoveredData.getAttribute("alarmStatus"), "alarmStatus");
        try {
            this.addObservers(800004, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    private AscDeviceGroupMoImpl(ManagedObject parent, String userLabel, int checkedAlarmStatus, String identity, Coordinator context) throws MoAccessException {
        super(parent, "AscDeviceGroup", identity, context);
        MessageLog.traceEnter(this.getClass(), "AscDeviceGroupMoImpl()");
        EqcCreateGroupRspS rsp = this.createAuxDeviceGroupResource(parent, 49557, context);
        RbsGroupFroInfoT groupFroInfo = rsp.groupFroInfo;
        int auxGroupFroId = (int)rsp.groupFroInfo.groupFroId;
        this.initMoData(userLabel, auxGroupFroId, context);
        this.initAlarmStatus(checkedAlarmStatus, context);
        AuxDeviceGroupMoFactory.instance(800004).createDeviceGroupMoTree((ManagedObject)this, groupFroInfo, "", context);
        this.addObservers(800004, context);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(AscDeviceGroupMoImpl.class, "create() <---");
        ValidateAttributes.checkTransaction(context);
        ValidateAttributes.checkParent(parent, "AscDeviceGroup", identity);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "AscDeviceGroup");
        int checkedAlarmStatus = AscDeviceGroupMoImpl.checkAndGetAlarmStatus(attributes, 0, "AscDeviceGroup", context);
        ValidateAttributes.checkOtherAttributes(attributes, "AscDeviceGroup");
        return new AscDeviceGroupMoImpl(parent, checkedUserLabel, checkedAlarmStatus, identity, context);
    }

    public String getAscDeviceGroupId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAscDeviceGroupId() <---");
        return this.getIdentity(context);
    }

    public String getType() {
        return "AscDeviceGroup";
    }

    private void initMoData(String userLabel, int auxGroupFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() <---");
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterIntAttribute("auxGroupFroId", auxGroupFroId);
        this.getMyMoData().setRevision(3020002);
    }
}

