/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.iub;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.rmo.iub.IubMoImpl;
import se.ericsson.wcdma.rbs.boam.pms.iface.PmCapableMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScannerAgent;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;

public class IubMoFactory
implements PmCapableMoFactory {
    private static IubMoFactory instance = null;
    private List counterList = new ArrayList();

    private IubMoFactory() {
        MessageLog.traceEnter(this.getClass(), " constructor");
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
        this.setupCounter();
    }

    public static synchronized IubMoFactory instance() {
        if (instance == null) {
            instance = new IubMoFactory();
        }
        return instance;
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMo()");
        ManagedObject mo = IubMoImpl.create(parent, attributes, identity, source, context);
        return mo;
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        IubMoImpl mo = null;
        MessageLog.traceEnter(this.getClass(), "recoverMo()");
        try {
            mo = new IubMoImpl(recoveredData);
            MessageLog.traceEnter(this.getClass(), "Mo Recovered");
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Mo could not be recovered");
        }
        return mo;
    }

    public String getMoTypeName() {
        return "Iub";
    }

    public List getCounters() {
        return this.counterList;
    }

    private void setupCounter() {
        try {
            Counter cnt = new Counter("pmTotalTimeIubLinkCongestedUl", 1, null);
            this.counterList.add(cnt);
            cnt = new Counter("pmNoOfDiscardedMsg", 1, null);
            this.counterList.add(cnt);
            new MoScannerAgent(this.getMoTypeName(), this.counterList);
        }
        catch (PmsException pmse) {
            MessageLog.traceError(this.getClass(), "setupCounter(): Setup counters failed!!", (Throwable)((Object)pmse));
        }
    }

    public static synchronized void _setupCounter_onlyForTest() {
        if (instance != null) {
            MoFactoryMgr.instance().deregister(instance.getMoTypeName());
            instance = null;
        }
    }
}

