/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.node;

import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrNotSettableException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.generic.LicFeatureAdaptor;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcNodeBFunctionProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.RbsLicenseFeatureT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsFeatureMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.RbsLocalCellMoImpl;

public class RbsFeatureMoImpl
extends BoamManagedObjectWithAlarms
implements Reservable,
RbsFeatureMo {
    public static final String LICENSE_KEY = "licenseKey";
    public static final String LICENSE_NAME = "licenseName";
    public static final String FEATURE_FRO_ID = "featureFroId";
    public static final String CELL_NODE_FRO_ID = "cellNodeFroId";
    public static final String INTERNAL_ID = "internalId";
    public static final String HAS_FEATURE_STATE = "hasFeatureState";
    public static final String FEATURE_TYPE = "featureType";
    public static final int MO_DATA_REVISION = 18020700;
    public static final int CLIENT_ID = 0;
    private final ChcNodeBFunctionProxy chcNodeBProxy = ChcNodeBFunctionProxy.instance();

    public RbsFeatureMoImpl(ManagedObject parent, String moTypeName, String identity, RbsLicenseFeatureT licFeature, ManagedObject reservedMo, int featureFroId, Coordinator context) throws MoNameAlreadyTakenException, MoAccessException {
        super(parent, moTypeName, identity, context);
        MessageLog.traceEnter(this.getClass(), "constructor of RbsFeatureMoImpl with: identity " + identity + " licenseKey " + licFeature.licenseKey + " internalId " + licFeature.internalID + " featureType " + licFeature.featureType + " hasFeatureState " + licFeature.hasFeatureState + " ManagedObject " + reservedMo.getLocalDistinguishedName());
        int cellFroId = -1;
        cellFroId = licFeature.featureType == 0 ? -1 : ((RbsLocalCellMoImpl)reservedMo).getCellFroId(context);
        this.initMoData(licFeature, featureFroId, reservedMo, cellFroId, context);
    }

    public RbsFeatureMoImpl(MoData recoveredData) throws MoAccessException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor, RbsFeatureMoImpl()");
        this.myData = recoveredData;
    }

    public MoData getMyMoData() {
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        return true;
    }

    private void initMoData(RbsLicenseFeatureT licFeature, int featureFroId, ManagedObject mo, int cellFroId, Coordinator context) throws MoAccessException {
        MessageLog.trace(1, this.getClass(), "initMoData()");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.myData.setRevision(18020700);
        this.bcmStoreAndRegisterStringAttribute(LICENSE_KEY, licFeature.licenseKey);
        this.bcmStoreAndRegisterStringAttribute(LICENSE_NAME, licFeature.licenseName);
        this.bcmStoreAndRegisterIntAttribute(INTERNAL_ID, licFeature.internalID);
        this.bcmStoreAndRegisterIntAttribute(HAS_FEATURE_STATE, licFeature.hasFeatureState);
        this.bcmStoreAndRegisterIntAttribute(FEATURE_TYPE, licFeature.featureType);
        this.bcmStoreAndRegisterIntAttribute(FEATURE_FRO_ID, featureFroId);
        this.bcmStoreAndRegisterIntAttribute(CELL_NODE_FRO_ID, cellFroId);
        this.reserve(mo, context);
        ((LicFeatureAdaptor)mo).addFeatureRef(this, context);
    }

    public void delete(Coordinator context) throws MoAccessException, MoRemovedException, UndeletableMoException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void sysDelete(Coordinator context) throws MoAccessException, MoRemovedException, UndeletableMoException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        this.chcNodeBProxy.deleteRbsFeatureRo(context.getTransactionID(), 0, this.getInternalId(context), this.getCellFroId(context));
        this.deRegisterMo(context);
    }

    public void deRegisterMo(Coordinator context) throws MoAccessException, MoRemovedException, UndeletableMoException {
        MessageLog.traceEnter(this.getClass(), "deRegisterMo()");
        ManagedObject mo = this.getCellOrNodeReservedby(context);
        this.release(mo, context);
        ((LicFeatureAdaptor)mo).deleteFeatureRef(this, context);
        super.delete(context);
    }

    public String getLicenseKey(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getLicenseKey() ");
        return this.bcmGetStringAttribute(LICENSE_KEY, context);
    }

    public String getLicenseName(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getLicenseName() ");
        return this.bcmGetStringAttribute(LICENSE_NAME, context);
    }

    public int getInternalId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getInternalId() ");
        return this.bcmGetIntAttribute(INTERNAL_ID, context);
    }

    public int getFeatureType(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFeatureType() ");
        return this.bcmGetIntAttribute(FEATURE_TYPE, context);
    }

    public ManagedObject getCellOrNodeReservedby(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCellOrNodeReservedby() ");
        ManagedObject reservedby = null;
        Attribute[] reservedByArray = ((SequenceAttribute)this.myData.getAttribute("persistentReservers")).getValue(context);
        if (reservedByArray != null) {
            reservedby = ((ReferenceAttribute)reservedByArray[0]).getValue(context);
        } else {
            MessageLog.traceError(this.getClass(), "no PERSISTENT_RESERVERS at all");
        }
        return reservedby;
    }

    private int getCellFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCellFroId() ");
        return this.bcmGetIntAttribute(CELL_NODE_FRO_ID, context);
    }

    private int getHasFeatureState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getHasFeatureState() ");
        return this.bcmGetIntAttribute(HAS_FEATURE_STATE, context);
    }

    public int getGenericRbsLicenseState(String attrName, Coordinator context) throws MoAccessException {
        if (attrName.startsWith("licenseState")) {
            return this.getLicenseState(context);
        }
        if (attrName.startsWith("featureState")) {
            return this.getFeatureState(context);
        }
        return -1;
    }

    public RbsLicenseFeatureT getRbsLicFeature(Coordinator context) throws MoAccessException {
        RbsLicenseFeatureT rbsLicFeature = new RbsLicenseFeatureT(this.getInternalId(context), this.getFeatureType(context), this.getLicenseKey(context), this.getLicenseName(context), this.getHasFeatureState(context));
        return rbsLicFeature;
    }

    public int getLicenseState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getLicenseState() " + this.getLicenseName(context));
        return this.chcNodeBProxy.getRbsGenericLicenseState(ValidateAttributes.getTxIdNonTransactional(context), 0, this.getInternalId(context), this.getCellFroId(context));
    }

    public int getFeatureState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFeatureState() " + this.getLicenseName(context));
        return this.chcNodeBProxy.getRbsGenericFeatureState(ValidateAttributes.getTxIdNonTransactional(context), 0, this.getInternalId(context), this.getCellFroId(context));
    }

    public void setFeatureState(String attrName, int featureState, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setFeatureState() " + this.getLicenseName(context));
        if (0 == this.getHasFeatureState(context)) {
            MessageLog.info(this.getClass(), "could not set featurestate since " + this.getLicenseName(context) + " does not has featureState");
            throw new AttrNotSettableException((ManagedObject)this, "could not set featurestate since " + this.getLicenseName(context) + " does not has featureState");
        }
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck(attrName, featureState, 0, 1, "NodeBFunction");
        this.chcNodeBProxy.setRbsGenericFeatureState(ValidateAttributes.getTxIdTransactional(context), 0, this.getInternalId(context), this.getCellFroId(context), featureState);
        ManagedObject[] moArr = this.getReservedBy(context);
        ManagedObject mo = null;
        for (int moIx = 0; moIx < moArr.length; ++moIx) {
            if (moArr[moIx] == null) continue;
            mo = moArr[moIx];
            break;
        }
        this.sendAVC(mo, attrName, new Integer(featureState), context);
    }
}

