/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.pms.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterGroup;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterInOtherScannerException;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.GroupInOtherScannerException;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;
import se.ericsson.wcdma.rbs.boam.pms.impl.RBScanner;

public class CounterScannerAgent {
    private final Counter counter;
    private final Set counterScanners = new HashSet(1);
    private final Set myReserverList = new HashSet(1);
    private final Object lock = new Object();
    private boolean isActive = false;
    private boolean isReserved = false;
    private int reservedGP = -1;

    public CounterScannerAgent(Counter counter) {
        this.counter = counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        MessageLog.trace(3, this.getClass(), "activate(), name: " + this.counter.getName());
        Object object = this.lock;
        synchronized (object) {
            if (this.isActive) {
                MessageLog.trace(3, this.getClass(), "activate(), CounterScannerAgent already active; counter name: " + this.counter.getName());
            } else {
                this.isActive = true;
                Iterator iter = this.counterScanners.iterator();
                while (iter.hasNext()) {
                    CounterScanner cScanner = (CounterScanner)iter.next();
                    cScanner.activate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        MessageLog.trace(3, this.getClass(), "suspend(), name: " + this.counter.getName());
        Object object = this.lock;
        synchronized (object) {
            if (!this.isActive) {
                MessageLog.trace(3, this.getClass(), "suspend(), CounterScannerAgent already inactive; counter name: " + this.counter.getName());
            } else {
                this.isActive = false;
                Iterator iter = this.myReserverList.iterator();
                while (iter.hasNext()) {
                    RBScanner scanner = (RBScanner)((Object)iter.next());
                    if (scanner.isSuspended()) continue;
                    this.isActive = true;
                }
                iter = this.counterScanners.iterator();
                while (iter.hasNext()) {
                    CounterScanner cScanner = (CounterScanner)iter.next();
                    cScanner.suspend();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CounterScanner counterScanner) throws PmsException {
        Object object = this.lock;
        synchronized (object) {
            boolean wasAdded = this.counterScanners.add(counterScanner);
            if (!wasAdded) {
                throw new PmsException("agent: " + this.getCounterName() + ", already registered: " + counterScanner);
            }
            if (this.isReserved) {
                Iterator iter = this.myReserverList.iterator();
                while (iter.hasNext()) {
                    RBScanner reserver = (RBScanner)((Object)iter.next());
                    counterScanner.reserve(reserver);
                }
            }
            if (this.isActive) {
                counterScanner.activate();
            }
        }
    }

    public String getCounterName() {
        return this.counter.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(RBScanner reserver) {
        MessageLog.trace(3, this.getClass(), "release(), name: " + this.counter.getName());
        Object object = this.lock;
        synchronized (object) {
            this.releaseObjects(reserver);
            CounterGroup counterGroup = this.counter.getGroup();
            if (counterGroup != null) {
                counterGroup.release(this);
            }
            this.myReserverList.remove((Object)reserver);
            reserver.removeCounterClass(this);
            if (this.myReserverList.isEmpty()) {
                this.isReserved = false;
                this.isActive = false;
                this.reservedGP = -1;
            }
        }
    }

    private void releaseObjects(RBScanner reserver) {
        MessageLog.trace(3, this.getClass(), "releaseObjects(), counter name: " + this.counter.getName());
        Iterator iter = this.counterScanners.iterator();
        while (iter.hasNext()) {
            CounterScanner cScanner = (CounterScanner)iter.next();
            cScanner.release(reserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CounterScanner obj) throws PmsException {
        Object object = this.lock;
        synchronized (object) {
            boolean wasRemoved = this.counterScanners.remove(obj);
            if (!wasRemoved) {
                throw new PmsException("agent for: " + this.getCounterName() + ", failed to remove: " + obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reserve(RBScanner scanner) throws GroupInOtherScannerException, CounterInOtherScannerException {
        MessageLog.trace(3, this.getClass(), "reserve(), name:" + this.counter.getName());
        Object object = this.lock;
        synchronized (object) {
            int gp = scanner.getGPInMinutes();
            CounterGroup cntG = this.counter.getGroup();
            if (cntG != null) {
                cntG.reserve(this, gp);
            }
            this.checkAndUpdateGP(gp);
            scanner.addCounterClass(this);
            this.isReserved = true;
            if (!this.myReserverList.add(scanner)) {
                String message = "failed to reserve " + this.getCounterName() + ", counter is already reserved by scanner: " + scanner.getName();
                MessageLog.trace(3, this.getClass(), message);
                throw new CounterInOtherScannerException(message);
            }
            this.reserveObjects(scanner);
        }
    }

    private void checkAndUpdateGP(int gp) throws GroupInOtherScannerException {
        if (gp < 0) {
            String message = "negative GP not supported; failed to reserve " + this.getCounterName() + " by scanner with GP=" + gp;
            MessageLog.trace(3, this.getClass(), message);
            throw new GroupInOtherScannerException(message);
        }
        if (this.myReserverList.isEmpty()) {
            this.reservedGP = gp;
        } else if (this.reservedGP != gp) {
            String message = "counter " + this.getCounterName() + " already reserved by other scanner with GP=" + this.reservedGP + ", reserver list size: " + this.myReserverList.size();
            MessageLog.trace(3, this.getClass(), message);
            throw new GroupInOtherScannerException(message);
        }
    }

    private void reserveObjects(RBScanner reserver) {
        MessageLog.trace(3, this.getClass(), "reserveObjects(), name: " + this.counter.getName());
        Iterator iter = this.counterScanners.iterator();
        while (iter.hasNext()) {
            CounterScanner cScanner = (CounterScanner)iter.next();
            cScanner.reserve(reserver);
        }
    }

    public int getGPInMinutes() {
        return this.reservedGP;
    }

    public Set _forTestOnly_getObjecstList() {
        return this.counterScanners;
    }

    public int _forTestOnly_getReserverList() {
        return this.myReserverList.size();
    }

    public boolean _forTestOnly_isActive() {
        return this.isActive;
    }

    public boolean _forTestOnly_isReserved() {
        return this.isReserved;
    }
}

