/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.pms.impl;

import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;

public class ScannedData
implements Cloneable {
    private static final Class SELF = ScannedData.class;
    private final String moLdn;
    private final String counterName;
    private int[] counterValues;

    ScannedData(String counterName, String moLdn, int[] counterValues) throws SoftwareErrorException {
        MessageLog.traceEnter(SELF, "ScannedData()");
        if (counterName == null) {
            MessageLog.traceError(SELF, "counter name is null for ldn: " + moLdn);
            throw new SoftwareErrorException();
        }
        if (counterName.length() == 0) {
            MessageLog.traceError(SELF, "counter name is empty for ldn: " + moLdn);
            throw new SoftwareErrorException();
        }
        this.counterName = counterName;
        this.moLdn = moLdn;
        this.counterValues = counterValues;
    }

    String getMoLdn() {
        return this.moLdn;
    }

    String getCounterName() {
        return this.counterName;
    }

    int[] getCounterValues() {
        return this.counterValues;
    }

    public Object clone() throws CloneNotSupportedException {
        ScannedData newInstance = (ScannedData)super.clone();
        newInstance.counterValues = (int[])newInstance.counterValues.clone();
        return newInstance;
    }
}

