/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.moadd;

import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import se.ericsson.cello.emt.moadd.MoAddConfigImplFactory;
import se.ericsson.cello.emt.moadd.MoAddLog;
import se.ericsson.cello.emt.moadd.MoAddTool;
import se.ericsson.cello.emt.moadd.model.MoAddModel;
import se.ericsson.cello.emt.moadd.model.MoAddModelFactory;
import se.ericsson.cello.emt.moadd.view.MoAddView;
import se.ericsson.cello.emt.moadd.view.MoAddViewFactory;
import se.ericsson.cello.emt.moti.LdnSelectionListener;
import se.ericsson.cello.emt.motools.common.config.ifc.Configuration;
import se.ericsson.cello.emt.motools.common.momodel.ParentMo;
import se.ericsson.cello.emt.motools.common.momodel.ParentMoFactory;
import se.ericsson.cello.emt.motools.common.toolservices.StartFailureException;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServicesFactory;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;

public class MoAddToolImpl
implements MoAddTool {
    private NodeServices nodeServices;
    private Configuration myConfigurationHandler = null;
    private Properties myParameters = null;
    private LauncherInterface launcher;
    private MoAddModel myAddModel;
    private CountDownLatch isInitialized = new CountDownLatch(1);
    private boolean isToolStarted = false;

    public String toString() {
        String name = "";
        name = this.isToolStarted && this.myConfigurationHandler != null ? this.myConfigurationHandler.getManagerTitle() + " - " + this.myConfigurationHandler.getCustomApplName() : "Element Manager - Add MO";
        return name;
    }

    public void exit() {
        this.isInitialized.countDown();
        MoAddLog.logger().log(Level.INFO, "Call the launcher exit method");
        this.myAddModel.exit();
        this.launcher.onExit((Launchable)this);
    }

    public boolean reconnect(String arg0, Properties arg1) {
        return true;
    }

    public void run(String hostname, Properties parameters, LauncherInterface launcher, Launchable parent) {
        MoAddLog.logger().info("MoAdd called with properties: " + parameters == null ? "null" : parameters.toString());
        this.launcher = launcher;
        this.myParameters = parameters;
        MoAddLog.logger().log(Level.INFO, "Creates the Configuration");
        this.myConfigurationHandler = MoAddConfigImplFactory.createConfigurationHandler(this.myParameters);
        MoAddLog.logger().log(Level.INFO, "Creates the ToolServices");
        ToolServices toolServices = ToolServicesFactory.createToolServices(this, launcher, this.myConfigurationHandler);
        try {
            MoAddLog.logger().log(Level.INFO, "Creates the NodeServices");
            this.nodeServices = toolServices.getNodeServices();
        }
        catch (StartFailureException e) {
            MoAddLog.logger().log(Level.SEVERE, "Could not start Node Services");
            MessageDialogFactory.createMessageDialog((String)"Add MO start failure.", (String)"No contact with the node was established.", (Exception)e, (boolean)true, null).setVisible(true);
            this.exit();
        }
        MoAddLog.logger().log(Level.INFO, "Creates the StartMO");
        ParentMo parentMo = ParentMoFactory.createParentMo(this.nodeServices, this.myConfigurationHandler.getLdn());
        MoAddLog.logger().log(Level.INFO, "Creates the MoAddModel");
        this.myAddModel = MoAddModelFactory.createMoAddModel(toolServices, this.myConfigurationHandler, parentMo);
        MoAddLog.logger().log(Level.INFO, "Creates the GUI");
        MoAddView myGUI = MoAddViewFactory.createMoAddView();
        myGUI.setModel(this.myAddModel);
        this.myAddModel.addUiView(myGUI);
        try {
            MoAddLog.logger().log(Level.FINE, "Initializes the GUI");
            myGUI.initialize();
            if (null != myGUI) {
                myGUI.showUI(true);
            }
            this.isToolStarted = true;
        }
        catch (RuntimeException re) {
            MoAddLog.logger().log(Level.SEVERE, "not possible to start Add MO");
            this.myAddModel.getToolServices().exit();
            MessageDialogFactory.createMessageDialog((String)"Not posible to start Add MO.", (Exception)re, (boolean)false, null).setVisible(true);
        }
        this.isInitialized.countDown();
    }

    public void setLdnSelectionListener(LdnSelectionListener listener) {
        try {
            this.isInitialized.await();
        }
        catch (InterruptedException e) {
            MoAddLog.logger().severe("await call was interrupted");
            throw new RuntimeException(e.getMessage());
        }
        this.myAddModel.setLdnSelectionListener(listener);
    }
}

