/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.moproperties;

import java.awt.BorderLayout;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.ericsson.cello.emt.moproperties.LdnMvcContainer;
import se.ericsson.cello.emt.moproperties.LdnMvcContainerEmbedded;
import se.ericsson.cello.emt.moproperties.LdnMvcContainerListener;
import se.ericsson.cello.emt.moproperties.MoPropConfigImplFactory;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.motools.common.config.ifc.Configuration;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServicesFactory;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;
import se.ericsson.cello.nex.DestroyableEmbeddable;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;

public class MoPropertiesEmbeddable
implements DestroyableEmbeddable,
LdnMvcContainerListener {
    private LauncherInterface myLauncher;
    private int myNrOfRunCalls = 0;
    private LdnMvcContainerEmbedded myActiveLdnMvcContainer = null;
    private ToolServices myToolServices = null;
    private NodeServices myNodeServices = null;
    private Configuration myConfigurationHandler = null;
    private Properties myParameters = null;
    private Launchable myNexLaunchable = null;
    private JPanel myComponent = null;
    private String myCurrentLdn = "";
    private volatile String myLastRequestedLdn = "";
    public static final String MO_PROPERTIES_TAB_NAME = "MoProperties";

    public JComponent getComponent() {
        if (null == this.myComponent) {
            this.myComponent = new JPanel();
            this.myComponent.setName(MO_PROPERTIES_TAB_NAME);
            this.myComponent.setLayout(new BorderLayout());
        }
        return this.myComponent;
    }

    public String getName() {
        return "MO Properties";
    }

    public void init(Properties nexProps, Launchable nex, LauncherInterface theLauncher) {
        if (SwingUtilities.isEventDispatchThread()) {
            MoPropLog.logger().fine("event thread in MoPropertiesEmbeddable");
        }
        try {
            ++this.myNrOfRunCalls;
            MoPropLog.logger().log(Level.INFO, "myNrOfRunCalls=" + this.myNrOfRunCalls);
            this.myLauncher = theLauncher;
            this.myParameters = nexProps;
            this.myNexLaunchable = nex;
            this.myConfigurationHandler = MoPropConfigImplFactory.createConfigurationHandler(this.myParameters);
            this.myToolServices = ToolServicesFactory.createToolServices(nex, this.myLauncher, this.myConfigurationHandler, null, null);
            this.myNodeServices = this.myToolServices.getNodeServices();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        if (null != this.myActiveLdnMvcContainer) {
            this.myActiveLdnMvcContainer.destroy();
        }
        this.myComponent.removeAll();
        this.myLauncher = null;
        this.myActiveLdnMvcContainer = null;
        this.myToolServices = null;
        this.myNodeServices = null;
        this.myConfigurationHandler = null;
        this.myParameters = null;
        this.myNexLaunchable = null;
        this.myComponent = null;
        this.myCurrentLdn = null;
        this.myLastRequestedLdn = null;
    }

    public void onLdnMvcContainerExit(LdnMvcContainer aContainer) {
    }

    public void setLDNs(final String[] LDNs) {
        if (0 == LDNs.length) {
            if (null != this.myActiveLdnMvcContainer) {
                this.myActiveLdnMvcContainer.destroy();
            }
            this.myCurrentLdn = "";
            this.myLastRequestedLdn = "";
            return;
        }
        this.myLastRequestedLdn = LDNs[0];
        if (this.myCurrentLdn.equals(LDNs[0])) {
            this.myToolServices.sendEmNotification(GuiTestEventTypes.MO_PROPERTIES_PANEL_UPDATED, "MoPropertiesGui is up to date.No refresh necessary.", null, GuiTestEventTypes.claimSeqNum(), System.currentTimeMillis(), this);
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    MoPropertiesEmbeddable.this.setLdns(LDNs);
                }
            };
            new Thread(runner).start();
        } else {
            this.setLdns(LDNs);
        }
    }

    private void setLdns(String[] LDNs) {
        String ldn = LDNs[0];
        if (null != this.myActiveLdnMvcContainer) {
            this.myActiveLdnMvcContainer.destroy();
        }
        try {
            LdnMvcContainerEmbedded ldnMvcContainer = new LdnMvcContainerEmbedded(ldn, this.myNodeServices, this.myToolServices, this.myConfigurationHandler, this.myNexLaunchable, this.myLauncher, this);
            JComponent comp = ldnMvcContainer.getComponent();
            this.updateThePanel(ldn, ldnMvcContainer, comp);
        }
        catch (RuntimeException re) {
            MessageDialogFactory.createMessageDialog((String)"Display of MO Properties failed.", (Exception)re, (boolean)false, null).setVisible(true);
        }
    }

    private void updateThePanel(final String ldn, final LdnMvcContainerEmbedded ldnMvcContainer, final JComponent comp) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MoPropertiesEmbeddable.this.updateThePanel(ldn, ldnMvcContainer, comp);
                }
            });
        } else if (ldn.equals(this.myLastRequestedLdn) && !ldn.equals(this.myCurrentLdn)) {
            this.myActiveLdnMvcContainer = ldnMvcContainer;
            this.myComponent.removeAll();
            this.myComponent.add(comp);
            this.myActiveLdnMvcContainer.doStart();
            this.myComponent.revalidate();
            this.myCurrentLdn = ldn;
        }
    }
}

