/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.moproperties.model;

import java.util.ArrayList;
import java.util.logging.Level;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.moproperties.model.MoPropertiesModel;
import se.ericsson.cello.emt.moproperties.model.MoPropertiesModelListener;
import se.ericsson.cello.emt.moproperties.view.MoPropertiesView;
import se.ericsson.cello.emt.motools.common.config.ifc.Configuration;
import se.ericsson.cello.emt.motools.common.momodel.MoModel;
import se.ericsson.cello.emt.motools.common.momodel.MoModelImpl;
import se.ericsson.cello.emt.motools.common.toolservices.StartFailureException;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;
import se.ericsson.cello.neal.NodeConnectionEvent;

public class MoPropertiesModelImpl
implements MoPropertiesModel {
    private ToolServices myToolServices = null;
    private MoPropertiesView myView = null;
    private MoModel myMoModel = null;
    private MoPropertiesModelListener myModelListener = null;
    private Configuration myConfiguration = null;
    private String myLdn = "not set yet";

    public MoPropertiesModelImpl(String aLDN, ToolServices ts, Configuration cs, MoPropertiesModelListener aListener) {
        this.myLdn = aLDN;
        this.myToolServices = ts;
        this.myModelListener = aListener;
        this.myConfiguration = cs;
        try {
            ArrayList<String> selectedAttrList = new ArrayList(0);
            String selectedAction = null;
            if (this.myConfiguration != null) {
                selectedAttrList = this.myConfiguration.getSelectedAttrNames();
                selectedAction = this.myConfiguration.getSelectedActionName();
            }
            this.myMoModel = new MoModelImpl(this.myLdn, this.myToolServices.getNodeServices().getNode(), this.myToolServices.getNodeServices().getMimModel(), selectedAttrList, selectedAction);
        }
        catch (StartFailureException e) {
            MoPropLog.logger().log(Level.SEVERE, "Not possible to access NodeServices");
            throw new RuntimeException(e);
        }
    }

    public ToolServices getToolServices() {
        return this.myToolServices;
    }

    public void connectionLost(NodeConnectionEvent arg0) {
        if (this.myView != null) {
            this.myView.nodeConnectionLost();
        }
    }

    public void connectionRestored(NodeConnectionEvent arg0) {
        if (this.myView != null) {
            this.myView.nodeConnectionRestored();
        }
    }

    public void addUiView(MoPropertiesView uiView) {
        this.myView = uiView;
    }

    public String getLDN() {
        return this.myLdn;
    }

    public MoModel getMoModel() {
        return this.myMoModel;
    }

    public void exit() {
        if (this.myModelListener != null) {
            this.myModelListener.onMoPropertiesModelExit();
        }
    }

    public Configuration getConfiguration() {
        return this.myConfiguration;
    }
}

