/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.momodel.typevalue;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.SequenceTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValueDecorator;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValueFactory;
import se.ericsson.cello.mimparser.MoRef;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomCorbaTypeAttribute;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnumRef;
import se.ericsson.cello.mimparser.MomSequence;
import se.ericsson.cello.mimparser.MomStruct;
import se.ericsson.cello.mimparser.MomStructRef;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Struct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceTypeValueImpl
extends TypeValueDecorator
implements SequenceTypeValue {
    protected MomSequence myMomSequence = null;
    protected List<TypeValue> myTypeValueElementList = null;
    protected boolean myElementListIsUpdated = false;
    protected NameValue myWrappedNameValue = super.getNameValue();

    public SequenceTypeValueImpl(TypeValue aDecoratedAttrModel, MomSequence aMomSequence) {
        super(aDecoratedAttrModel);
        this.myMomSequence = aMomSequence;
        if (this.myMomSequence == null) {
            throw new RuntimeException("myMomSequence is null, which is not allowed.");
        }
        this.myTypeValueElementList = this.getElements();
        if (this.myTypeValueElementList == null) {
            throw new RuntimeException("myTypeValueElementList is null, which is not allowed.");
        }
    }

    @Override
    public List<TypeValue> getElements() {
        if (this.myTypeValueElementList != null) {
            return this.myTypeValueElementList;
        }
        this.myTypeValueElementList = new LinkedList<TypeValue>();
        NameValue seqNameValue = this.myWrappedNameValue;
        if (seqNameValue == null) {
            return this.myTypeValueElementList;
        }
        MomEntity elementMomEntity = this.myMomSequence.getType();
        TypeValue newAttrModel = null;
        NameValue[] elementsAsNvArray = this.getElementsAsNameValues();
        if (elementsAsNvArray != null) {
            for (int j = 0; j < elementsAsNvArray.length; ++j) {
                newAttrModel = TypeValueFactory.createTypeValue(elementMomEntity, elementsAsNvArray[j], this.getCmServices());
                this.myTypeValueElementList.add(newAttrModel);
            }
        }
        return this.myTypeValueElementList;
    }

    @Override
    public int getMaxLength() {
        return this.getMomSequence().getMaxLength();
    }

    @Override
    public MomSequence getMomSequence() {
        return this.myMomSequence;
    }

    @Override
    public TypeValue createNewElement() {
        MomEntity elementMomEntity = this.myMomSequence.getType();
        TypeValue newElementAttrModel = TypeValueFactory.createTypeValue(elementMomEntity, null, this.getCmServices());
        this.myTypeValueElementList.add(newElementAttrModel);
        this.myElementListIsUpdated = true;
        return newElementAttrModel;
    }

    @Override
    public void removeElement() {
        int length = this.myTypeValueElementList.size();
        if (length > 0) {
            this.myTypeValueElementList.remove(length - 1);
            this.myElementListIsUpdated = true;
        }
    }

    @Override
    public void removeElement(int elementNo) {
        int length = this.myTypeValueElementList.size();
        if (elementNo > -1 && elementNo < length) {
            this.myTypeValueElementList.remove(elementNo);
            this.myElementListIsUpdated = true;
        } else {
            MoPropLog.logger().info("A try to remove element no. " + elementNo + " in an array of size: " + length);
        }
    }

    @Override
    public int getLength() {
        int s = this.getElements().size();
        return s;
    }

    @Override
    public int getMinLength() {
        return 0;
    }

    @Override
    public TypeValue getElementAt(int n) {
        TypeValue aAttrModel = this.myTypeValueElementList.get(n);
        return aAttrModel;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public boolean isUpdated() {
        if (this.myElementListIsUpdated) {
            return true;
        }
        for (TypeValue anElement : this.myTypeValueElementList) {
            if (!anElement.isUpdated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String setValue(String aValue) {
        throw new RuntimeException("SequenceTypeValue.setValue: remove this func from TypeValue? This should never happen.");
    }

    private void updateWrappedNvFromElementList() {
        MomEntity elementMomEntity = this.myMomSequence.getType();
        String elementXmlType = elementMomEntity.getXmlType();
        if (elementMomEntity instanceof MomEnumRef) {
            int[] intArray = new int[this.myTypeValueElementList.size()];
            for (int i = 0; i < intArray.length; ++i) {
                TypeValue elementTypeValue = this.myTypeValueElementList.get(i);
                NameValue elementNameValue = elementTypeValue.getNameValue();
                if (elementNameValue == null) {
                    throw new RuntimeException("The value of '" + elementTypeValue.getName() + "' is not defined. At least one of the elements are null.");
                }
                intArray[i] = elementNameValue.getIntValue();
            }
            if (this.myWrappedNameValue != null) {
                this.myWrappedNameValue.setIntArrayValue(intArray);
            } else {
                this.myWrappedNameValue = this.getCmServices().getNameValueFactory().create(this.getName(), intArray);
            }
        } else if (elementMomEntity instanceof MomStruct) {
            Struct[] structArray = new Struct[this.myTypeValueElementList.size()];
            for (int i = 0; i < structArray.length; ++i) {
                TypeValue elementTypeValue = this.myTypeValueElementList.get(i);
                NameValue elementNameValue = elementTypeValue.getNameValue();
                structArray[i] = elementNameValue == null ? null : elementNameValue.getStructValue();
            }
            if (this.myWrappedNameValue != null) {
                this.myWrappedNameValue.setStructArrayValue(structArray);
            } else {
                this.myWrappedNameValue = this.getCmServices().getNameValueFactory().create(this.getName(), structArray);
            }
        } else if (elementMomEntity instanceof MomClass) {
            Mo[] moArray = new Mo[this.myTypeValueElementList.size()];
            for (int i = 0; i < moArray.length; ++i) {
                TypeValue elementTypeValue = this.myTypeValueElementList.get(i);
                NameValue elementNameValue = elementTypeValue.getNameValue();
                moArray[i] = elementNameValue == null ? null : elementNameValue.getMoValue();
            }
            if (this.myWrappedNameValue != null) {
                this.myWrappedNameValue.setMoArrayValue(moArray);
            } else {
                this.myWrappedNameValue = this.getCmServices().getNameValueFactory().create(this.getName(), moArray);
            }
        } else if (elementMomEntity instanceof MomCorbaTypeAttribute) {
            MomCorbaTypeAttribute aMomCorbaTypeAttribute = (MomCorbaTypeAttribute)elementMomEntity;
            if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("string") || aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("wstring")) {
                String[] stringArray = new String[this.myTypeValueElementList.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    TypeValue elementTypeValue = this.myTypeValueElementList.get(i);
                    NameValue elementNameValue = elementTypeValue.getNameValue();
                    stringArray[i] = elementNameValue == null ? null : elementNameValue.getStringValue();
                }
                if (this.myWrappedNameValue != null) {
                    this.myWrappedNameValue.setStringArrayValue(stringArray);
                } else {
                    this.myWrappedNameValue = this.getCmServices().getNameValueFactory().create(this.getName(), stringArray);
                }
            } else if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("long")) {
                int[] intArray = new int[this.myTypeValueElementList.size()];
                for (int i = 0; i < intArray.length; ++i) {
                    TypeValue elementTypeValue = this.myTypeValueElementList.get(i);
                    NameValue elementNameValue = elementTypeValue.getNameValue();
                    if (elementNameValue == null) {
                        throw new RuntimeException("The value of '" + this.getName() + "' is not defined. At least one of the elements are null.");
                    }
                    intArray[i] = elementNameValue.getIntValue();
                }
                if (this.myWrappedNameValue != null) {
                    this.myWrappedNameValue.setIntArrayValue(intArray);
                } else {
                    this.myWrappedNameValue = this.getCmServices().getNameValueFactory().create(this.getName(), intArray);
                }
            } else if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("longlong")) {
                long[] longArray = new long[this.myTypeValueElementList.size()];
                for (int i = 0; i < longArray.length; ++i) {
                    TypeValue elementTypeValue = this.myTypeValueElementList.get(i);
                    NameValue elementNameValue = elementTypeValue.getNameValue();
                    if (elementNameValue == null) {
                        throw new RuntimeException("The value of '" + this.getName() + "' is not defined. At least one of the elements are null.");
                    }
                    longArray[i] = elementNameValue.getLongValue();
                }
                if (this.myWrappedNameValue != null) {
                    this.myWrappedNameValue.setLongArrayValue(longArray);
                } else {
                    this.myWrappedNameValue = this.getCmServices().getNameValueFactory().create(this.getName(), longArray);
                }
            } else if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("float") || aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("double")) {
                long[] longArray = new long[this.myTypeValueElementList.size()];
                for (int i = 0; i < longArray.length; ++i) {
                    TypeValue elementTypeValue = this.myTypeValueElementList.get(i);
                    NameValue elementNameValue = elementTypeValue.getNameValue();
                    if (elementNameValue == null) {
                        throw new RuntimeException("The value of '" + this.getName() + "' is not defined. At least one of the elements are null.");
                    }
                    longArray[i] = elementNameValue.getLongValue();
                }
                if (this.myWrappedNameValue != null) {
                    this.myWrappedNameValue.setLongArrayValue(longArray);
                } else {
                    this.myWrappedNameValue = this.getCmServices().getNameValueFactory().create(this.getName(), longArray);
                }
            } else if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("boolean")) {
                boolean[] booleanArray = new boolean[this.myTypeValueElementList.size()];
                for (int i = 0; i < booleanArray.length; ++i) {
                    TypeValue elementTypeValue = this.myTypeValueElementList.get(i);
                    NameValue elementNameValue = elementTypeValue.getNameValue();
                    if (elementNameValue == null) {
                        throw new RuntimeException("The value of '" + this.getName() + "' is not defined. At least one of the elements are null.");
                    }
                    booleanArray[i] = elementNameValue.getBooleanValue();
                }
                if (this.myWrappedNameValue != null) {
                    this.myWrappedNameValue.setBooleanArrayValue(booleanArray);
                } else {
                    this.myWrappedNameValue = this.getCmServices().getNameValueFactory().create(this.getName(), booleanArray);
                }
            }
        } else if (elementMomEntity instanceof MoRef) {
            Mo[] moArray = new Mo[this.myTypeValueElementList.size()];
            for (int i = 0; i < moArray.length; ++i) {
                TypeValue elementTypeValue = this.myTypeValueElementList.get(i);
                NameValue elementNameValue = elementTypeValue.getNameValue();
                moArray[i] = elementNameValue == null ? null : elementNameValue.getMoValue();
            }
            if (this.myWrappedNameValue != null) {
                this.myWrappedNameValue.setMoArrayValue(moArray);
            } else {
                this.myWrappedNameValue = this.getCmServices().getNameValueFactory().create(this.getName(), moArray);
            }
        } else if (elementMomEntity instanceof MomStructRef) {
            Struct[] structArray = new Struct[this.myTypeValueElementList.size()];
            for (int i = 0; i < structArray.length; ++i) {
                TypeValue elementTypeValue = this.myTypeValueElementList.get(i);
                NameValue elementNameValue = elementTypeValue.getNameValue();
                structArray[i] = elementNameValue == null ? null : elementNameValue.getStructValue();
            }
            if (this.myWrappedNameValue != null) {
                this.myWrappedNameValue.setStructArrayValue(structArray);
            } else {
                this.myWrappedNameValue = this.getCmServices().getNameValueFactory().create(this.getName(), structArray);
            }
        } else {
            MoPropLog.logger().log(Level.SEVERE, " the element type <" + elementXmlType + "> is not supported yet.");
            throw new RuntimeException("SequenceTypeValueImpl.updateWrappedNvFromElementList: type not supported yet: " + elementXmlType);
        }
    }

    @Override
    public NameValue getNameValue() {
        if (this.isUpdated()) {
            this.updateWrappedNvFromElementList();
        }
        return this.myWrappedNameValue;
    }

    private NameValue[] getElementsAsNameValues() {
        MomEntity elementMomEntity = this.myMomSequence.getType();
        NameValue[] elementsAsNvArray = null;
        NameValue seqNameValue = this.myWrappedNameValue;
        if (seqNameValue == null) {
            return elementsAsNvArray;
        }
        if (elementMomEntity instanceof MomEnumRef) {
            int[] elementsIntArray = seqNameValue.getIntArrayValue();
            if (elementsIntArray == null) {
                return elementsAsNvArray;
            }
            elementsAsNvArray = new NameValue[elementsIntArray.length];
            for (int i = 0; i < elementsIntArray.length; ++i) {
                NameValue elementAsNameValue = null;
                elementsAsNvArray[i] = elementAsNameValue = this.getCmServices().getNameValueFactory().create("", elementsIntArray[i]);
            }
        } else if (elementMomEntity instanceof MomStruct) {
            Struct[] elementsStructArray = seqNameValue.getStructArrayValue();
            if (elementsStructArray == null) {
                return elementsAsNvArray;
            }
            elementsAsNvArray = new NameValue[elementsStructArray.length];
            for (int i = 0; i < elementsStructArray.length; ++i) {
                NameValue elementAsNameValue = null;
                if (elementsStructArray[i] != null) {
                    elementAsNameValue = this.getCmServices().getNameValueFactory().create("", elementsStructArray[i]);
                }
                elementsAsNvArray[i] = elementAsNameValue;
            }
        } else if (elementMomEntity instanceof MomClass) {
            Mo[] elementsMoArray = seqNameValue.getMoArrayValue();
            if (elementsMoArray == null) {
                return elementsAsNvArray;
            }
            elementsAsNvArray = new NameValue[elementsMoArray.length];
            for (int i = 0; i < elementsMoArray.length; ++i) {
                NameValue elementAsNameValue = null;
                if (elementsMoArray[i] != null) {
                    elementAsNameValue = this.getCmServices().getNameValueFactory().create("", elementsMoArray[i]);
                }
                elementsAsNvArray[i] = elementAsNameValue;
            }
        } else if (elementMomEntity instanceof MomCorbaTypeAttribute) {
            MomCorbaTypeAttribute aMomCorbaTypeAttribute = (MomCorbaTypeAttribute)elementMomEntity;
            if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("string") || aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("wstring")) {
                String[] elementsStringArray = seqNameValue.getStringArrayValue();
                if (elementsStringArray == null) {
                    return elementsAsNvArray;
                }
                elementsAsNvArray = new NameValue[elementsStringArray.length];
                for (int i = 0; i < elementsStringArray.length; ++i) {
                    NameValue elementAsNameValue = null;
                    if (elementsStringArray[i] != null) {
                        elementAsNameValue = this.getCmServices().getNameValueFactory().create("", elementsStringArray[i]);
                    }
                    elementsAsNvArray[i] = elementAsNameValue;
                }
            } else if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("long")) {
                int[] elementsIntArray = seqNameValue.getIntArrayValue();
                if (elementsIntArray == null) {
                    return elementsAsNvArray;
                }
                elementsAsNvArray = new NameValue[elementsIntArray.length];
                for (int i = 0; i < elementsIntArray.length; ++i) {
                    NameValue elementAsNameValue = null;
                    elementsAsNvArray[i] = elementAsNameValue = this.getCmServices().getNameValueFactory().create("", elementsIntArray[i]);
                }
            } else if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("longlong")) {
                long[] elementsLongArray = seqNameValue.getLongArrayValue();
                if (elementsLongArray == null) {
                    return elementsAsNvArray;
                }
                elementsAsNvArray = new NameValue[elementsLongArray.length];
                for (int i = 0; i < elementsLongArray.length; ++i) {
                    NameValue elementAsNameValue = null;
                    elementsAsNvArray[i] = elementAsNameValue = this.getCmServices().getNameValueFactory().create("", elementsLongArray[i]);
                }
            } else if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("float") || aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("double")) {
                float[] elementsFloatArray = seqNameValue.getFloatArrayValue();
                if (elementsFloatArray == null) {
                    return elementsAsNvArray;
                }
                elementsAsNvArray = new NameValue[elementsFloatArray.length];
                for (int i = 0; i < elementsFloatArray.length; ++i) {
                    NameValue elementAsNameValue = null;
                    elementsAsNvArray[i] = elementAsNameValue = this.getCmServices().getNameValueFactory().create("", elementsFloatArray[i]);
                }
            } else if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("boolean")) {
                boolean[] elementsBooleanArray = seqNameValue.getBooleanArrayValue();
                if (elementsBooleanArray == null) {
                    return elementsAsNvArray;
                }
                elementsAsNvArray = new NameValue[elementsBooleanArray.length];
                for (int i = 0; i < elementsBooleanArray.length; ++i) {
                    NameValue elementAsNameValue = null;
                    elementsAsNvArray[i] = elementAsNameValue = this.getCmServices().getNameValueFactory().create("", elementsBooleanArray[i]);
                }
            }
        } else if (elementMomEntity instanceof MoRef) {
            Mo[] elementsMoArray = seqNameValue.getMoArrayValue();
            if (elementsMoArray == null) {
                return elementsAsNvArray;
            }
            elementsAsNvArray = new NameValue[elementsMoArray.length];
            for (int i = 0; i < elementsMoArray.length; ++i) {
                NameValue elementAsNameValue = null;
                if (elementsMoArray[i] != null) {
                    elementAsNameValue = this.getCmServices().getNameValueFactory().create("", elementsMoArray[i]);
                }
                elementsAsNvArray[i] = elementAsNameValue;
            }
        } else if (elementMomEntity instanceof MomStructRef) {
            Struct[] elementsStructArray = seqNameValue.getStructArrayValue();
            if (elementsStructArray == null) {
                return elementsAsNvArray;
            }
            elementsAsNvArray = new NameValue[elementsStructArray.length];
            for (int i = 0; i < elementsStructArray.length; ++i) {
                NameValue elementAsNameValue = null;
                if (elementsStructArray[i] != null) {
                    elementAsNameValue = this.getCmServices().getNameValueFactory().create("", elementsStructArray[i]);
                }
                elementsAsNvArray[i] = elementAsNameValue;
            }
        } else {
            MoPropLog.logger().log(Level.SEVERE, " the element type <" + elementMomEntity.getXmlType() + "> is not supported yet.");
            throw new RuntimeException("SequenceTypeValueImpl.getElementsAsNameValues: the type <" + elementMomEntity.getXmlType() + "> is not supported yet.");
        }
        return elementsAsNvArray;
    }

    @Override
    public String getMomXmlType() {
        return this.myMomSequence.getXmlType();
    }

    @Override
    public boolean isValueDefined() {
        return this.myWrappedNameValue != null;
    }
}

