/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.toolservices;

import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.moti.LdnSelector;
import se.ericsson.cello.emt.motools.common.config.ifc.Configuration;
import se.ericsson.cello.emt.motools.common.toolservices.StartFailureException;
import se.ericsson.cello.emt.motools.common.toolservices.Tool;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.userpreferences.UserPreferencesI;
import se.ericsson.cello.emt.utils.launchhandler.LaunchHandler;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.emnotification.EmEventInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationServiceInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolServicesImpl
implements ToolServices {
    private LauncherInterface myLauncher;
    private Launchable myParentLaunchable;
    private Configuration myConfiguration;
    private String myHostName;
    private NodeServices myNodeServices = null;
    private UserPreferencesI myPreferenceService = null;
    private static final int LAUNCH_NODESERVICES_TIMEOUT = 1800;
    private static final int LAUNCH_USERPREFERENCE_TIMEOUT = 10;
    private static final String LDNs = "LDNs";
    private static final String MOCLASS = "MOCLASS";

    public ToolServicesImpl(Launchable parent, LauncherInterface launcher, Configuration parameterHandler) {
        this.myParentLaunchable = parent;
        this.myLauncher = launcher;
        this.myConfiguration = parameterHandler;
        this.myHostName = parameterHandler.getAddress();
        this.myNodeServices = null;
        MoPropLog.logger().log(Level.INFO, "");
    }

    public ToolServicesImpl(Launchable parent, LauncherInterface launcher, Configuration parameterHandler, NodeServices aNodeServices, UserPreferencesI aUserPrefService) {
        this(parent, launcher, parameterHandler);
        this.myNodeServices = aNodeServices;
        this.myPreferenceService = aUserPrefService;
    }

    @Override
    public List<String> getHyperToolNames() {
        MoPropLog.logger().log(Level.INFO, "");
        LinkedList<String> toolNameList = new LinkedList<String>();
        List<Tool> hyperToolList = this.myConfiguration.getHyperTools();
        for (Tool tool : hyperToolList) {
            toolNameList.add(tool.getName());
        }
        return toolNameList;
    }

    @Override
    public LdnSelector startMoSearchTool(String aStartPointLdn, String moClassToSearchFor) throws StartFailureException {
        LdnSelector moSearchLaunchable;
        Tool moSearchTool;
        MoPropLog.logger().log(Level.INFO, "");
        Properties props = this.myConfiguration.getSupersedingProperties();
        if (aStartPointLdn != null) {
            props.setProperty(LDNs, aStartPointLdn);
        }
        if (moClassToSearchFor != null) {
            props.setProperty(MOCLASS, moClassToSearchFor);
        }
        String port = this.myConfiguration.getPort();
        if (!props.containsKey("httpPort") && port != null) {
            props.setProperty("httpPort", port);
        }
        if ((moSearchTool = this.myConfiguration.getMoSearchTool()) == null) {
            MoPropLog.logger().log(Level.INFO, "The hyper tool to start, MoSearch, was not found in the configuration.");
            throw new StartFailureException("The Search MO tool is not properly defined.");
        }
        try {
            Launchable launchedTool = LaunchHandler.getTool((LauncherInterface)this.myLauncher, (String)moSearchTool.getConfigFile(), (String)this.myHostName, (Properties)props, (Launchable)this.myParentLaunchable);
            MoPropLog.logger().log(Level.INFO, " after LaunchHandler.getTool(...).");
            moSearchLaunchable = (LdnSelector)launchedTool;
        }
        catch (Exception e) {
            MoPropLog.logger().warning("Launch Search MO Error. " + e.getMessage());
            throw new StartFailureException(e);
        }
        return moSearchLaunchable;
    }

    @Override
    public NodeServices getNodeServices() throws StartFailureException {
        MoPropLog.logger().log(Level.INFO, "");
        if (this.myNodeServices == null) {
            try {
                Tool nodeServTool = this.myConfiguration.getNodeServicesTool();
                Properties props = this.myConfiguration.getSupersedingProperties();
                this.myNodeServices = (NodeServices)LaunchHandler.getToolAsResource((LauncherInterface)this.myLauncher, (String)nodeServTool.getConfigFile(), (String)this.myHostName, (Properties)props, (Launchable)this.myParentLaunchable, (long)1800L);
                MoPropLog.logger().log(Level.INFO, "Success launching NodeServices. Test: Root Mo=" + this.myNodeServices.getNode().getCmService().getRootMo().getLdn());
            }
            catch (Exception e) {
                MoPropLog.logger().warning("Launch NodeServices Error. " + e.getMessage());
                throw new StartFailureException(e);
            }
        }
        return this.myNodeServices;
    }

    @Override
    public UserPreferencesI getUserPreferenceServices() throws StartFailureException {
        MoPropLog.logger().log(Level.INFO, "");
        if (null == this.myPreferenceService) {
            MoPropLog.logger().log(Level.INFO, "myPreferenceService was null. Will fetch one.");
            try {
                Tool prefServTool = this.myConfiguration.getUserPreferenceTool();
                Properties props = this.myConfiguration.getSupersedingProperties();
                this.myPreferenceService = (UserPreferencesI)LaunchHandler.getToolAsResource((LauncherInterface)this.myLauncher, (String)prefServTool.getConfigFile(), (String)this.myHostName, (Properties)props, (Launchable)this.myParentLaunchable, (long)10L);
                MoPropLog.logger().log(Level.INFO, "Success launching UserPreferenceServices. testing:" + this.myPreferenceService.getPreference("testing", "testvalue"));
            }
            catch (Exception e) {
                MoPropLog.logger().warning("Launch UserPreferenceServices Error:" + e.getClass() + "    Message:" + e.getMessage());
                throw new StartFailureException(e);
            }
        }
        return this.myPreferenceService;
    }

    @Override
    public void startHyperTool(String hyperToolName, String aLdn) throws StartFailureException {
        MoPropLog.logger().log(Level.INFO, "");
        Properties props = this.myConfiguration.getSupersedingProperties();
        if (aLdn != null) {
            props.setProperty(LDNs, aLdn);
        }
        List<Tool> hyperToolList = this.myConfiguration.getHyperTools();
        for (Tool hyperTool : hyperToolList) {
            if (!hyperTool.getName().equals(hyperToolName)) continue;
            MoPropLog.logger().log(Level.INFO, " before LaunchHandler.launchTool(...). hyperTool.getConfigFile()=" + hyperTool.getConfigFile());
            LaunchHandler.launchTool((LauncherInterface)this.myLauncher, (String)hyperTool.getConfigFile(), (String)this.myHostName, (Properties)props, (Launchable)this.myParentLaunchable);
            MoPropLog.logger().log(Level.INFO, " after LaunchHandler.launchTool(...).");
            return;
        }
        MoPropLog.logger().log(Level.INFO, "The hyper tool to start was not found in the configuration.");
        throw new StartFailureException("The tool " + hyperToolName + " is not defined as a hyper tool.");
    }

    @Override
    public void startHyperTool(String hyperToolName, Properties aProps) throws StartFailureException {
        Properties props = aProps;
        List<Tool> hyperToolList = this.myConfiguration.getHyperTools();
        for (Tool hyperTool : hyperToolList) {
            if (!hyperTool.getName().equals(hyperToolName)) continue;
            LaunchHandler.launchTool((LauncherInterface)this.myLauncher, (String)hyperTool.getConfigFile(), (String)this.myHostName, (Properties)props, (Launchable)this.myParentLaunchable);
            return;
        }
        MoPropLog.logger().log(Level.INFO, "The hyper tool to start was not found in the configuration.");
        throw new StartFailureException("The tool " + hyperToolName + " is not defined as a hyper tool.");
    }

    @Override
    public void runHelp(String docTitle, String sectionTag) {
        Properties props = this.myConfiguration.getSupersedingProperties();
        props.setProperty("DOC_TITLE", docTitle);
        props.setProperty("SECTION_TAG", sectionTag);
        LaunchHandler.launchToolAsResource((LauncherInterface)this.myLauncher, (String)this.myConfiguration.getHelpApplication(), (String)this.myHostName, (Properties)props, (Launchable)this.myParentLaunchable);
    }

    @Override
    public void exit() {
        this.myParentLaunchable.exit();
    }

    @Override
    public void sendEmNotification(final String type, final String message, final Object userObject, final long sequenceNumber, final long timestamp, final Object source) {
        if (this.myLauncher instanceof EmNotificationServiceInterface) {
            ((EmNotificationServiceInterface)this.myLauncher).sendNotification(new EmEventInterface(){
                private static final long serialVersionUID = 0L;

                public String getMessage() {
                    return message;
                }

                public long getSequenceNumber() {
                    return sequenceNumber;
                }

                public long getTimestamp() {
                    return timestamp;
                }

                public String getType() {
                    return type;
                }

                public Object getUserData() {
                    return userObject;
                }

                public Object getSource() {
                    return source;
                }
            });
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.myConfiguration;
    }
}

