/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pkimgmt.proxy;

import enea.ose.system.AttachSignal;
import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import java.security.cert.X509Certificate;
import se.ericsson.cello.pkimgmt.PkiClientException;
import se.ericsson.cello.pkimgmt.proxy.CppPkijiGetRevocStatusCfm;
import se.ericsson.cello.pkimgmt.proxy.CppPkijiGetRevocStatusReq;
import se.ericsson.cello.pkimgmt.proxy.CppPkijiInitiateServiceCfm;
import se.ericsson.cello.pkimgmt.proxy.CppPkijiInitiateServiceRej;
import se.ericsson.cello.pkimgmt.proxy.CppPkijiInitiateServiceReq;
import se.ericsson.cello.pkimgmt.proxy.CppPkijiInitiateServiceSus;
import se.ericsson.cello.pkimgmt.proxy.CppPkijiNotifySubscribeCfm;
import se.ericsson.cello.pkimgmt.proxy.CppPkijiNotifySubscribeReq;
import se.ericsson.cello.pkimgmt.proxy.CppPkijiTerminateServiceCfm;
import se.ericsson.cello.pkimgmt.proxy.CppPkijiTerminateServiceReq;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SignalObserver;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.cello.support.sigutil.SubscriptionObserver;

public class PkimgmtProxy
implements SubscriptionObserver,
SignalObserver {
    private static PkimgmtProxy instance;
    private int protocolVersion = 0;
    private SignalPort signalPort = PortManager.instance();
    private int signalRevision = 1;
    private static OseProcess op;
    private static final int MAX_NO_OF_RETRIES = 5;
    private static final String SERVICE_NAME = "CPPSEC_PKIMGMT_SERVICE_NAME";
    private static final int PV_FIRST = 6;
    private static final int PV_SECOND = 6;
    private static final int PV_THIRD = 6;
    private static final int CPPSEC_PKIJI_OK = 0;
    private static final int CPPSEC_PKIJI_NOK = 1;
    private static final int CPPSEC_PKIJI_TC_NOK = 2;
    private static final int CPPSEC_PKIJI_DK = 3;
    private static final int CPPSEC_PKIJI_INVALID_PV = 101;
    private static final int CPPSEC_PKIJI_MAX_NO_OF_CLIENTS_REACHED = 102;
    private static final int CPPSEC_PKIJI_SERVICE_NOT_INITIATED = 103;
    private static final int CPPSEC_PKIJI_SERVICE_ALREADY_INITIATED = 104;
    private static final int CPPSEC_PKIJI_NO_MEMORY = 105;
    private static final int CPPSEC_PKIJI_INTERNAL_ERR = 106;
    private static final int TRACEGROUP = 6;
    private static final int CPPSEC_PKIJI_MGMTIF_REVOC_SERVICE = 4;
    private static final int RECEIVE_TIMEOUT = 15000;

    public void serviceAdded(String string) {
        MessageLog.info(this.getClass(), (String)"serviceAdded = CPPSEC_PKIMGMT_SERVICE_NAME");
        if (op != null && this.protocolVersion != 0) {
            MessageLog.trace((int)6, this.getClass(), (String)"init() PKIJI already called.");
            return;
        }
        if (this.init()) {
            MessageLog.trace((int)6, this.getClass(), (String)"init() PKIJI called successfully.");
        } else {
            MessageLog.trace((int)6, this.getClass(), (String)"init() PKIJI returned false.");
        }
    }

    public void serviceRemoved(String string) {
        block1: {
            MessageLog.info(this.getClass(), (String)"serviceRemoved: CPPSEC_PKIMGMT_SERVICE_NAME");
            if (op != null) {
                if (!op.equals((Object)OseNameServer.lookup((String)SERVICE_NAME))) break block1;
            }
        }
        op = null;
        this.protocolVersion = 0;
    }

    public void signalReceived(InSignal inSignal) {
        MessageLog.trace((int)6, this.getClass(), (String)("signalReceived: " + inSignal.getClass()));
        if (inSignal.getClass().equals(CppPkijiNotifySubscribeCfm.class)) {
            MessageLog.info(this.getClass(), (String)"Service successfully subscribed");
        } else {
            MessageLog.info(this.getClass(), (String)("Received unknown signal: " + inSignal.getClass()));
        }
    }

    public static PkimgmtProxy instance() {
        if (instance == null) {
            instance = new PkimgmtProxy();
        }
        return instance;
    }

    private PkimgmtProxy() {
        this.signalPort.addSignalObserver((SignalObserver)this, CppPkijiNotifySubscribeCfm.class);
        OseNameServer.addSubscriptionObserver((String)SERVICE_NAME, (SubscriptionObserver)this);
    }

    public synchronized boolean checkOp() {
        if (op != null && this.protocolVersion != 0) {
            return true;
        }
        boolean bl = this.init();
        MessageLog.trace((int)6, this.getClass(), (String)("Op needs to be checked, init returned " + bl));
        for (int i = 0; !bl && i < 5; ++i) {
            try {
                Thread.sleep(15000L);
                bl = this.init();
                continue;
            }
            catch (InterruptedException interruptedException) {
                MessageLog.info(this.getClass(), (String)("InterruptedException: " + interruptedException.getMessage()));
            }
        }
        return bl;
    }

    private synchronized boolean init() {
        boolean bl = true;
        OseProcess oseProcess = null;
        oseProcess = OseNameServer.lookup((String)SERVICE_NAME);
        op = oseProcess;
        MessageLog.info(this.getClass(), (String)("In init(), op = : " + op));
        if (oseProcess == null) {
            MessageLog.info(this.getClass(), (String)"init(), op == null");
            bl = false;
        } else {
            if (this.protocolVersion != 0) {
                bl = this.sendCppPkijiTerminateServiceReq();
            }
            if (bl) {
                bl = this.sendCppPkijiInitiateServiceReq();
            }
            if (bl) {
                this.sendCppPkijiNotifySubscribeReq();
            }
        }
        return bl;
    }

    protected boolean sendCppPkijiInitiateServiceReq() {
        boolean bl = true;
        CppPkijiInitiateServiceReq cppPkijiInitiateServiceReq = new CppPkijiInitiateServiceReq(6, 6, 6, 4);
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)cppPkijiInitiateServiceReq, (Class)CppPkijiInitiateServiceCfm.class, (int)15000);
        if (signal == null) {
            MessageLog.info(this.getClass(), (String)" sendCppPkijiInitiateServiceReq(). No response signal, rspSig == null.");
            return false;
        }
        if (signal instanceof CppPkijiInitiateServiceCfm) {
            MessageLog.info(this.getClass(), (String)(" sendCppPkijiInitiateServiceReq() confirmed, pv = : " + ((CppPkijiInitiateServiceCfm)signal).getSelectedPV()));
            this.protocolVersion = ((CppPkijiInitiateServiceCfm)signal).getSelectedPV();
            this.signalRevision = ((CppPkijiInitiateServiceCfm)signal).getSignalRevision();
            if (this.protocolVersion != 6 && this.protocolVersion != 6 && this.protocolVersion != 6) {
                bl = false;
                MessageLog.info(this.getClass(), (String)(" sendCppPkijiInitiateServiceReq() failed, received PV = : " + ((CppPkijiInitiateServiceCfm)signal).getSelectedPV() + ", preferred PV = : " + this.protocolVersion));
            } else {
                MessageLog.info(this.getClass(), (String)("Successfully Initialized with pv " + this.protocolVersion));
            }
        } else if (signal instanceof CppPkijiInitiateServiceRej) {
            bl = false;
            MessageLog.info(this.getClass(), (String)(" sendCppPkijiInitiateServiceReq(), Rejeceted with code: " + ((CppPkijiInitiateServiceRej)signal).getResult()));
        } else if (signal instanceof CppPkijiInitiateServiceSus) {
            bl = false;
            MessageLog.info(this.getClass(), (String)(" sendCppPkijiInitiateServiceReq(), Suspended: Highest availibe PV: " + ((CppPkijiInitiateServiceSus)signal).getHighestAvailablePV()));
        } else if (signal instanceof AttachSignal) {
            bl = false;
            MessageLog.info(this.getClass(), (String)" sendCppPkijiInitiateServiceReq(), receiver process terminated: CPPSEC_PKIMGMT_SERVICE_NAME");
        } else {
            MessageLog.info(this.getClass(), (String)(" sendCppPkijiInitiateServiceReq(), received rspSig:  " + signal.getClass()));
            bl = false;
        }
        return bl;
    }

    public boolean sendCppPkijiTerminateServiceReq() {
        CppPkijiTerminateServiceCfm cppPkijiTerminateServiceCfm = null;
        CppPkijiTerminateServiceReq cppPkijiTerminateServiceReq = null;
        if (op == null || this.protocolVersion == 0) {
            return true;
        }
        cppPkijiTerminateServiceReq = new CppPkijiTerminateServiceReq();
        cppPkijiTerminateServiceCfm = (CppPkijiTerminateServiceCfm)SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)cppPkijiTerminateServiceReq, (Class)CppPkijiTerminateServiceCfm.class, (int)15000);
        if (cppPkijiTerminateServiceCfm == null) {
            MessageLog.info(this.getClass(), (String)" sendCppPkijiTerminateServiceReq(). No response signal, rspSig == null");
            return false;
        }
        if (cppPkijiTerminateServiceCfm instanceof CppPkijiTerminateServiceCfm) {
            MessageLog.trace((int)6, this.getClass(), (String)" sendCppPkijiTerminateServiceReq(), received CppPkijiTerminateServiceCfm");
            return true;
        }
        if (cppPkijiTerminateServiceCfm instanceof AttachSignal) {
            MessageLog.info(this.getClass(), (String)"receiver process terminated: CPPSEC_PKIMGMT_SERVICE_NAME");
        } else {
            MessageLog.info(this.getClass(), (String)(" sendCppPkijiTerminateServiceReq(), received rspSig:  " + ((Object)((Object)cppPkijiTerminateServiceCfm)).getClass()));
        }
        return false;
    }

    public void sendCppPkijiNotifySubscribeReq() {
        CppPkijiNotifySubscribeReq cppPkijiNotifySubscribeReq = new CppPkijiNotifySubscribeReq();
        OseProcess oseProcess = this.signalPort.getOseProcess();
        SignalHelper.sendWithSender((OseProcess)op, (OseProcess)oseProcess, (Signal)cppPkijiNotifySubscribeReq);
    }

    public synchronized int getRevocStatus(X509Certificate[] x509CertificateArray, X509Certificate x509Certificate, int n) throws PkiClientException {
        CppPkijiGetRevocStatusReq cppPkijiGetRevocStatusReq = null;
        CppPkijiGetRevocStatusCfm cppPkijiGetRevocStatusCfm = null;
        cppPkijiGetRevocStatusReq = new CppPkijiGetRevocStatusReq(x509CertificateArray, x509Certificate, n);
        if (this.checkOp()) {
            cppPkijiGetRevocStatusCfm = (CppPkijiGetRevocStatusCfm)SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)cppPkijiGetRevocStatusReq, (Class)CppPkijiGetRevocStatusCfm.class, (int)15000);
        }
        if (cppPkijiGetRevocStatusCfm == null) {
            throw new PkiClientException("PKIJI not accessible!", 10);
        }
        if (cppPkijiGetRevocStatusCfm instanceof CppPkijiGetRevocStatusCfm) {
            if (((CppPkijiGetRevocStatusCfm)cppPkijiGetRevocStatusCfm).getResult() == 1 || cppPkijiGetRevocStatusCfm.getResult() == 2) {
                MessageLog.info(this.getClass(), (String)(" Certificate is on CRL list. " + cppPkijiGetRevocStatusCfm.getErrMsg()));
            }
            return cppPkijiGetRevocStatusCfm.getResult();
        }
        if (cppPkijiGetRevocStatusCfm instanceof AttachSignal) {
            throw new PkiClientException("receiver process terminated: CPPSEC_PKIMGMT_SERVICE_NAME", 11);
        }
        throw new PkiClientException("Unknown response received!", 12);
    }

    static {
        op = null;
    }
}

