/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.commandlog;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jacorb.transport.iiop.Current;
import org.jacorb.transport.iiop.CurrentHelper;
import org.omg.CORBA.Object;
import se.ericsson.cello.commandlog.ObjectHelper;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.util.ExceptionHelper;

public abstract class CMD {
    protected StringBuffer data = null;
    private String userName = null;
    protected String cmdName = null;
    protected String remoteIP = null;
    protected static final String EXCEPTIONTAG = "exception";
    protected static final String MOTAG = "mo";
    protected static final String NROFPARAMTAG = "nrOfParameters";
    String exception = null;

    public CMD(String string, String string2, String string3) {
        this.cmdName = string;
        this.exception = this.removeSpecialCharacters(string3);
        this.data = new StringBuffer();
        this.userName = string2 != null ? string2 : "Unknown";
        this.remoteIP = this.getRemoteIP();
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM d yyyy',' HH:mm:ss");
        this.data.append("<Request>\n");
        this.data.append("// " + this.userName + " " + simpleDateFormat.format(date) + "\n");
        this.data.append(string);
    }

    String getCMDName() {
        return this.cmdName;
    }

    public abstract String toString();

    protected void addBeginTag() {
        this.data.append("\n(");
    }

    protected void addEndTag() {
        this.data.append("\n)\n");
    }

    protected void handleContainedArray(java.lang.Object[] objectArray) {
        if (objectArray == null) {
            this.data.append(" ");
        } else if (this.cmdName.equals("ACTION")) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof java.lang.Object[]) {
                    java.lang.Object[] objectArray2 = (java.lang.Object[])objectArray[i];
                    this.data.append("\n\tArray " + ObjectHelper.getObjectByType(objectArray2) + " " + Integer.toString(objectArray2.length));
                    for (int j = 0; j < objectArray2.length; ++j) {
                        if (objectArray2[j] instanceof Struct) {
                            this.handleStructInArray((Struct)objectArray2[j]);
                            continue;
                        }
                        this.handleAllObjects(objectArray2[j], false);
                    }
                    continue;
                }
                this.handleAllObjects(objectArray[i], false);
            }
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof Struct) {
                    this.handleStructInArray((Struct)objectArray[i]);
                    continue;
                }
                this.data.append("\n\t\t" + ObjectHelper.getObjectValue(objectArray[i]));
            }
        }
    }

    protected void addAttributes(AttrList attrList) {
        if (attrList == null) {
            this.data.append(" ");
        } else {
            int n = attrList.size();
            java.lang.Object[] objectArray = null;
            java.lang.Object object = null;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                this.data.append("\n " + attrList.getName(i) + " ");
                try {
                    object = attrList.getValue(i);
                }
                catch (MoNotFoundException moNotFoundException) {
                    object = new ManagedObjectDeleted();
                    MessageLog.info(this.getClass(), (String)"The CORBA AuditTrailLog could not store the correct LDN because the MO in question has already been deleted.");
                }
                catch (MoAccessException moAccessException) {
                    MessageLog.traceError(this.getClass(), (String)"AttrList Exception", (Throwable)moAccessException);
                }
                if (object instanceof java.lang.Object[]) {
                    objectArray = (java.lang.Object[])object;
                    n2 = objectArray.length;
                    this.data.append(" Array " + ObjectHelper.getObjectByType(objectArray) + " " + Integer.toString(n2));
                    this.handleContainedArray(objectArray);
                    continue;
                }
                this.handleAllObjects(object, false);
            }
        }
    }

    private void handleArray(java.lang.Object[] objectArray) {
        if (objectArray.length > 0) {
            this.data.append("\n\tArray " + ObjectHelper.getObjectByType(objectArray[0]) + " " + Integer.toString(objectArray.length));
            String[] stringArray = ObjectHelper.getSequenceObjectValue(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                this.data.append("\n\t\t" + stringArray[i]);
            }
        } else {
            this.handleEmptyArray(objectArray);
        }
    }

    private void handleEmptyArray(java.lang.Object object) {
        if (this.cmdName.equals("ACTION")) {
            this.data.append("\n ");
        }
        if (object instanceof int[]) {
            this.data.append(" \tArray Integer 0");
        } else if (object instanceof float[]) {
            this.data.append(" \tArray Float 0");
        } else if (object instanceof boolean[]) {
            this.data.append(" \tArray Boolean 0");
        } else if (object instanceof long[]) {
            this.data.append(" \tArray Long 0");
        } else {
            this.data.append(" \tArray " + ObjectHelper.getObjectByType(object) + " 0");
        }
    }

    private void handleObject(java.lang.Object object, boolean bl) {
        if (this.cmdName.equals("ACTION") && !bl) {
            this.data.append("\n ");
        }
        if (object instanceof int[]) {
            this.data.append(" Array Integer " + ObjectHelper.getObjectValue(object));
        } else if (object instanceof float[]) {
            this.data.append(" Array Float " + ObjectHelper.getObjectValue(object));
        } else if (object instanceof boolean[]) {
            this.data.append(" Array Boolean " + ObjectHelper.getObjectValue(object));
        } else if (object instanceof long[]) {
            this.data.append(" Array Long " + ObjectHelper.getObjectValue(object));
        } else {
            this.data.append(ObjectHelper.getObjectByType(object) + " " + ObjectHelper.getObjectValue(object));
        }
    }

    private void handleStruct(Struct struct, boolean bl) {
        if (this.cmdName.equals("ACTION") && !bl) {
            this.data.append("\n\t" + ObjectHelper.getObjectByType(struct));
        } else {
            this.data.append(" " + ObjectHelper.getObjectByType(struct));
        }
        this.handleStructInArray(struct);
    }

    private void handleStructInArray(Struct struct) {
        int n;
        String[] stringArray = struct.getNames();
        java.lang.Object[] objectArray = new java.lang.Object[struct.size()];
        for (n = 0; n < objectArray.length; ++n) {
            try {
                objectArray[n] = struct.getValue(stringArray[n]);
                continue;
            }
            catch (MoNotFoundException moNotFoundException) {
                objectArray[n] = new ManagedObjectDeleted();
                MessageLog.info(this.getClass(), (String)"The CORBA AuditTrailLog could not store the correct LDN because the MO in question has already been deleted.");
                continue;
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError(this.getClass(), (String)"Struct exception", (Throwable)moAccessException);
            }
        }
        this.data.append("\n\tnrOfElements " + Integer.toString(struct.size()));
        try {
            for (n = 0; n < struct.size(); ++n) {
                this.data.append("\n\t\t" + stringArray[n] + " ");
                this.handleAllObjects(objectArray[n], true);
            }
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)"Struct exception", (Throwable)exception);
        }
    }

    private void handleAllObjects(java.lang.Object object, boolean bl) {
        if (object instanceof Struct) {
            this.handleStruct((Struct)object, bl);
        } else if (object instanceof java.lang.Object[]) {
            this.handleArray((java.lang.Object[])object);
        } else {
            this.handleObject(object, bl);
        }
    }

    private String removeSpecialCharacters(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        do {
            int n;
            int n2;
            if ((n2 = stringBuffer.indexOf("<")) != -1) {
                stringBuffer = stringBuffer.replace(n2, n2 + 1, "&lt;");
            }
            if ((n = stringBuffer.indexOf(">")) == -1) continue;
            stringBuffer = stringBuffer.replace(n, n + 1, "&gt;");
        } while (stringBuffer.indexOf("<") != -1 || stringBuffer.indexOf(">") != -1);
        return stringBuffer.toString();
    }

    public String getRemoteIP() {
        String string = null;
        try {
            Object object = CelloOrb.instance().getOrb().resolve_initial_references("JacOrbIIOPTransportCurrent");
            Current current = CurrentHelper.narrow((java.lang.Object)object);
            string = current.remote_host() + ":" + current.remote_port();
            MessageLog.trace((int)5, this.getClass(), (String)("Operation performed from=" + string + ", to=" + current.local_host() + ":" + current.local_port()));
        }
        catch (Exception exception) {
            MessageLog.info(this.getClass(), (String)("Failed to fetch remote host details: " + exception.toString() + ExceptionHelper.stackToString(exception.getStackTrace())));
            return null;
        }
        return string;
    }

    static class ManagedObjectDeleted {
        ManagedObjectDeleted() {
        }
    }
}

