/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configirpimpl;

import java.util.HashSet;
import java.util.Set;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;

public class AsynchronousTxCollector {
    private Set txActionSet = new HashSet();
    private static AsynchronousTxCollector instance = new AsynchronousTxCollector();

    private AsynchronousTxCollector() {
    }

    public static AsynchronousTxCollector instance() {
        return instance;
    }

    public void register(Coordinator coordinator) {
        TxResource txResource = new TxResource(coordinator, this);
        try {
            coordinator.registerResource((Resource)txResource);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            // empty catch block
        }
        this.txActionSet.add(new Integer(coordinator.getTransactionID()));
    }

    public boolean lookup(int n) {
        return this.txActionSet.contains(new Integer(n));
    }

    private static class TxResource
    implements Resource {
        private Coordinator c;
        private AsynchronousTxCollector delegate;

        public TxResource(Coordinator coordinator, AsynchronousTxCollector asynchronousTxCollector) {
            this.c = coordinator;
            this.delegate = asynchronousTxCollector;
        }

        public void commit() {
            this.delegate.txActionSet.remove(new Integer(this.c.getTransactionID()));
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
            this.delegate.txActionSet.remove(new Integer(this.c.getTransactionID()));
        }
    }
}

