/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.faultmanagement;

import CelloAlarmIRPExtension.AlarmIRPExtensionOperations;
import CelloAlarmIRPExtension.FilterType;
import CelloAlarmIRPExtension.FilterTypeKind;
import CelloAlarmIRPExtension.GetAlarmCountExt;
import CelloAlarmIRPExtension.GetAlarmListExt;
import CelloAlarmIRPExtension.GetAllModifiedSeverity;
import CelloAlarmIRPExtension.RemoveSeverityConfiguration;
import CelloAlarmIRPExtension.SetSeverity;
import CelloAlarmIRPExtension.SeverityInfo;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.IntHolder;
import org.omg.CosNotification.EventHeader;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.FixedEventHeader;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.TimeBase.UtcT;
import org.omg.TimeBase.UtcTHelper;
import org.threegppsa5.AlarmIRPConstDefs.AlarmInformationIdSeqHolder;
import org.threegppsa5.AlarmIRPSystem.AcknowledgeAlarms;
import org.threegppsa5.AlarmIRPSystem.AlarmInformationIteratorHolder;
import org.threegppsa5.AlarmIRPSystem.GetAlarmCount;
import org.threegppsa5.AlarmIRPSystem.GetAlarmIRPVersion;
import org.threegppsa5.AlarmIRPSystem.GetAlarmList;
import org.threegppsa5.AlarmIRPSystem.InvalidParameter;
import org.threegppsa5.AlarmIRPSystem.OperationNotSupported;
import org.threegppsa5.AlarmIRPSystem.ParameterNotSupported;
import org.threegppsa5.AlarmIRPSystem.UnacknowledgeAlarms;
import org.threegppsa5.CommonIRPConstDefs.Signal;
import se.ericsson.cello.faultmanagement.Alarm;
import se.ericsson.cello.faultmanagement.SeverityConfiguration;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.notification.Filter;
import se.ericsson.cello.notification.NotificationIRPImpl;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.MessageLog;

public final class AlarmIRP_1Impl
implements AlarmIRPExtensionOperations {
    private static final int CONVERT_MS_TO_100NS = 10000;
    private static final int MILLISEC = 1000;
    private static final int SEC = 60;
    private static AlarmIRP_1Impl theOneAndOnly = new AlarmIRP_1Impl();

    public static AlarmIRP_1Impl instance() {
        return theOneAndOnly;
    }

    public synchronized Signal acknowledge_alarms(String[] stringArray, String string, String string2, AlarmInformationIdSeqHolder alarmInformationIdSeqHolder) throws AcknowledgeAlarms, ParameterNotSupported, InvalidParameter {
        try {
            short s = 1;
            Signal signal = Signal.OK;
            Vector<String> vector = new Vector<String>();
            if (string == null || string.length() == 0) {
                throw new InvalidParameter("Invalid ack_user_id");
            }
            if (string2 != null && string2.length() != 0) {
                throw new ParameterNotSupported("ack_system_id not supported");
            }
            if (stringArray.length == 0) {
                MessageLog.info((Class)AlarmIRP_1Impl.class, (String)"alarm_information_id_list.length == 0");
                signal = Signal.Failure;
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    Alarm alarm = Alarm.lookup(stringArray[i]);
                    if (alarm != null) {
                        if (alarm.getAckState() != 2) {
                            vector.addElement(stringArray[i]);
                        }
                        Alarm.setAckStatus(alarm, string, string2, s);
                        continue;
                    }
                    vector.addElement(stringArray[i]);
                }
                Object[] objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                alarmInformationIdSeqHolder.value = objectArray;
                if (vector.size() != 0) {
                    signal = vector.size() == stringArray.length ? Signal.Failure : Signal.PartialFailure;
                }
            }
            return signal;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"acknowledge_alarms: ", (Throwable)runtimeException);
            throw new AcknowledgeAlarms(runtimeException.toString());
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"acknowledge_alarms: ", (Throwable)error);
            throw new AcknowledgeAlarms(error.toString());
        }
    }

    public synchronized Signal unacknowledge_alarms(String[] stringArray, String string, String string2, AlarmInformationIdSeqHolder alarmInformationIdSeqHolder) throws UnacknowledgeAlarms, OperationNotSupported, ParameterNotSupported, InvalidParameter {
        try {
            short s = 2;
            Signal signal = Signal.OK;
            Vector<String> vector = new Vector<String>();
            if (string == null || string.length() == 0) {
                throw new InvalidParameter("Invalid ack_user_id");
            }
            if (string2 != null && string2.length() != 0) {
                throw new ParameterNotSupported("ack_system_id not supported");
            }
            if (stringArray.length == 0) {
                signal = Signal.Failure;
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    Alarm alarm = Alarm.lookup(stringArray[i]);
                    if (alarm != null) {
                        Alarm.setAckStatus(alarm, string, string2, s);
                        continue;
                    }
                    vector.addElement(stringArray[i]);
                }
                Object[] objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                alarmInformationIdSeqHolder.value = objectArray;
                if (vector.size() != 0) {
                    signal = vector.size() == stringArray.length ? Signal.Failure : Signal.PartialFailure;
                }
            }
            return signal;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"unacknowledge_alarms: ", (Throwable)runtimeException);
            throw new UnacknowledgeAlarms(runtimeException.toString());
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"unacknowledge_alarms: ", (Throwable)error);
            throw new UnacknowledgeAlarms(error.toString());
        }
    }

    public StructuredEvent[] get_alarm_list(String string, BooleanHolder booleanHolder, AlarmInformationIteratorHolder alarmInformationIteratorHolder) throws GetAlarmList, ParameterNotSupported, InvalidParameter {
        try {
            if (string != null && string.length() != 0) {
                throw new ParameterNotSupported("Filter not supported!");
            }
            booleanHolder.value = true;
            alarmInformationIteratorHolder.value = null;
            return Alarm.getAlarmListAsStructuredEvents();
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"get_alarm_list: ", (Throwable)runtimeException);
            throw new GetAlarmList(runtimeException.toString());
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"get_alarm_list: ", (Throwable)error);
            throw new GetAlarmList(error.toString());
        }
    }

    public void get_alarm_count(String string, IntHolder intHolder, IntHolder intHolder2, IntHolder intHolder3, IntHolder intHolder4, IntHolder intHolder5, IntHolder intHolder6) throws GetAlarmCount, OperationNotSupported, ParameterNotSupported, InvalidParameter {
        if (string != null && string.length() != 0) {
            throw new ParameterNotSupported("Filter not supported!");
        }
        try {
            Enumeration enumeration = Alarm.lookupAll();
            this.getAlarmCount(enumeration, intHolder, intHolder2, intHolder3, intHolder4, intHolder5, intHolder6);
            return;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"get_alarm_count: ", (Throwable)runtimeException);
            throw new GetAlarmCount(runtimeException.toString());
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"get_alarm_count: ", (Throwable)error);
            throw new GetAlarmCount(error.toString());
        }
    }

    public String[] get_alarm_IRP_version() throws GetAlarmIRPVersion {
        try {
            return new String[]{"1f1", "1fx1"};
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"get_alarm_IRP_version: ", (Throwable)runtimeException);
            throw new GetAlarmIRPVersion(runtimeException.toString());
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"get_alarm_IRP_version: ", (Throwable)error);
            throw new GetAlarmIRPVersion(error.toString());
        }
    }

    public StructuredEvent[] get_alarm_list_ext(FilterType filterType) throws GetAlarmListExt, InvalidParameter {
        try {
            Filter filter = this.lookupAndCheck(filterType);
            return Alarm.getAlarmListAsStructuredEvents(filter);
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"get_alarm_list_ext: ", (Throwable)runtimeException);
            throw new GetAlarmListExt(runtimeException.toString());
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"get_alarm_list_ext: ", (Throwable)error);
            throw new GetAlarmListExt(error.toString());
        }
    }

    public void get_alarm_count_ext(FilterType filterType, IntHolder intHolder, IntHolder intHolder2, IntHolder intHolder3, IntHolder intHolder4, IntHolder intHolder5, IntHolder intHolder6) throws GetAlarmCountExt, InvalidParameter {
        try {
            Filter filter = this.lookupAndCheck(filterType);
            Enumeration enumeration = Alarm.lookupAll(filter);
            this.getAlarmCount(enumeration, intHolder, intHolder2, intHolder3, intHolder4, intHolder5, intHolder6);
            return;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"get_alarm_count_ext: ", (Throwable)runtimeException);
            throw new GetAlarmCountExt(runtimeException.toString());
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"get_alarm_count_ext: ", (Throwable)error);
            throw new GetAlarmCountExt(error.toString());
        }
    }

    public void set_severity(String string, short s) throws SetSeverity, InvalidParameter {
        try {
            if (s < 1 || s > 6) {
                throw new InvalidParameter("severity");
            }
            SeverityConfiguration.instance().setSeverity(string, s);
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"set_severity: ", (Throwable)runtimeException);
            throw new SetSeverity(runtimeException.toString());
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"set_severity: ", (Throwable)error);
            throw new SetSeverity(error.toString());
        }
    }

    public SeverityInfo[] get_all_modified_severity() throws GetAllModifiedSeverity {
        try {
            return SeverityConfiguration.instance().getAllSeverityConfigurations();
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"get_all_modified_severity: ", (Throwable)runtimeException);
            throw new GetAllModifiedSeverity(runtimeException.toString());
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"get_all_modified_severity: ", (Throwable)error);
            throw new GetAllModifiedSeverity(error.toString());
        }
    }

    public void remove_severity_configuration(String[] stringArray) throws RemoveSeverityConfiguration {
        try {
            SeverityConfiguration.instance().removeSeverityConfiguration(stringArray);
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"remove_severity_configuration: ", (Throwable)runtimeException);
            throw new RemoveSeverityConfiguration(runtimeException.toString());
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"remove_severity_configuration: ", (Throwable)error);
            throw new RemoveSeverityConfiguration(error.toString());
        }
    }

    void notifyAlarm(StructuredEvent structuredEvent) {
        NotificationIRPImpl.instance().enqueue(structuredEvent);
    }

    void notifyAlarm(StructuredEvent structuredEvent, short s, String string, String string2) {
        NotificationIRPImpl.instance().enqueue(structuredEvent, s, string, string2);
    }

    public void notifyAlarmListRebuilt() {
        Any any;
        EventHeader eventHeader;
        StructuredEvent structuredEvent = new StructuredEvent();
        structuredEvent.filterable_data = new Property[5];
        int n = 0;
        String string = MibMgr.instance().getMib().getMibPrefix();
        String string2 = MibMgr.instance().getMib().getRootMo().getFullDistinguishedName();
        String string3 = MibMgr.instance().getMib().getRootMo().getType();
        short s = 0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        short s2 = (short)(gregorianCalendar.get(15) / 60000);
        long l = 10000L * (gregorianCalendar.getTime().getTime() - gregorianCalendar.getGregorianChange().getTime());
        UtcT utcT = new UtcT(l, 0, s, s2);
        Any any2 = CelloOrb.instance().create_any();
        any2.insert_string(string3);
        structuredEvent.filterable_data[n++] = new Property("e", any2);
        Any any3 = CelloOrb.instance().create_any();
        any3.insert_string(string2);
        structuredEvent.filterable_data[n++] = new Property("f", any3);
        Any any4 = CelloOrb.instance().create_any();
        any4.insert_long(NotificationIRPImpl.instance().getNotificationId());
        structuredEvent.filterable_data[n++] = new Property("a", any4);
        Any any5 = CelloOrb.instance().create_any();
        UtcTHelper.insert(any5, utcT);
        structuredEvent.filterable_data[n++] = new Property("c", any5);
        Any any6 = CelloOrb.instance().create_any();
        any6.insert_string(string);
        structuredEvent.filterable_data[n++] = new Property("d", any6);
        EventType eventType = new EventType("1f1", "");
        FixedEventHeader fixedEventHeader = new FixedEventHeader(eventType, "x5");
        structuredEvent.header = eventHeader = new EventHeader(fixedEventHeader, new Property[0]);
        structuredEvent.remainder_of_body = any = CelloOrb.instance().create_any();
        this.notifyAlarm(structuredEvent);
    }

    private Filter lookupAndCheck(FilterType filterType) throws InvalidParameter {
        Filter filter = null;
        FilterTypeKind filterTypeKind = filterType.discriminator();
        if (filterTypeKind == FilterTypeKind.FilterMember) {
            CelloNotificationIRPExtension.Filter filter2 = filterType.filter();
            try {
                filter = new Filter(filter2);
            }
            catch (Filter.EmptyFilterException emptyFilterException) {
            }
            catch (Filter.FilterSizeException filterSizeException) {
                throw new InvalidParameter("filter size");
            }
            catch (Filter.FilterSeverityException filterSeverityException) {
                throw new InvalidParameter("severity");
            }
        } else if (filterTypeKind == FilterTypeKind.SubscriptionMember) {
            filter = NotificationIRPImpl.instance().getFilter(this.checkSubscription(filterType.subscription_id()));
        }
        return filter;
    }

    private long checkSubscription(String string) throws InvalidParameter {
        long l;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidParameter("subscription id");
        }
        if (!NotificationIRPImpl.instance().isSubscriptionRegistered(l)) {
            throw new InvalidParameter("subscription id");
        }
        return l;
    }

    private void getAlarmCount(Enumeration enumeration, IntHolder intHolder, IntHolder intHolder2, IntHolder intHolder3, IntHolder intHolder4, IntHolder intHolder5, IntHolder intHolder6) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (enumeration.hasMoreElements()) {
            Alarm alarm = (Alarm)enumeration.nextElement();
            short s = alarm.getPerceivedSeverity();
            if (s == 2) {
                ++n;
                continue;
            }
            if (s == 3) {
                ++n2;
                continue;
            }
            if (s == 4) {
                ++n3;
                continue;
            }
            if (s == 5) {
                ++n4;
                continue;
            }
            if (s == 1) {
                ++n5;
                continue;
            }
            if (s != 6) continue;
            ++n6;
        }
        intHolder.value = n;
        intHolder2.value = n2;
        intHolder3.value = n3;
        intHolder4.value = n4;
        intHolder5.value = n5;
        intHolder6.value = n6;
    }

    private AlarmIRP_1Impl() {
    }
}

