/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework.internal;

import java.util.Iterator;
import se.ericsson.cello.moframework.Mopplet;
import se.ericsson.cello.moframework.MoppletExtended;
import se.ericsson.cello.moframework.internal.MoppletInvocation;
import se.ericsson.cello.moframework.internal.SortedMopplets;
import se.ericsson.cello.support.debug.MessageLog;

public class MoppletRunner {
    private static final int TRACE_GROUP = 5;
    private SortedMopplets mopplets = new SortedMopplets();

    public void add(Mopplet mopplet) {
        this.mopplets.add(mopplet);
    }

    public void invoke(MoppletInvocation moppletInvocation) throws NullPointerException {
        if (moppletInvocation == null) {
            throw new NullPointerException("invocation was NULL");
        }
        Iterator iterator = this.mopplets.iterator();
        while (iterator.hasNext()) {
            Mopplet mopplet = (Mopplet)iterator.next();
            try {
                MessageLog.trace((int)5, this.getClass(), (String)("Invoking mopplet: " + mopplet.getClass().getName()));
                moppletInvocation.execute(mopplet);
            }
            catch (Throwable throwable) {
                MessageLog.traceError(this.getClass(), (String)("Error invoking mopplet " + mopplet.getClass().getName()), (Throwable)throwable);
            }
        }
    }

    public void init() {
        this.invoke(new MoppletInvocation(){

            public void execute(Mopplet mopplet) {
                mopplet.init();
            }
        });
    }

    public void start() {
        this.invoke(new MoppletInvocation(){

            public void execute(Mopplet mopplet) {
                mopplet.start();
            }
        });
    }

    public void finish() {
        this.invoke(new MoppletInvocation(){

            public void execute(Mopplet mopplet) {
                if (mopplet instanceof MoppletExtended) {
                    ((MoppletExtended)mopplet).finish();
                }
            }
        });
    }
}

