/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import se.ericsson.cello.moframework.internal.DbObjectTable;
import se.ericsson.cello.persistence.DbAccessException;
import se.ericsson.cello.persistence.DbWrapper;
import se.ericsson.cello.transaction.Coordinator;

public class RealDbObjectTable
implements DbObjectTable {
    private DbWrapper wrapper;

    public RealDbObjectTable(String string) throws DbAccessException {
        this.wrapper = new DbWrapper(string);
    }

    public int[] getPrimaryKeys() throws DbAccessException {
        this.wrapper.connectToDatabase();
        int[] nArray = this.wrapper.retrieveAllPrimaryKeys();
        this.wrapper.disconnectFromDatabase();
        return nArray;
    }

    public Object getRow(int n) throws DbAccessException {
        Object object = null;
        this.wrapper.connectToDatabase();
        try {
            byte[] byArray = this.wrapper.retrieveRow(n);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.wrapper.disconnectFromDatabase();
        return object;
    }

    public void createRow(int n, Object object, Coordinator coordinator) throws DbAccessException {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.wrapper.createRow(coordinator.getTransactionID(), n);
        this.wrapper.updateRow(coordinator.getTransactionID(), n, byArray);
    }

    public void deleteRow(int n, Coordinator coordinator) throws DbAccessException {
        this.wrapper.deleteRow(coordinator.getTransactionID(), n);
    }
}

